/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.js.PredefinedAnnotation;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.resolve.diagnostics.JsExternalChecker;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDeclarationWithInitializer;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J(\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010\u0016\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0017\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0018\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0014\u0010\u001c\u001a\u00020\u001a*\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0014\u0010\u001e\u001a\u00020\u001a*\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\f\u0010 \u001a\u00020\u001a*\u00020!H\u0002J\f\u0010\"\u001a\u00020\u001a*\u00020!H\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsExternalChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "DEFINED_EXTERNALLY_PROPERTY_NAMES", "", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "getDEFINED_EXTERNALLY_PROPERTY_NAMES", "()Ljava/util/Set;", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkAnonymousInitializer", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "checkBody", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "checkConstructorPropertyParam", "checkDelegation", "checkEnumEntry", "isDirectlyExternal", "", "isPrivateMemberOfExternalClass", "hasValidExternalBody", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "isDefinedExternallyExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isNonAbstractMemberOfInterface", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "isNullableProperty", "js.frontend"})
public final class JsExternalChecker
implements DeclarationChecker {
    @NotNull
    public static final JsExternalChecker INSTANCE = new JsExternalChecker();
    @NotNull
    private static final Set<FqNameUnsafe> DEFINED_EXTERNALLY_PROPERTY_NAMES;

    private JsExternalChecker() {
    }

    @NotNull
    public final Set<FqNameUnsafe> getDEFINED_EXTERNALLY_PROPERTY_NAMES() {
        return DEFINED_EXTERNALLY_PROPERTY_NAMES;
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        DeclarationDescriptor it;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!AnnotationsUtils.isNativeObject(descriptor2)) {
            return;
        }
        BindingTrace trace = context.getTrace();
        if (!DescriptorUtils.isTopLevelDeclaration(descriptor2) && this.isDirectlyExternal(declaration, descriptor2) && !(descriptor2 instanceof PropertyAccessorDescriptor)) {
            trace.report(ErrorsJs.NESTED_EXTERNAL_DECLARATION.on((KtExpression)((PsiElement)declaration)));
        }
        if (descriptor2 instanceof ClassDescriptor) {
            String classKind;
            String string2 = ((ClassDescriptor)descriptor2).isData() ? "data class" : (((ClassDescriptor)descriptor2).isInner() ? "inner class" : (((ClassDescriptor)descriptor2).isInline() ? "inline class" : (((ClassDescriptor)descriptor2).isValue() ? "value class" : (((ClassDescriptor)descriptor2).isFun() ? "fun interface" : (classKind = DescriptorUtils.isAnnotationClass(descriptor2) ? "annotation class" : null)))));
            if (classKind != null) {
                trace.report(ErrorsJs.WRONG_EXTERNAL_DECLARATION.on((KtExpression)((PsiElement)declaration), classKind));
            }
        }
        if (descriptor2 instanceof PropertyAccessorDescriptor && this.isDirectlyExternal(declaration, descriptor2)) {
            trace.report(ErrorsJs.WRONG_EXTERNAL_DECLARATION.on((KtExpression)((PsiElement)declaration), "property accessor"));
        } else if (this.isPrivateMemberOfExternalClass(descriptor2)) {
            trace.report(ErrorsJs.WRONG_EXTERNAL_DECLARATION.on((KtExpression)((PsiElement)declaration), "private member of class"));
        }
        if (descriptor2 instanceof ClassDescriptor && ((ClassDescriptor)descriptor2).getKind() != ClassKind.INTERFACE) {
            it = ((ClassDescriptor)descriptor2).getContainingDeclaration();
            boolean bl = false;
            boolean bl2 = it instanceof ClassDescriptor && ((ClassDescriptor)it).getKind() == ClassKind.INTERFACE;
            if (bl2) {
                trace.report(ErrorsJs.NESTED_CLASS_IN_EXTERNAL_INTERFACE.on((KtExpression)((PsiElement)declaration)));
            }
        }
        if (!(descriptor2 instanceof PropertyAccessorDescriptor) && DescriptorUtilsKt.isExtension(descriptor2)) {
            it = descriptor2;
            String target = it instanceof FunctionDescriptor ? "extension function" : (it instanceof PropertyDescriptor ? "extension property" : "extension member");
            trace.report(ErrorsJs.WRONG_EXTERNAL_DECLARATION.on((KtExpression)((PsiElement)declaration), target));
        }
        if (descriptor2 instanceof ClassDescriptor && ((ClassDescriptor)descriptor2).getKind() != ClassKind.ANNOTATION_CLASS) {
            boolean bl;
            block19: {
                Set superClasses2 = CollectionsKt.toMutableSet((Iterable)CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object)DescriptorUtilsKt.getSuperClassNotAny((ClassDescriptor)descriptor2)), (Iterable)DescriptorUtilsKt.getSuperInterfaces((ClassDescriptor)descriptor2)));
                if (((ClassDescriptor)descriptor2).getKind() == ClassKind.ENUM_CLASS || ((ClassDescriptor)descriptor2).getKind() == ClassKind.ENUM_ENTRY) {
                    CollectionsKt.removeAll((Iterable)superClasses2, (Function1)check.2.INSTANCE);
                }
                Iterable $this$any$iv = superClasses2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ClassDescriptor it2 = (ClassDescriptor)element$iv;
                        boolean bl3 = false;
                        if (!(!AnnotationsUtils.isNativeObject(it2) && !Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe(it2), (Object)StandardNames.FqNames.throwable))) continue;
                        bl = true;
                        break block19;
                    }
                    bl = false;
                }
            }
            if (bl) {
                trace.report(ErrorsJs.EXTERNAL_TYPE_EXTENDS_NON_EXTERNAL_TYPE.on((KtElement)((PsiElement)declaration)));
            }
        }
        if (descriptor2 instanceof FunctionDescriptor && ((FunctionDescriptor)descriptor2).isInline()) {
            trace.report(ErrorsJs.INLINE_EXTERNAL_DECLARATION.on((KtDeclaration)((PsiElement)declaration)));
        }
        DiagnosticFactory0<KtElement> valueClassInExternalDiagnostic = context.getLanguageVersionSettings().supportsFeature(LanguageFeature.JsAllowValueClassesInExternals) ? ErrorsJs.INLINE_CLASS_IN_EXTERNAL_DECLARATION_WARNING : ErrorsJs.INLINE_CLASS_IN_EXTERNAL_DECLARATION;
        Intrinsics.checkNotNullExpressionValue(valueClassInExternalDiagnostic, (String)"valueClassInExternalDiagnostic");
        JsExternalChecker.check$reportOnParametersAndReturnTypesIf(descriptor2, declaration, trace, valueClassInExternalDiagnostic, (Function1<? super KotlinType, Boolean>)((Function1)check.4.INSTANCE));
        if (!context.getLanguageVersionSettings().supportsFeature(LanguageFeature.JsEnableExtensionFunctionInExternals)) {
            DiagnosticFactory0<KtElement> diagnosticFactory0 = ErrorsJs.EXTENSION_FUNCTION_IN_EXTERNAL_DECLARATION;
            Intrinsics.checkNotNullExpressionValue(diagnosticFactory0, (String)"EXTENSION_FUNCTION_IN_EXTERNAL_DECLARATION");
            JsExternalChecker.check$reportOnParametersAndReturnTypesIf(descriptor2, declaration, trace, diagnosticFactory0, (Function1<? super KotlinType, Boolean>)((Function1)check.5.INSTANCE));
        }
        if (descriptor2 instanceof CallableMemberDescriptor && this.isNonAbstractMemberOfInterface((CallableMemberDescriptor)descriptor2) && !this.isNullableProperty((CallableMemberDescriptor)descriptor2)) {
            trace.report(ErrorsJs.NON_ABSTRACT_MEMBER_OF_EXTERNAL_INTERFACE.on((KtExpression)((PsiElement)declaration)));
        }
        DiagnosticSink diagnosticSink = trace;
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
        this.checkBody(declaration, descriptor2, diagnosticSink, bindingContext);
        this.checkDelegation(declaration, descriptor2, trace);
        this.checkAnonymousInitializer(declaration, trace);
        this.checkEnumEntry(declaration, trace);
        this.checkConstructorPropertyParam(declaration, descriptor2, trace);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkBody(KtDeclaration declaration, DeclarationDescriptor descriptor2, DiagnosticSink diagnosticHolder, BindingContext bindingContext) {
        if (declaration instanceof KtProperty && descriptor2 instanceof PropertyAccessorDescriptor) {
            return;
        }
        if (declaration instanceof KtDeclarationWithBody && !this.hasValidExternalBody((KtDeclarationWithBody)declaration, bindingContext)) {
            KtExpression ktExpression = ((KtDeclarationWithBody)declaration).getBodyExpression();
            Intrinsics.checkNotNull((Object)ktExpression);
            diagnosticHolder.report(ErrorsJs.WRONG_BODY_OF_EXTERNAL_DECLARATION.on((KtExpression)((PsiElement)ktExpression)));
        } else if (declaration instanceof KtDeclarationWithInitializer) {
            KtExpression ktExpression = ((KtDeclarationWithInitializer)declaration).getInitializer();
            boolean bl = ktExpression != null ? !this.isDefinedExternallyExpression(ktExpression, bindingContext) : false;
            if (bl) {
                KtExpression ktExpression2 = ((KtDeclarationWithInitializer)declaration).getInitializer();
                Intrinsics.checkNotNull((Object)ktExpression2);
                diagnosticHolder.report(ErrorsJs.WRONG_INITIALIZER_OF_EXTERNAL_DECLARATION.on((KtExpression)((PsiElement)ktExpression2)));
            }
        }
        if (declaration instanceof KtCallableDeclaration) {
            void $this$mapNotNullTo$iv$iv;
            List<KtParameter> list2 = ((KtCallableDeclaration)declaration).getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"declaration.valueParameters");
            Iterable $this$mapNotNull$iv = list2;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                KtExpression it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                KtParameter it = (KtParameter)element$iv$iv;
                boolean bl2 = false;
                if (it.getDefaultValue() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            for (KtExpression defaultValue : (List)destination$iv$iv) {
                Intrinsics.checkNotNullExpressionValue((Object)defaultValue, (String)"defaultValue");
                if (this.isDefinedExternallyExpression(defaultValue, bindingContext)) continue;
                diagnosticHolder.report(ErrorsJs.WRONG_DEFAULT_VALUE_FOR_EXTERNAL_FUN_PARAMETER.on((KtExpression)((PsiElement)defaultValue)));
            }
        }
    }

    private final void checkDelegation(KtDeclaration declaration, DeclarationDescriptor descriptor2, DiagnosticSink diagnosticHolder) {
        block5: {
            block6: {
                block4: {
                    if (!(descriptor2 instanceof MemberDescriptor) || !DescriptorUtilsKt.isEffectivelyExternal((MemberDescriptor)descriptor2)) {
                        return;
                    }
                    if (!(declaration instanceof KtClassOrObject)) break block4;
                    for (KtSuperTypeListEntry superTypeEntry : ((KtClassOrObject)declaration).getSuperTypeListEntries()) {
                        KtSuperTypeListEntry ktSuperTypeListEntry = superTypeEntry;
                        if (ktSuperTypeListEntry instanceof KtSuperTypeCallEntry) {
                            KtValueArgumentList ktValueArgumentList = ((KtSuperTypeCallEntry)superTypeEntry).getValueArgumentList();
                            Intrinsics.checkNotNull((Object)ktValueArgumentList);
                            diagnosticHolder.report(ErrorsJs.EXTERNAL_DELEGATED_CONSTRUCTOR_CALL.on((KtElement)((PsiElement)ktValueArgumentList)));
                            continue;
                        }
                        if (!(ktSuperTypeListEntry instanceof KtDelegatedSuperTypeEntry)) continue;
                        diagnosticHolder.report(ErrorsJs.EXTERNAL_DELEGATION.on((KtElement)((PsiElement)superTypeEntry)));
                    }
                    break block5;
                }
                if (!(declaration instanceof KtSecondaryConstructor)) break block6;
                KtConstructorDelegationCall delegationCall = ((KtSecondaryConstructor)declaration).getDelegationCall();
                if (delegationCall.isImplicit()) break block5;
                diagnosticHolder.report(ErrorsJs.EXTERNAL_DELEGATED_CONSTRUCTOR_CALL.on((KtElement)((PsiElement)delegationCall)));
                break block5;
            }
            if (!(declaration instanceof KtProperty) || descriptor2 instanceof PropertyAccessorDescriptor) break block5;
            KtPropertyDelegate ktPropertyDelegate = ((KtProperty)declaration).getDelegate();
            if (ktPropertyDelegate != null) {
                KtPropertyDelegate delegate2 = ktPropertyDelegate;
                boolean bl = false;
                diagnosticHolder.report(ErrorsJs.EXTERNAL_DELEGATION.on((KtElement)((PsiElement)delegate2)));
            }
        }
    }

    private final void checkAnonymousInitializer(KtDeclaration declaration, DiagnosticSink diagnosticHolder) {
        if (!(declaration instanceof KtClassOrObject)) {
            return;
        }
        for (KtAnonymousInitializer anonymousInitializer : ((KtClassOrObject)declaration).getAnonymousInitializers()) {
            diagnosticHolder.report(ErrorsJs.EXTERNAL_ANONYMOUS_INITIALIZER.on((KtAnonymousInitializer)((PsiElement)anonymousInitializer)));
        }
    }

    private final void checkEnumEntry(KtDeclaration declaration, DiagnosticSink diagnosticHolder) {
        block1: {
            if (!(declaration instanceof KtEnumEntry)) {
                return;
            }
            KtClassBody ktClassBody = ((KtEnumEntry)declaration).getBody();
            if (ktClassBody == null) break block1;
            KtClassBody it = ktClassBody;
            boolean bl = false;
            diagnosticHolder.report(ErrorsJs.EXTERNAL_ENUM_ENTRY_WITH_BODY.on((KtClassBody)((PsiElement)it)));
        }
    }

    private final void checkConstructorPropertyParam(KtDeclaration declaration, DeclarationDescriptor descriptor2, DiagnosticSink diagnosticHolder) {
        if (!(descriptor2 instanceof PropertyDescriptor) || !(declaration instanceof KtParameter)) {
            return;
        }
        DeclarationDescriptor declarationDescriptor = ((PropertyDescriptor)descriptor2).getContainingDeclaration();
        Intrinsics.checkNotNull((Object)declarationDescriptor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        ClassDescriptor containingClass = (ClassDescriptor)declarationDescriptor;
        if (containingClass.isData() || DescriptorUtils.isAnnotationClass(containingClass)) {
            return;
        }
        diagnosticHolder.report(ErrorsJs.EXTERNAL_CLASS_CONSTRUCTOR_PROPERTY_PARAMETER.on((KtParameter)declaration));
    }

    private final boolean isDirectlyExternal(KtDeclaration declaration, DeclarationDescriptor descriptor2) {
        if (declaration instanceof KtProperty && descriptor2 instanceof PropertyAccessorDescriptor) {
            return false;
        }
        return declaration.hasModifier(KtTokens.EXTERNAL_KEYWORD) || AnnotationsUtils.hasAnnotation(descriptor2, PredefinedAnnotation.NATIVE);
    }

    private final boolean isPrivateMemberOfExternalClass(DeclarationDescriptor descriptor2) {
        if (descriptor2 instanceof PropertyAccessorDescriptor && Intrinsics.areEqual((Object)((PropertyAccessorDescriptor)descriptor2).getVisibility(), (Object)((PropertyAccessorDescriptor)descriptor2).getCorrespondingProperty().getVisibility())) {
            return false;
        }
        if (!(descriptor2 instanceof MemberDescriptor) || !Intrinsics.areEqual((Object)((MemberDescriptor)descriptor2).getVisibility(), (Object)DescriptorVisibilities.PRIVATE)) {
            return false;
        }
        DeclarationDescriptor declarationDescriptor = ((MemberDescriptor)descriptor2).getContainingDeclaration();
        ClassDescriptor classDescriptor = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
        if (classDescriptor == null) {
            return false;
        }
        ClassDescriptor containingDeclaration = classDescriptor;
        return AnnotationsUtils.isNativeObject(containingDeclaration);
    }

    private final boolean isNonAbstractMemberOfInterface(CallableMemberDescriptor $this$isNonAbstractMemberOfInterface) {
        return $this$isNonAbstractMemberOfInterface.getModality() != Modality.ABSTRACT && DescriptorUtils.isInterface($this$isNonAbstractMemberOfInterface.getContainingDeclaration()) && !($this$isNonAbstractMemberOfInterface instanceof PropertyAccessorDescriptor);
    }

    private final boolean isNullableProperty(CallableMemberDescriptor $this$isNullableProperty) {
        return $this$isNullableProperty instanceof PropertyDescriptor && TypeUtils.isNullableType(((PropertyDescriptor)$this$isNullableProperty).getType());
    }

    private final boolean hasValidExternalBody(KtDeclarationWithBody $this$hasValidExternalBody, BindingContext bindingContext) {
        boolean bl;
        if (!$this$hasValidExternalBody.hasBody()) {
            return true;
        }
        KtExpression ktExpression = $this$hasValidExternalBody.getBodyExpression();
        Intrinsics.checkNotNull((Object)ktExpression);
        KtExpression body2 = ktExpression;
        if (!$this$hasValidExternalBody.hasBlockBody()) {
            bl = this.isDefinedExternallyExpression(body2, bindingContext);
        } else if (body2 instanceof KtBlockExpression) {
            List<KtExpression> list2 = ((KtBlockExpression)body2).getStatements();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"body.statements");
            KtExpression ktExpression2 = (KtExpression)CollectionsKt.singleOrNull(list2);
            if (ktExpression2 == null) {
                return false;
            }
            KtExpression statement2 = ktExpression2;
            bl = this.isDefinedExternallyExpression(statement2, bindingContext);
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isDefinedExternallyExpression(KtExpression $this$isDefinedExternallyExpression, BindingContext bindingContext) {
        boolean bl;
        block5: {
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall($this$isDefinedExternallyExpression, bindingContext);
            CallableDescriptor callableDescriptor = resolvedCall2 != null ? resolvedCall2.getResultingDescriptor() : null;
            PropertyDescriptor propertyDescriptor = callableDescriptor instanceof PropertyDescriptor ? (PropertyDescriptor)callableDescriptor : null;
            if (propertyDescriptor == null) {
                return false;
            }
            PropertyDescriptor descriptor2 = propertyDescriptor;
            DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
            PackageFragmentDescriptor packageFragmentDescriptor = declarationDescriptor instanceof PackageFragmentDescriptor ? (PackageFragmentDescriptor)declarationDescriptor : null;
            if (packageFragmentDescriptor == null) {
                return false;
            }
            PackageFragmentDescriptor container = packageFragmentDescriptor;
            Iterable $this$any$iv = DEFINED_EXTERNALLY_PROPERTY_NAMES;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FqNameUnsafe it = (FqNameUnsafe)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameUnsafe(container), (Object)it.parent()) && Intrinsics.areEqual((Object)descriptor2.getName(), (Object)it.shortName()))) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final void check$reportOnParametersAndReturnTypesIf$checkTypeIsNotInlineClass(Function1<? super KotlinType, Boolean> $condition, BindingTrace trace, DiagnosticFactory0<KtElement> $diagnosticFactory, KotlinType type2, KtElement elementToReport) {
        if (((Boolean)$condition.invoke((Object)type2)).booleanValue()) {
            trace.report($diagnosticFactory.on((KtElement)((PsiElement)elementToReport)));
        }
    }

    private static final void check$reportOnParametersAndReturnTypesIf(DeclarationDescriptor $descriptor, KtDeclaration $declaration, BindingTrace trace, DiagnosticFactory0<KtElement> diagnosticFactory, Function1<? super KotlinType, Boolean> condition) {
        block3: {
            KtModifierListOwner elementToReport;
            if (!($descriptor instanceof CallableMemberDescriptor) || $descriptor instanceof PropertyAccessorDescriptor && ((PropertyAccessorDescriptor)$descriptor).isDefault()) break block3;
            for (ValueParameterDescriptor p : ((CallableMemberDescriptor)$descriptor).getValueParameters()) {
                SourceElement sourceElement = p.getSource();
                Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"p.source");
                PsiElement psiElement = PsiSourceElementKt.getPsi(sourceElement);
                KtParameter ktParameter = psiElement instanceof KtParameter ? (KtParameter)psiElement : null;
                KtDeclaration ktParam = ktParameter != null ? (KtDeclaration)ktParameter : $declaration;
                KotlinType kotlinType = p.getVarargElementType();
                if (kotlinType == null) {
                    KotlinType kotlinType2 = p.getType();
                    kotlinType = kotlinType2;
                    Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"p.type");
                }
                JsExternalChecker.check$reportOnParametersAndReturnTypesIf$checkTypeIsNotInlineClass(condition, trace, diagnosticFactory, kotlinType, ktParam);
            }
            KtDeclaration ktDeclaration = $declaration;
            KtModifierListOwner ktModifierListOwner = elementToReport = ktDeclaration instanceof KtCallableDeclaration ? (KtModifierListOwner)((KtCallableDeclaration)$declaration).getTypeReference() : (ktDeclaration instanceof KtPropertyAccessor ? (KtModifierListOwner)((KtPropertyAccessor)$declaration).getReturnTypeReference() : (KtModifierListOwner)$declaration);
            if (ktModifierListOwner != null) {
                KtModifierListOwner it = ktModifierListOwner;
                boolean bl = false;
                KotlinType kotlinType = ((CallableMemberDescriptor)$descriptor).getReturnType();
                Intrinsics.checkNotNull((Object)kotlinType);
                JsExternalChecker.check$reportOnParametersAndReturnTypesIf$checkTypeIsNotInlineClass(condition, trace, diagnosticFactory, kotlinType, it);
            }
        }
    }

    static {
        Object[] objectArray = new FqNameUnsafe[]{new FqNameUnsafe("kotlin.js.noImpl"), new FqNameUnsafe("kotlin.js.definedExternally")};
        DEFINED_EXTERNALLY_PROPERTY_NAMES = SetsKt.setOf((Object[])objectArray);
    }
}

