/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.PackageDirectoryCache;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.file.PsiPackageImpl;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.NonClasspathDirectoriesScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NonClasspathClassFinder
extends PsiElementFinder {
    private static final Logger LOG = Logger.getInstance(NonClasspathClassFinder.class);
    private static final EverythingGlobalScope ALL_SCOPE = new EverythingGlobalScope();
    protected final Project myProject;
    private volatile PackageDirectoryCache myCache;
    private final PsiManager myManager;
    private final String[] myFileExtensions;

    public NonClasspathClassFinder(@NotNull Project project, String ... fileExtensions) {
        if (project == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(0);
        }
        if (fileExtensions == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myManager = PsiManager.getInstance(this.myProject);
        this.myFileExtensions = ArrayUtil.append(fileExtensions, "class");
        Disposable extensionDisposable = ExtensionPointUtil.createExtensionDisposable(this, EP.getPoint(project));
        MessageBusConnection connection = project.getMessageBus().connect(extensionDisposable);
        connection.subscribe(VirtualFileManager.VFS_CHANGES, new BulkFileListener(){

            @Override
            public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                NonClasspathClassFinder.this.clearCache();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/psi/NonClasspathClassFinder$1", "after"));
            }
        });
        LowMemoryWatcher.register(() -> this.clearCache(), extensionDisposable);
    }

    @NotNull
    protected PackageDirectoryCache getCache(@Nullable GlobalSearchScope scope2) {
        PackageDirectoryCache cache2 = this.myCache;
        if (cache2 == null) {
            List<VirtualFile> roots = this.calcClassRoots();
            List<VirtualFile> invalidRoots = ContainerUtil.filter(roots, f -> !f.isValid());
            if (!invalidRoots.isEmpty()) {
                roots = ContainerUtil.filter(roots, VirtualFile::isValid);
                PluginException.logPluginError(LOG, "Invalid roots returned by " + this.getClass().getName() + ": " + invalidRoots, null, this.getClass());
            }
            this.myCache = cache2 = PackageDirectoryCache.createCache(roots);
        }
        PackageDirectoryCache packageDirectoryCache = cache2;
        if (packageDirectoryCache == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(2);
        }
        return packageDirectoryCache;
    }

    public void clearCache() {
        this.myCache = null;
    }

    protected List<VirtualFile> getClassRoots(@Nullable GlobalSearchScope scope2) {
        return this.getCache(scope2).getDirectoriesByPackageName("");
    }

    @Contract(pure=true)
    public List<VirtualFile> getClassRoots() {
        return this.getClassRoots(ALL_SCOPE);
    }

    @Override
    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope2) {
        if (qualifiedName == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(3);
        }
        if (scope2 == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(4);
        }
        Ref result2 = Ref.create();
        this.processDirectories(StringUtil.getPackageName(qualifiedName), scope2, dir2 -> {
            PsiClass[] classes;
            PsiFile file2;
            VirtualFile virtualFile = NonClasspathClassFinder.findChild(dir2, StringUtil.getShortName(qualifiedName), this.myFileExtensions);
            PsiFile psiFile = file2 = virtualFile == null ? null : this.myManager.findFile(virtualFile);
            if (file2 instanceof PsiClassOwner && (classes = ((PsiClassOwner)file2).getClasses()).length == 1) {
                result2.set(classes[0]);
                return false;
            }
            return true;
        });
        return (PsiClass)result2.get();
    }

    protected abstract List<VirtualFile> calcClassRoots();

    @Override
    public PsiClass @NotNull [] getClasses(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        if (psiPackage == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(5);
        }
        if (scope2 == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(6);
        }
        ArrayList result2 = new ArrayList();
        this.processDirectories(psiPackage.getQualifiedName(), scope2, dir2 -> {
            for (VirtualFile file2 : dir2.getChildren()) {
                PsiFile psi;
                if (file2.isDirectory() || !ArrayUtil.contains(file2.getExtension(), this.myFileExtensions) || !((psi = this.myManager.findFile(file2)) instanceof PsiClassOwner)) continue;
                ContainerUtil.addAll(result2, ((PsiClassOwner)psi).getClasses());
            }
            return true;
        });
        PsiClass[] psiClassArray = result2.toArray(PsiClass.EMPTY_ARRAY);
        if (psiClassArray == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(7);
        }
        return psiClassArray;
    }

    @Override
    @NotNull
    public Set<String> getClassNames(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        if (psiPackage == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(8);
        }
        if (scope2 == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(9);
        }
        HashSet<String> result2 = new HashSet<String>();
        this.processDirectories(psiPackage.getQualifiedName(), scope2, dir2 -> {
            for (VirtualFile file2 : dir2.getChildren()) {
                if (file2.isDirectory() || !ArrayUtil.contains(file2.getExtension(), this.myFileExtensions)) continue;
                result2.add(file2.getNameWithoutExtension());
            }
            return true;
        });
        HashSet<String> hashSet = result2;
        if (hashSet == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(10);
        }
        return hashSet;
    }

    @Override
    public PsiPackage findPackage(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(11);
        }
        CommonProcessors.FindFirstProcessor processor = new CommonProcessors.FindFirstProcessor();
        this.processDirectories(qualifiedName, ALL_SCOPE, processor);
        return processor.getFoundValue() != null ? this.createPackage(qualifiedName) : null;
    }

    private PsiPackageImpl createPackage(String qualifiedName) {
        return new PsiPackageImpl(this.myManager, qualifiedName);
    }

    @Override
    public boolean processPackageDirectories(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2, @NotNull Processor<? super PsiDirectory> consumer, boolean includeLibrarySources) {
        if (psiPackage == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(12);
        }
        if (scope2 == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(13);
        }
        if (consumer == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(14);
        }
        return this.processDirectories(psiPackage.getQualifiedName(), scope2, dir2 -> {
            PsiDirectory psiDirectory = psiPackage.getManager().findDirectory((VirtualFile)dir2);
            return psiDirectory == null || consumer.process(psiDirectory);
        });
    }

    private boolean processDirectories(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope2, @NotNull Processor<? super VirtualFile> processor) {
        if (qualifiedName == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(15);
        }
        if (scope2 == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(16);
        }
        if (processor == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(17);
        }
        if (scope2 instanceof EverythingGlobalScope) {
            scope2 = ALL_SCOPE;
        }
        GlobalSearchScope finalScope = scope2;
        return ContainerUtil.process(this.getCache(scope2).getDirectoriesByPackageName(qualifiedName), file2 -> !finalScope.contains((VirtualFile)file2) || processor.process((VirtualFile)file2));
    }

    @Override
    public PsiPackage @NotNull [] getSubPackages(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        if (psiPackage == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(18);
        }
        if (scope2 == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(19);
        }
        String pkgName = psiPackage.getQualifiedName();
        Set<String> names = this.getCache(scope2).getSubpackageNames(pkgName, scope2);
        if (names.isEmpty()) {
            PsiPackage[] psiPackageArray = super.getSubPackages(psiPackage, scope2);
            if (psiPackageArray == null) {
                NonClasspathClassFinder.$$$reportNull$$$0(20);
            }
            return psiPackageArray;
        }
        ArrayList<PsiPackageImpl> result2 = new ArrayList<PsiPackageImpl>();
        for (String name2 : names) {
            result2.add(this.createPackage(pkgName.isEmpty() ? name2 : pkgName + "." + name2));
        }
        PsiPackage[] psiPackageArray = result2.toArray(PsiPackage.EMPTY_ARRAY);
        if (psiPackageArray == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(21);
        }
        return psiPackageArray;
    }

    @Override
    public PsiClass @NotNull [] findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope2) {
        PsiClass[] psiClassArray;
        PsiClass psiClass;
        if (qualifiedName == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(22);
        }
        if (scope2 == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(23);
        }
        if ((psiClass = this.findClass(qualifiedName, scope2)) == null) {
            psiClassArray = PsiClass.EMPTY_ARRAY;
        } else {
            PsiClass[] psiClassArray2 = new PsiClass[1];
            psiClassArray = psiClassArray2;
            psiClassArray2[0] = psiClass;
        }
        if (psiClassArray == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(24);
        }
        return psiClassArray;
    }

    @NotNull
    public static GlobalSearchScope addNonClasspathScope(@NotNull Project project, @NotNull GlobalSearchScope base) {
        if (project == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(25);
        }
        if (base == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(26);
        }
        SmartList<GlobalSearchScope> nonClasspathScopes = new SmartList<GlobalSearchScope>();
        for (PsiElementFinder finder : EP.getExtensions(project)) {
            GlobalSearchScope scope2;
            if (!(finder instanceof NonClasspathClassFinder) || (scope2 = NonClasspathDirectoriesScope.compose(((NonClasspathClassFinder)finder).getClassRoots())) == GlobalSearchScope.EMPTY_SCOPE) continue;
            nonClasspathScopes.add(scope2);
        }
        if (nonClasspathScopes.isEmpty()) {
            GlobalSearchScope globalSearchScope = base;
            if (globalSearchScope == null) {
                NonClasspathClassFinder.$$$reportNull$$$0(27);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.union(ArrayUtil.prepend(base, nonClasspathScopes.toArray(GlobalSearchScope.EMPTY_ARRAY)));
        if (globalSearchScope == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(28);
        }
        return globalSearchScope;
    }

    public PsiManager getPsiManager() {
        return this.myManager;
    }

    @Nullable
    private static VirtualFile findChild(@NotNull VirtualFile root, @NotNull String relPath, String @NotNull [] extensions) {
        if (root == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(29);
        }
        if (relPath == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(30);
        }
        if (extensions == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(31);
        }
        VirtualFile file2 = null;
        for (String extension : extensions) {
            file2 = root.findChild(relPath + '.' + extension);
            if (file2 != null) break;
        }
        return file2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 10: 
            case 20: 
            case 21: 
            case 24: 
            case 27: 
            case 28: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 10: 
            case 20: 
            case 21: 
            case 24: 
            case 27: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileExtensions";
                break;
            }
            case 2: 
            case 7: 
            case 10: 
            case 20: 
            case 21: 
            case 24: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/NonClasspathClassFinder";
                break;
            }
            case 3: 
            case 11: 
            case 15: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 13: 
            case 16: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 5: 
            case 8: 
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiPackage";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relPath";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/NonClasspathClassFinder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCache";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasses";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassNames";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubPackages";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "findClasses";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "addNonClasspathScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 7: 
            case 10: 
            case 20: 
            case 21: 
            case 24: 
            case 27: 
            case 28: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getClasses";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getClassNames";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findPackage";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processPackageDirectories";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processDirectories";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getSubPackages";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findClasses";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addNonClasspathScope";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "findChild";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 7: 
            case 10: 
            case 20: 
            case 21: 
            case 24: 
            case 27: 
            case 28: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

