/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.compiled.ClassFileDecompilers;
import com.intellij.psi.stubs.BinaryFileStubBuilder;
import com.intellij.psi.stubs.Stub;
import com.intellij.util.cls.ClsFormatException;
import com.intellij.util.indexing.FileContent;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassFileStubBuilder
implements BinaryFileStubBuilder.CompositeBinaryFileStubBuilder<ClassFileDecompilers.Full> {
    private static final Logger LOG = Logger.getInstance(ClassFileStubBuilder.class);
    public static final int STUB_VERSION = 26;

    @Override
    public boolean acceptsFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ClassFileStubBuilder.$$$reportNull$$$0(0);
        }
        return true;
    }

    @Override
    @NotNull
    public Stream<ClassFileDecompilers.Full> getAllSubBuilders() {
        Stream<ClassFileDecompilers.Full> stream = ClassFileDecompilers.getInstance().EP_NAME.getExtensionList().stream().filter(d -> d instanceof ClassFileDecompilers.Full).map(d -> (ClassFileDecompilers.Full)d);
        if (stream == null) {
            ClassFileStubBuilder.$$$reportNull$$$0(1);
        }
        return stream;
    }

    @Override
    @Nullable
    public ClassFileDecompilers.Full getSubBuilder(@NotNull FileContent fileContent) {
        if (fileContent == null) {
            ClassFileStubBuilder.$$$reportNull$$$0(2);
        }
        return fileContent.getFile().computeWithPreloadedContentHint(fileContent.getContent(), () -> ClassFileDecompilers.getInstance().find(fileContent.getFile(), ClassFileDecompilers.Full.class));
    }

    @Override
    @NotNull
    public String getSubBuilderVersion(@Nullable ClassFileDecompilers.Full decompiler) {
        if (decompiler == null) {
            return "default";
        }
        int version2 = decompiler.getStubBuilder().getStubVersion();
        String string2 = decompiler.getClass().getName() + ":" + version2;
        if (string2 == null) {
            ClassFileStubBuilder.$$$reportNull$$$0(3);
        }
        return string2;
    }

    @Override
    @Nullable
    public Stub buildStubTree(@NotNull FileContent fileContent, @Nullable ClassFileDecompilers.Full decompiler) {
        if (fileContent == null) {
            ClassFileStubBuilder.$$$reportNull$$$0(4);
        }
        if (decompiler == null) {
            return null;
        }
        return fileContent.getFile().computeWithPreloadedContentHint(fileContent.getContent(), () -> {
            VirtualFile file2 = fileContent.getFile();
            try {
                return decompiler.getStubBuilder().buildFileStub(fileContent);
            }
            catch (ClsFormatException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(file2.getPath(), e);
                } else {
                    LOG.info(file2.getPath() + ": " + e.getMessage());
                }
                return null;
            }
        });
    }

    @Override
    public int getStubVersion() {
        return 26;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/compiled/ClassFileStubBuilder";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/compiled/ClassFileStubBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSubBuilders";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubBuilderVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "acceptsFile";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSubBuilder";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildStubTree";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

