/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.diff;

import com.intellij.util.diff.LCSBuilder;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Arrays;
import java.util.BitSet;

final class Reindexer {
    private final int[][] myOldIndices = new int[2][];
    private final int[] myOriginalLengths = new int[]{-1, -1};
    private final int[] myDiscardedLengths = new int[]{-1, -1};

    Reindexer() {
    }

    public int[][] discardUnique(int[] ints1, int[] ints2) {
        int[] discarded1 = this.discard(ints2, ints1, 0);
        return new int[][]{discarded1, this.discard(discarded1, ints2, 1)};
    }

    private int[] discard(int[] needed, int[] toDiscard, int arrayIndex) {
        this.myOriginalLengths[arrayIndex] = toDiscard.length;
        int[] sorted1 = Reindexer.createSorted(needed);
        IntArrayList discarded = new IntArrayList(toDiscard.length);
        IntArrayList oldIndices = new IntArrayList(toDiscard.length);
        for (int i = 0; i < toDiscard.length; ++i) {
            int index = toDiscard[i];
            if (Arrays.binarySearch(sorted1, index) < 0) continue;
            discarded.add(index);
            oldIndices.add(i);
        }
        this.myOldIndices[arrayIndex] = oldIndices.toIntArray();
        this.myDiscardedLengths[arrayIndex] = discarded.size();
        return discarded.toIntArray();
    }

    private static int[] createSorted(int[] ints1) {
        int[] sorted1 = (int[])ints1.clone();
        Arrays.sort(sorted1);
        return sorted1;
    }

    public void reindex(BitSet[] discardedChanges, LCSBuilder builder) {
        int y;
        int x;
        BitSet changes2;
        BitSet changes1;
        if (this.myDiscardedLengths[0] == this.myOriginalLengths[0] && this.myDiscardedLengths[1] == this.myOriginalLengths[1]) {
            changes1 = discardedChanges[0];
            changes2 = discardedChanges[1];
        } else {
            changes1 = new BitSet(this.myOriginalLengths[0]);
            changes2 = new BitSet(this.myOriginalLengths[1]);
            x = 0;
            y = 0;
            while (x < this.myDiscardedLengths[0] || y < this.myDiscardedLengths[1]) {
                if (x < this.myDiscardedLengths[0] && y < this.myDiscardedLengths[1] && !discardedChanges[0].get(x) && !discardedChanges[1].get(y)) {
                    x = Reindexer.increment(this.myOldIndices[0], x, changes1, this.myOriginalLengths[0]);
                    y = Reindexer.increment(this.myOldIndices[1], y, changes2, this.myOriginalLengths[1]);
                    continue;
                }
                if (discardedChanges[0].get(x)) {
                    changes1.set(Reindexer.getOriginal(this.myOldIndices[0], x));
                    x = Reindexer.increment(this.myOldIndices[0], x, changes1, this.myOriginalLengths[0]);
                    continue;
                }
                if (!discardedChanges[1].get(y)) continue;
                changes2.set(Reindexer.getOriginal(this.myOldIndices[1], y));
                y = Reindexer.increment(this.myOldIndices[1], y, changes2, this.myOriginalLengths[1]);
            }
            if (this.myDiscardedLengths[0] == 0) {
                changes1.set(0, this.myOriginalLengths[0]);
            } else {
                changes1.set(0, this.myOldIndices[0][0]);
            }
            if (this.myDiscardedLengths[1] == 0) {
                changes2.set(0, this.myOriginalLengths[1]);
            } else {
                changes2.set(0, this.myOldIndices[1][0]);
            }
        }
        x = 0;
        y = 0;
        while (x < this.myOriginalLengths[0] && y < this.myOriginalLengths[1]) {
            int startX = x;
            while (x < this.myOriginalLengths[0] && y < this.myOriginalLengths[1] && !changes1.get(x) && !changes2.get(y)) {
                ++x;
                ++y;
            }
            if (x > startX) {
                builder.addEqual(x - startX);
            }
            int dx = 0;
            int dy = 0;
            while (x < this.myOriginalLengths[0] && changes1.get(x)) {
                ++dx;
                ++x;
            }
            while (y < this.myOriginalLengths[1] && changes2.get(y)) {
                ++dy;
                ++y;
            }
            if (dx == 0 && dy == 0) continue;
            builder.addChange(dx, dy);
        }
        if (x != this.myOriginalLengths[0] || y != this.myOriginalLengths[1]) {
            builder.addChange(this.myOriginalLengths[0] - x, this.myOriginalLengths[1] - y);
        }
    }

    private static int getOriginal(int[] indexes, int i) {
        return indexes[i];
    }

    private static int increment(int[] indexes, int i, BitSet set, int length) {
        if (i + 1 < indexes.length) {
            set.set(indexes[i] + 1, indexes[i + 1]);
        } else {
            set.set(indexes[i] + 1, length);
        }
        return i + 1;
    }
}

