/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.UrlUtilRt;
import com.intellij.util.lang.ClassLoadingLocks;
import com.intellij.util.lang.ClassPath;
import com.intellij.util.lang.Loader;
import com.intellij.util.lang.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UrlClassLoader
extends ClassLoader
implements ClassPath.ClassDataConsumer {
    private static final boolean isParallelCapable = UrlClassLoader.registerAsParallelCapable();
    private static final ClassLoader appClassLoader = UrlClassLoader.class.getClassLoader();
    private static final ThreadLocal<Boolean> skipFindingResource = new ThreadLocal();
    private final List<Path> files;
    protected final ClassPath classPath;
    private final ClassLoadingLocks<String> classLoadingLocks;
    private final boolean isBootstrapResourcesAllowed;
    @NotNull
    protected final ClassPath.ClassDataConsumer classDataConsumer;

    @NotNull
    public final List<URL> getUrls() {
        ArrayList<URL> result2 = new ArrayList<URL>();
        for (Path file2 : this.files) {
            try {
                result2.add(file2.toUri().toURL());
            }
            catch (MalformedURLException malformedURLException) {}
        }
        ArrayList<URL> arrayList = result2;
        if (arrayList == null) {
            UrlClassLoader.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    public final boolean hasLoadedClass(String name2) {
        Class<?> aClass = this.findLoadedClass(name2);
        return aClass != null && aClass.getClassLoader() == this;
    }

    @Override
    protected Class<?> findClass(@NotNull String name2) throws ClassNotFoundException {
        Class<?> clazz;
        if (name2 == null) {
            UrlClassLoader.$$$reportNull$$$0(20);
        }
        if (name2.startsWith("com.intellij.util.lang.")) {
            return appClassLoader.loadClass(name2);
        }
        try {
            clazz = this.classPath.findClass(name2, this.classDataConsumer);
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name2, e);
        }
        if (clazz == null) {
            throw new ClassNotFoundException(name2);
        }
        return clazz;
    }

    private void definePackageIfNeeded(String name2, Loader loader) throws IOException {
        int lastDotIndex = name2.lastIndexOf(46);
        if (lastDotIndex == -1) {
            return;
        }
        String packageName2 = name2.substring(0, lastDotIndex);
        if (this.isPackageDefined(packageName2)) {
            return;
        }
        try {
            Map<Loader.Attribute, String> attributes = loader.getAttributes();
            if (attributes == null || attributes.isEmpty()) {
                this.definePackage(packageName2, null, null, null, null, null, null, null);
            } else {
                this.definePackage(packageName2, attributes.get((Object)Loader.Attribute.SPEC_TITLE), attributes.get((Object)Loader.Attribute.SPEC_VERSION), attributes.get((Object)Loader.Attribute.SPEC_VENDOR), attributes.get((Object)Loader.Attribute.IMPL_TITLE), attributes.get((Object)Loader.Attribute.IMPL_VERSION), attributes.get((Object)Loader.Attribute.IMPL_VENDOR), null);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected boolean isPackageDefined(String packageName2) {
        return this.getPackage(packageName2) != null;
    }

    protected ProtectionDomain getProtectionDomain() {
        return null;
    }

    @Override
    public Class<?> consumeClassData(@NotNull String name2, byte[] data, Loader loader, @Nullable ProtectionDomain protectionDomain) throws IOException {
        if (name2 == null) {
            UrlClassLoader.$$$reportNull$$$0(22);
        }
        this.definePackageIfNeeded(name2, loader);
        return super.defineClass(name2, data, 0, data.length, protectionDomain == null ? this.getProtectionDomain() : protectionDomain);
    }

    @Override
    @Nullable
    public URL findResource(@NotNull String name2) {
        if (name2 == null) {
            UrlClassLoader.$$$reportNull$$$0(24);
        }
        if (skipFindingResource.get() != null) {
            return null;
        }
        Resource resource = this.doFindResource(name2);
        return resource != null ? resource.getURL() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public InputStream getResourceAsStream(@NotNull String name2) {
        Resource resource;
        if (name2 == null) {
            UrlClassLoader.$$$reportNull$$$0(25);
        }
        if ((resource = this.doFindResource(name2)) != null) {
            try {
                return resource.getInputStream();
            }
            catch (IOException e) {
                this.logError("Cannot load resource " + name2, e);
                return null;
            }
        }
        if (this.isBootstrapResourcesAllowed) {
            skipFindingResource.set(Boolean.TRUE);
            try {
                URL url = super.getResource(name2);
                if (url != null) {
                    try {
                        InputStream inputStream = url.openStream();
                        return inputStream;
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                skipFindingResource.set(null);
            }
        }
        return null;
    }

    @Nullable
    private Resource doFindResource(String name2) {
        String canonicalPath2 = UrlClassLoader.toCanonicalPath(name2);
        Resource resource = this.classPath.findResource(canonicalPath2);
        if (resource == null && canonicalPath2.startsWith("/") && this.classPath.findResource(canonicalPath2.substring(1)) != null) {
            this.logError("Calling `ClassLoader#getResource` with leading slash doesn't work; strip", new IllegalArgumentException(name2));
        }
        return resource;
    }

    @Override
    @NotNull
    protected Enumeration<URL> findResources(@NotNull String name2) throws IOException {
        if (name2 == null) {
            UrlClassLoader.$$$reportNull$$$0(29);
        }
        Enumeration<URL> enumeration = this.classPath.getResources(name2);
        if (enumeration == null) {
            UrlClassLoader.$$$reportNull$$$0(30);
        }
        return enumeration;
    }

    @Override
    @NotNull
    protected final Object getClassLoadingLock(String className) {
        Object object = this.classLoadingLocks == null ? this : this.classLoadingLocks.getOrCreateLock(className);
        if (object == null) {
            UrlClassLoader.$$$reportNull$$$0(31);
        }
        return object;
    }

    protected static String toCanonicalPath(@NotNull String path) {
        char next;
        if (path == null) {
            UrlClassLoader.$$$reportNull$$$0(33);
        }
        if (path.isEmpty()) {
            return path;
        }
        if (path.charAt(0) == '.') {
            if (path.length() == 1) {
                return "";
            }
            char c = path.charAt(1);
            if (c == '/') {
                path = path.substring(2);
            }
        }
        int index = -1;
        do {
            char c = next = (index = path.indexOf(47, index + 1)) == path.length() - 1 ? (char)'\u0000' : path.charAt(index + 1);
        } while (next != '.' && next != '/' && index != -1);
        if (index == -1) {
            return path;
        }
        StringBuilder result2 = new StringBuilder(path.length());
        int start = UrlClassLoader.processRoot(path, result2);
        int dots = 0;
        boolean separator = true;
        for (int i = start; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '/') {
                if (!separator) {
                    UrlClassLoader.processDots(result2, dots, start);
                    dots = 0;
                }
                separator = true;
                continue;
            }
            if (c == '.') {
                if (separator || dots > 0) {
                    ++dots;
                } else {
                    result2.append('.');
                }
                separator = false;
                continue;
            }
            while (dots > 0) {
                result2.append('.');
                --dots;
            }
            result2.append(c);
            separator = false;
        }
        if (dots > 0) {
            UrlClassLoader.processDots(result2, dots, start);
        }
        return result2.toString();
    }

    private static void processDots(StringBuilder result2, int dots, int start) {
        if (dots == 2) {
            int pos = -1;
            if (!StringUtilRt.endsWith(result2, "/../") && !"../".contentEquals(result2)) {
                pos = StringUtilRt.lastIndexOf(result2, '/', start, result2.length() - 1);
                if (pos >= 0) {
                    ++pos;
                } else if (start > 0) {
                    pos = start;
                } else if (result2.length() > 0) {
                    pos = 0;
                }
            }
            if (pos >= 0) {
                result2.delete(pos, result2.length());
            } else {
                result2.append("../");
            }
        } else if (dots != 1) {
            for (int i = 0; i < dots; ++i) {
                result2.append('.');
            }
            result2.append('/');
        }
    }

    private static int processRoot(String path, StringBuilder result2) {
        if (!path.isEmpty() && path.charAt(0) == '/') {
            result2.append('/');
            return 1;
        }
        if (path.length() > 2 && path.charAt(1) == ':' && path.charAt(2) == '/') {
            result2.append(path, 0, 3);
            return 3;
        }
        return 0;
    }

    private void logError(String message, Throwable t) {
        try {
            Class<?> logger = Class.forName("com.intellij.openapi.diagnostic.Logger", false, this);
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Object instance2 = lookup.findStatic(logger, "getInstance", MethodType.methodType(logger, Class.class)).invoke(this.getClass());
            lookup.findVirtual(logger, "error", MethodType.methodType(Void.TYPE, String.class, Throwable.class)).bindTo(instance2).invokeExact(message, t);
        }
        catch (Throwable tt) {
            tt.addSuppressed(t);
            tt.printStackTrace(System.err);
        }
    }

    @NotNull
    public static String urlToFilePath(@NotNull String url) {
        if (url == null) {
            UrlClassLoader.$$$reportNull$$$0(34);
        }
        int start = url.startsWith("file:") ? "file:".length() : 0;
        int end = url.indexOf("!/");
        if (url.charAt(start) == '/' && url.length() > start + 2 && url.charAt(start + 2) == ':') {
            ++start;
        }
        String string2 = UrlUtilRt.unescapePercentSequences(url, start, end < 0 ? url.length() : end).toString();
        if (string2 == null) {
            UrlClassLoader.$$$reportNull$$$0(35);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 18: 
            case 19: 
            case 30: 
            case 31: 
            case 35: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 18: 
            case 19: 
            case 30: 
            case 31: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jar";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 18: 
            case 19: 
            case 30: 
            case 31: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/lang/UrlClassLoader";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLoader";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classPath";
                break;
            }
            case 16: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNameFilter";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/lang/UrlClassLoader";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassPath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadedClasses";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseUrls";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadingStats";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultBuilderForJdk";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrls";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "findResources";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassLoadingLock";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "urlToFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "appendToClassPathForInstrumentation";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 18: 
            case 19: 
            case 30: 
            case 31: 
            case 35: {
                break;
            }
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "registerInClassLoaderValueMap";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultBuilderForJdk";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addURL";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addFiles";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isByteBufferSupported";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "consumeClassData";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findResource";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getResourceAsStream";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "processResources";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "findResources";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "loadClassInsideSelf";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "toCanonicalPath";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "urlToFilePath";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 18: 
            case 19: 
            case 30: 
            case 31: 
            case 35: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

