/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.ir.ExpectSymbolTransformer;
import org.jetbrains.kotlin.backend.common.lower.ExpectDeclarationRemover;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContextKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.DeepCopyIrTreeWithSymbols;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import org.jetbrains.kotlin.ir.util.IrTypeParameterRemapper;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.ReferenceSymbolTable;
import org.jetbrains.kotlin.ir.util.ReferenceSymbolTableExtension;
import org.jetbrains.kotlin.ir.util.SymbolRemapper;
import org.jetbrains.kotlin.ir.util.TypeRemapper;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.multiplatform.ExpectedActualResolverKt;
import org.jetbrains.kotlin.resolve.multiplatform.OptionalAnnotationUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0017H\u0016J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001bH\u0016J\u0016\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001d2\u0006\u0010\u0019\u001a\u00020\u001eJ\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"H\u0014J\u0012\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010!\u001a\u00020%H\u0014J\u0012\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010!\u001a\u00020(H\u0014J\u0012\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010!\u001a\u00020+H\u0014J\u000e\u0010,\u001a\u0004\u0018\u00010-*\u00020-H\u0002J\u0010\u0010.\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001eH\u0002J\u0010\u0010/\u001a\u00020\u00062\u0006\u00100\u001a\u000201H\u0002J\u0010\u00102\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001bH\u0002J(\u00103\u001a\u000204*\u0002042\u0006\u00105\u001a\u00020\u00112\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u000e\u00107\u001a\u0004\u0018\u00010-*\u00020-H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u000e\u001a&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0010\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u00120\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/ExpectDeclarationRemover;", "Lorg/jetbrains/kotlin/backend/common/ir/ExpectSymbolTransformer;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/ReferenceSymbolTable;", "doRemove", "", "<init>", "(Lorg/jetbrains/kotlin/ir/util/ReferenceSymbolTable;Z)V", "context", "Lorg/jetbrains/kotlin/backend/common/BackendContext;", "(Lorg/jetbrains/kotlin/backend/common/BackendContext;)V", "getSymbolTable", "()Lorg/jetbrains/kotlin/ir/util/ReferenceSymbolTable;", "typeParameterSubstitutionMap", "", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParameter;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitFile", "declaration", "visitValueParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "transformFlat", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "getActualClass", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getActualProperty", "Lorg/jetbrains/kotlin/backend/common/ir/ExpectSymbolTransformer$ActualPropertyResult;", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "getActualConstructor", "Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "Lorg/jetbrains/kotlin/descriptors/ClassConstructorDescriptor;", "getActualFunction", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "findActualForExpect", "Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "shouldRemoveTopLevelDeclaration", "isOptionalAnnotationClass", "klass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "tryCopyDefaultArguments", "copyAndActualizeDefaultValue", "Lorg/jetbrains/kotlin/ir/expressions/IrExpressionBody;", "actualFunction", "expectActualTypeParametersMap", "findExpectForActual", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nExpectDeclarationRemover.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExpectDeclarationRemover.kt\norg/jetbrains/kotlin/backend/common/lower/ExpectDeclarationRemover\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 DeepCopyIrTreeWithSymbols.kt\norg/jetbrains/kotlin/ir/util/DeepCopyIrTreeWithSymbolsKt\n*L\n1#1,186:1\n1#2:187\n30#3,13:188\n*S KotlinDebug\n*F\n+ 1 ExpectDeclarationRemover.kt\norg/jetbrains/kotlin/backend/common/lower/ExpectDeclarationRemover\n*L\n169#1:188,13\n*E\n"})
public class ExpectDeclarationRemover
extends ExpectSymbolTransformer
implements FileLoweringPass {
    @NotNull
    private final ReferenceSymbolTable symbolTable;
    private final boolean doRemove;
    @NotNull
    private final Map<Pair<IrFunction, IrFunction>, Map<IrTypeParameter, IrTypeParameter>> typeParameterSubstitutionMap;

    public ExpectDeclarationRemover(@NotNull ReferenceSymbolTable symbolTable, boolean doRemove) {
        Intrinsics.checkNotNullParameter((Object)symbolTable, (String)"symbolTable");
        this.symbolTable = symbolTable;
        this.doRemove = doRemove;
        this.typeParameterSubstitutionMap = new LinkedHashMap();
    }

    @NotNull
    public final ReferenceSymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public ExpectDeclarationRemover(@NotNull BackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this(context2.getIr().getSymbols().getExternalSymbolTable(), true);
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        this.visitFile(irFile);
    }

    @Override
    public void visitFile(@NotNull IrFile declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (this.doRemove) {
            CollectionsKt.removeAll(declaration.getDeclarations(), arg_0 -> ExpectDeclarationRemover.visitFile$lambda$0(this, arg_0));
        }
        super.visitFile(declaration);
    }

    @Override
    public void visitValueParameter(@NotNull IrValueParameter declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        this.tryCopyDefaultArguments(declaration);
        super.visitValueParameter(declaration);
    }

    @Nullable
    public final List<IrDeclaration> transformFlat(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (AdditionalIrUtilsKt.isTopLevelDeclaration(declaration) && this.shouldRemoveTopLevelDeclaration(declaration)) {
            return CollectionsKt.emptyList();
        }
        if (declaration instanceof IrValueParameter) {
            this.tryCopyDefaultArguments((IrValueParameter)declaration);
        }
        return null;
    }

    @Override
    @Nullable
    protected IrClassSymbol getActualClass(@NotNull ClassDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        MemberDescriptor memberDescriptor = this.findActualForExpect(descriptor);
        ClassDescriptor classDescriptor = memberDescriptor instanceof ClassDescriptor ? (ClassDescriptor)memberDescriptor : null;
        if (classDescriptor == null) {
            return null;
        }
        return this.symbolTable.getDescriptorExtension().referenceClass(classDescriptor);
    }

    @Override
    @Nullable
    protected ExpectSymbolTransformer.ActualPropertyResult getActualProperty(@NotNull PropertyDescriptor descriptor) {
        IrSimpleFunctionSymbol irSimpleFunctionSymbol;
        IrSimpleFunctionSymbol irSimpleFunctionSymbol2;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        MemberDescriptor memberDescriptor = this.findActualForExpect(descriptor);
        PropertyDescriptor propertyDescriptor = memberDescriptor instanceof PropertyDescriptor ? (PropertyDescriptor)memberDescriptor : null;
        if (propertyDescriptor == null) {
            return null;
        }
        IrPropertySymbol newSymbol = this.symbolTable.getDescriptorExtension().referenceProperty(propertyDescriptor);
        PropertyGetterDescriptor propertyGetterDescriptor = ((PropertyDescriptor)newSymbol.getDescriptor()).getGetter();
        if (propertyGetterDescriptor != null) {
            PropertyGetterDescriptor it = propertyGetterDescriptor;
            boolean bl = false;
            irSimpleFunctionSymbol2 = this.symbolTable.getDescriptorExtension().referenceSimpleFunction(it);
        } else {
            irSimpleFunctionSymbol2 = null;
        }
        IrSimpleFunctionSymbol newGetter = irSimpleFunctionSymbol2;
        PropertySetterDescriptor propertySetterDescriptor = ((PropertyDescriptor)newSymbol.getDescriptor()).getSetter();
        if (propertySetterDescriptor != null) {
            PropertySetterDescriptor it = propertySetterDescriptor;
            boolean bl = false;
            irSimpleFunctionSymbol = this.symbolTable.getDescriptorExtension().referenceSimpleFunction(it);
        } else {
            irSimpleFunctionSymbol = null;
        }
        IrSimpleFunctionSymbol newSetter = irSimpleFunctionSymbol;
        return new ExpectSymbolTransformer.ActualPropertyResult(newSymbol, newGetter, newSetter);
    }

    @Override
    @Nullable
    protected IrConstructorSymbol getActualConstructor(@NotNull ClassConstructorDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        MemberDescriptor memberDescriptor = this.findActualForExpect(descriptor);
        ClassConstructorDescriptor classConstructorDescriptor = memberDescriptor instanceof ClassConstructorDescriptor ? (ClassConstructorDescriptor)memberDescriptor : null;
        if (classConstructorDescriptor == null) {
            return null;
        }
        return this.symbolTable.getDescriptorExtension().referenceConstructor(classConstructorDescriptor);
    }

    @Override
    @Nullable
    protected IrSimpleFunctionSymbol getActualFunction(@NotNull FunctionDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        MemberDescriptor memberDescriptor = this.findActualForExpect(descriptor);
        FunctionDescriptor functionDescriptor = memberDescriptor instanceof FunctionDescriptor ? (FunctionDescriptor)memberDescriptor : null;
        if (functionDescriptor == null) {
            return null;
        }
        return this.symbolTable.getDescriptorExtension().referenceSimpleFunction(functionDescriptor);
    }

    private final MemberDescriptor findActualForExpect(MemberDescriptor $this$findActualForExpect) {
        if (!$this$findActualForExpect.isExpect()) {
            throw new IllegalStateException($this$findActualForExpect.toString());
        }
        return (MemberDescriptor)CollectionsKt.singleOrNull((List)ExpectedActualResolverKt.findCompatibleActualsForExpected$default($this$findActualForExpect, DescriptorUtilsKt.getModule($this$findActualForExpect), null, 2, null));
    }

    private final boolean shouldRemoveTopLevelDeclaration(IrDeclaration declaration) {
        IrDeclaration irDeclaration2;
        return this.doRemove && ((irDeclaration2 = declaration) instanceof IrClass ? ((IrClass)declaration).isExpect() : (irDeclaration2 instanceof IrProperty ? ((IrProperty)declaration).isExpect() : (irDeclaration2 instanceof IrFunction ? ((IrFunction)declaration).isExpect() : false)));
    }

    private final boolean isOptionalAnnotationClass(IrClass klass) {
        return klass.getKind() == ClassKind.ANNOTATION_CLASS && klass.isExpect() && AdditionalIrUtilsKt.hasAnnotation(klass.getAnnotations(), OptionalAnnotationUtil.INSTANCE.getOPTIONAL_EXPECTATION_FQ_NAME());
    }

    private final void tryCopyDefaultArguments(IrValueParameter declaration) {
        Object object;
        int index;
        IrFunction function2;
        block12: {
            block11: {
                if (declaration.getDefaultValue() != null) {
                    return;
                }
                IrDeclarationParent irDeclarationParent = declaration.getParent();
                IrFunction irFunction = irDeclarationParent instanceof IrFunction ? (IrFunction)irDeclarationParent : null;
                if (irFunction == null) {
                    return;
                }
                function2 = irFunction;
                if (function2 instanceof IrConstructor && this.isOptionalAnnotationClass(AdditionalIrUtilsKt.getConstructedClass((IrConstructor)function2))) {
                    return;
                }
                if (!function2.getDescriptor().isActual()) {
                    return;
                }
                index = declaration.getIndex();
                if (index < 0) {
                    return;
                }
                boolean bl = Intrinsics.areEqual((Object)function2.getValueParameters().get(index), (Object)declaration);
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                MemberDescriptor memberDescriptor = this.findExpectForActual(function2.getDescriptor());
                object = memberDescriptor instanceof FunctionDescriptor ? (FunctionDescriptor)memberDescriptor : null;
                if (object == null) break block11;
                FunctionDescriptor it = object;
                boolean bl2 = false;
                IrFunction irFunction2 = IrUtilsKt.referenceFunction(this.symbolTable, it).getOwner();
                object = irFunction2;
                if (irFunction2 != null) break block12;
            }
            return;
        }
        Object expectFunction = object;
        IrExpressionBody irExpressionBody = ((IrFunction)expectFunction).getValueParameters().get(index).getDefaultValue();
        if (irExpressionBody == null) {
            return;
        }
        IrExpressionBody defaultValue = irExpressionBody;
        Pair expectToActual = TuplesKt.to((Object)expectFunction, (Object)function2);
        if (!this.typeParameterSubstitutionMap.containsKey(expectToActual)) {
            List<IrTypeParameter> functionTypeParameters = IrTypeSystemContextKt.extractTypeParameters(function2);
            List<IrTypeParameter> expectFunctionTypeParameters = IrTypeSystemContextKt.extractTypeParameters((IrDeclarationParent)expectFunction);
            List typeParametersMapping = CollectionsKt.zip((Iterable)expectFunctionTypeParameters, (Iterable)functionTypeParameters);
            boolean bl = false;
            this.typeParameterSubstitutionMap.put((Pair<IrFunction, IrFunction>)expectToActual, MapsKt.toMap((Iterable)typeParametersMapping));
        }
        IrExpressionBody originalDefault = defaultValue;
        boolean bl = false;
        declaration.setDefaultValue(this.copyAndActualizeDefaultValue(originalDefault, function2, (Map)MapsKt.getValue(this.typeParameterSubstitutionMap, (Object)expectToActual)));
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpressionBody copyAndActualizeDefaultValue(IrExpressionBody $this$copyAndActualizeDefaultValue, IrFunction actualFunction, Map<IrTypeParameter, ? extends IrTypeParameter> expectActualTypeParametersMap) {
        void $this$deepCopyWithSymbols$iv;
        IrElement irElement = $this$copyAndActualizeDefaultValue;
        boolean $i$f$deepCopyWithSymbols = false;
        void $this$deepCopyImpl$iv$iv = $this$deepCopyWithSymbols$iv;
        boolean $i$f$deepCopyImpl = false;
        DeepCopySymbolRemapper symbolRemapper$iv$iv = new DeepCopySymbolRemapper(null, 1, null);
        IrVisitorsKt.acceptVoid((IrElement)$this$deepCopyImpl$iv$iv, symbolRemapper$iv$iv);
        SymbolRemapper it = symbolRemapper$iv$iv;
        boolean bl = false;
        TypeRemapper typeRemapper$iv$iv = new IrTypeParameterRemapper(expectActualTypeParametersMap);
        IrElement irElement2 = $this$deepCopyImpl$iv$iv.transform(new DeepCopyIrTreeWithSymbols(symbolRemapper$iv$iv, typeRemapper$iv$iv, null, 4, null), null);
        if (irElement2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpressionBody");
        }
        return ((IrExpressionBody)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)((IrExpressionBody)irElement2), actualFunction)).transform((IrElementTransformer)new IrElementTransformerVoid(this){
            final /* synthetic */ ExpectDeclarationRemover this$0;
            {
                this.this$0 = $receiver;
            }

            public IrExpression visitGetValue(IrGetValue expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                this.transformChildrenVoid(expression2);
                return IrUtilsKt.remapSymbolParent(expression2, (Function1<? super IrClass, ? extends IrClass>)((Function1)arg_0 -> copyAndActualizeDefaultValue.2.visitGetValue$lambda$0(this.this$0, arg_0)), (Function1<? super IrFunction, ? extends IrFunction>)((Function1)arg_0 -> copyAndActualizeDefaultValue.2.visitGetValue$lambda$1(this.this$0, arg_0)));
            }

            private static final IrClass visitGetValue$lambda$0(ExpectDeclarationRemover this$0, IrClass it) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ReferenceSymbolTableExtension<ClassDescriptor, TypeAliasDescriptor, ScriptDescriptor, FunctionDescriptor, ClassConstructorDescriptor, PropertyDescriptor, ParameterDescriptor, TypeParameterDescriptor> referenceSymbolTableExtension = this$0.getSymbolTable().getDescriptorExtension();
                MemberDescriptor memberDescriptor = ExpectDeclarationRemover.access$findActualForExpect(this$0, it.getDescriptor());
                Intrinsics.checkNotNull((Object)memberDescriptor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                return (IrClass)referenceSymbolTableExtension.referenceClass((ClassDescriptor)memberDescriptor).getOwner();
            }

            private static final IrFunction visitGetValue$lambda$1(ExpectDeclarationRemover this$0, IrFunction it) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ReferenceSymbolTable referenceSymbolTable = this$0.getSymbolTable();
                MemberDescriptor memberDescriptor = ExpectDeclarationRemover.access$findActualForExpect(this$0, it.getDescriptor());
                Intrinsics.checkNotNull((Object)memberDescriptor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.FunctionDescriptor");
                return IrUtilsKt.referenceFunction(referenceSymbolTable, (FunctionDescriptor)memberDescriptor).getOwner();
            }
        }, (Object)null);
    }

    private final MemberDescriptor findExpectForActual(MemberDescriptor $this$findExpectForActual) {
        if (!$this$findExpectForActual.isActual()) {
            throw new IllegalStateException($this$findExpectForActual.toString());
        }
        return (MemberDescriptor)CollectionsKt.singleOrNull((List)ExpectedActualResolverKt.findCompatibleExpectsForActual$default($this$findExpectForActual, null, 1, null));
    }

    private static final boolean visitFile$lambda$0(ExpectDeclarationRemover this$0, IrDeclaration it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.shouldRemoveTopLevelDeclaration(it);
    }

    public static final /* synthetic */ MemberDescriptor access$findActualForExpect(ExpectDeclarationRemover $this, MemberDescriptor $receiver) {
        return $this.findActualForExpect($receiver);
    }
}

