/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.incremental.storage.AppendablePersistentStorage;
import org.jetbrains.kotlin.incremental.storage.InMemoryStorage;
import org.jetbrains.kotlin.incremental.storage.PersistentStorage;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00040\u00032\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0005B\u001b\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001e\u0010\t\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00042\u0006\u0010\n\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u000bJ#\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00028\u00002\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004H\u0016\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\rH\u0016R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/AppendableInMemoryStorage;", "KEY", "E", "Lorg/jetbrains/kotlin/incremental/storage/InMemoryStorage;", "", "Lorg/jetbrains/kotlin/incremental/storage/AppendablePersistentStorage;", "storage", "<init>", "(Lorg/jetbrains/kotlin/incremental/storage/AppendablePersistentStorage;)V", "get", "key", "(Ljava/lang/Object;)Ljava/util/Collection;", "append", "", "elements", "(Ljava/lang/Object;Ljava/util/Collection;)V", "applyChanges", "kotlin-build-common"})
@SourceDebugExtension(value={"SMAP\nInMemoryStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InMemoryStorage.kt\norg/jetbrains/kotlin/incremental/storage/AppendableInMemoryStorage\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,179:1\n216#2,2:180\n*S KotlinDebug\n*F\n+ 1 InMemoryStorage.kt\norg/jetbrains/kotlin/incremental/storage/AppendableInMemoryStorage\n*L\n171#1:180,2\n*E\n"})
public final class AppendableInMemoryStorage<KEY, E>
extends InMemoryStorage<KEY, Collection<? extends E>>
implements AppendablePersistentStorage<KEY, E> {
    @NotNull
    private final AppendablePersistentStorage<KEY, E> storage;

    public AppendableInMemoryStorage(@NotNull AppendablePersistentStorage<KEY, E> storage) {
        Intrinsics.checkNotNullParameter(storage, (String)"storage");
        super((PersistentStorage)storage);
        this.storage = storage;
    }

    @Override
    @Nullable
    public synchronized Collection<E> get(KEY key) {
        Collection collection;
        KEY KEY = key;
        if (((Map)this.getAppendedEntries()).containsKey(KEY)) {
            Object VALUE = this.storage.get(key);
            Intrinsics.checkNotNull(VALUE);
            Collection collection2 = (Collection)VALUE;
            Object VALUE2 = this.getAppendedEntries().get(key);
            Intrinsics.checkNotNull(VALUE2);
            collection = CollectionsKt.plus((Collection)collection2, (Iterable)((Iterable)VALUE2));
        } else {
            collection = (Collection)super.get(key);
        }
        return collection;
    }

    @Override
    public synchronized void append(KEY key, @NotNull Collection<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        KEY KEY = key;
        if (((Map)this.getAddedEntries()).containsKey(KEY)) {
            Map map = this.getAddedEntries();
            Object VALUE = this.getAddedEntries().get(key);
            Intrinsics.checkNotNull(VALUE);
            map.put(key, CollectionsKt.plus((Collection)((Collection)VALUE), (Iterable)elements));
        } else if (((Map)this.getModifiedEntries()).containsKey(KEY)) {
            Map map = this.getModifiedEntries();
            Object VALUE = this.getModifiedEntries().get(key);
            Intrinsics.checkNotNull(VALUE);
            map.put(key, CollectionsKt.plus((Collection)((Collection)VALUE), (Iterable)elements));
        } else if (((Map)this.getAppendedEntries()).containsKey(KEY)) {
            Map map = this.getAppendedEntries();
            Object VALUE = this.getAppendedEntries().get(key);
            Intrinsics.checkNotNull(VALUE);
            map.put(key, CollectionsKt.plus((Collection)((Collection)VALUE), (Iterable)elements));
        } else if (this.getRemovedKeys().contains(KEY)) {
            this.getRemovedKeys().remove(key);
            ((Map)this.getModifiedEntries()).put(key, elements);
        } else if (this.storage.contains(KEY)) {
            ((Map)this.getAppendedEntries()).put(key, elements);
        } else {
            ((Map)this.getAddedEntries()).put(key, elements);
        }
    }

    @Override
    public synchronized void applyChanges() {
        Map $this$forEach$iv = this.getAppendedEntries();
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator2.next();
            boolean bl = false;
            this.storage.append(it.getKey(), (Collection)it.getValue());
        }
        this.getAppendedEntries().clear();
        super.applyChanges();
    }
}

