/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.extapi.psi.ASTDelegatePsiElement;
import com.intellij.psi.PsiElement;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.resolve.IdentifierChecker;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J(\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u000e\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u00192\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmSimpleNameBacktickChecker;", "Lorg/jetbrains/kotlin/resolve/IdentifierChecker;", "<init>", "()V", "INVALID_CHARS", "", "", "getINVALID_CHARS", "()Ljava/util/Set;", "DANGEROUS_CHARS", "checkIdentifier", "", "simpleNameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "checkDeclaration", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "checkNamed", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "reportIfNeeded", "name", "", "reportOn", "Lkotlin/Function0;", "Lcom/intellij/psi/PsiElement;", "frontend.java"})
@SourceDebugExtension(value={"SMAP\nJvmSimpleNameBacktickChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmSimpleNameBacktickChecker.kt\norg/jetbrains/kotlin/resolve/jvm/checkers/JvmSimpleNameBacktickChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,80:1\n1863#2,2:81\n1863#2,2:83\n1863#2,2:85\n1088#3,2:87\n1088#3,2:89\n*S KotlinDebug\n*F\n+ 1 JvmSimpleNameBacktickChecker.kt\norg/jetbrains/kotlin/resolve/jvm/checkers/JvmSimpleNameBacktickChecker\n*L\n39#1:81,2\n42#1:83,2\n45#1:85,2\n64#1:87,2\n72#1:89,2\n*E\n"})
public final class JvmSimpleNameBacktickChecker
implements IdentifierChecker {
    @NotNull
    public static final JvmSimpleNameBacktickChecker INSTANCE = new JvmSimpleNameBacktickChecker();
    @NotNull
    private static final Set<Character> INVALID_CHARS;
    @NotNull
    private static final Set<Character> DANGEROUS_CHARS;

    private JvmSimpleNameBacktickChecker() {
    }

    @NotNull
    public final Set<Character> getINVALID_CHARS() {
        return INVALID_CHARS;
    }

    @Override
    public void checkIdentifier(@NotNull KtSimpleNameExpression simpleNameExpression, @NotNull DiagnosticSink diagnosticHolder) {
        Intrinsics.checkNotNullParameter((Object)simpleNameExpression, (String)"simpleNameExpression");
        Intrinsics.checkNotNullParameter((Object)diagnosticHolder, (String)"diagnosticHolder");
        this.reportIfNeeded(simpleNameExpression.getReferencedName(), (Function0<? extends PsiElement>)((Function0)() -> JvmSimpleNameBacktickChecker.checkIdentifier$lambda$0(simpleNameExpression)), diagnosticHolder);
    }

    @Override
    public void checkDeclaration(@NotNull KtDeclaration declaration, @NotNull DiagnosticSink diagnosticHolder) {
        ASTDelegatePsiElement it;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)diagnosticHolder, (String)"diagnosticHolder");
        if (declaration instanceof KtDestructuringDeclaration) {
            List<KtDestructuringDeclarationEntry> list = ((KtDestructuringDeclaration)declaration).getEntries();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getEntries(...)");
            $this$forEach$iv = list;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (KtDestructuringDeclarationEntry)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                INSTANCE.checkNamed((KtNamedDeclaration)((Object)it), diagnosticHolder);
            }
        }
        if (declaration instanceof KtCallableDeclaration) {
            List<KtParameter> list = ((KtCallableDeclaration)declaration).getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getValueParameters(...)");
            $this$forEach$iv = list;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (KtParameter)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                INSTANCE.checkNamed((KtNamedDeclaration)((Object)it), diagnosticHolder);
            }
        }
        if (declaration instanceof KtTypeParameterListOwner) {
            List<KtTypeParameter> list = ((KtTypeParameterListOwner)declaration).getTypeParameters();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getTypeParameters(...)");
            $this$forEach$iv = list;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (KtTypeParameter)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                INSTANCE.checkNamed((KtNamedDeclaration)((Object)it), diagnosticHolder);
            }
        }
        if (declaration instanceof KtNamedDeclaration) {
            this.checkNamed((KtNamedDeclaration)declaration, diagnosticHolder);
        }
    }

    private final void checkNamed(KtNamedDeclaration declaration, DiagnosticSink diagnosticHolder) {
        String string2 = declaration.getName();
        if (string2 == null) {
            return;
        }
        String name2 = string2;
        this.reportIfNeeded(name2, (Function0<? extends PsiElement>)((Function0)() -> JvmSimpleNameBacktickChecker.checkNamed$lambda$4(declaration)), diagnosticHolder);
    }

    private final void reportIfNeeded(String name2, Function0<? extends PsiElement> reportOn, DiagnosticSink diagnosticHolder) {
        String string2 = KtPsiUtil.unquoteIdentifier(name2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"unquoteIdentifier(...)");
        String text = string2;
        if (((CharSequence)text).length() == 0) {
            PsiElement psiElement = (PsiElement)reportOn.invoke();
            if (psiElement == null) {
                return;
            }
            diagnosticHolder.report(Errors.INVALID_CHARACTERS.on(psiElement, "should not be empty"));
        } else {
            boolean bl;
            char it;
            char element$iv;
            int n;
            boolean $i$f$any;
            CharSequence $this$any$iv;
            block10: {
                $this$any$iv = text;
                $i$f$any = false;
                for (n = 0; n < $this$any$iv.length(); ++n) {
                    it = element$iv = $this$any$iv.charAt(n);
                    boolean bl2 = false;
                    if (!INVALID_CHARS.contains(Character.valueOf(it))) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
            if (bl) {
                PsiElement psiElement = (PsiElement)reportOn.invoke();
                if (psiElement == null) {
                    return;
                }
                diagnosticHolder.report(Errors.INVALID_CHARACTERS.on(psiElement, "contains illegal characters: " + CollectionsKt.joinToString$default((Iterable)CollectionsKt.intersect((Iterable)INVALID_CHARS, (Iterable)StringsKt.toSet((CharSequence)text)), (CharSequence)"", null, null, (int)0, null, null, (int)62, null)));
            } else {
                boolean bl3;
                block11: {
                    $this$any$iv = text;
                    $i$f$any = false;
                    for (n = 0; n < $this$any$iv.length(); ++n) {
                        it = element$iv = $this$any$iv.charAt(n);
                        boolean bl4 = false;
                        if (!DANGEROUS_CHARS.contains(Character.valueOf(it))) continue;
                        bl3 = true;
                        break block11;
                    }
                    bl3 = false;
                }
                if (bl3) {
                    PsiElement psiElement = (PsiElement)reportOn.invoke();
                    if (psiElement == null) {
                        return;
                    }
                    diagnosticHolder.report(ErrorsJvm.DANGEROUS_CHARACTERS.on(psiElement, CollectionsKt.joinToString$default((Iterable)CollectionsKt.intersect((Iterable)DANGEROUS_CHARS, (Iterable)StringsKt.toSet((CharSequence)text)), (CharSequence)"", null, null, (int)0, null, null, (int)62, null)));
                }
            }
        }
    }

    private static final PsiElement checkIdentifier$lambda$0(KtSimpleNameExpression $simpleNameExpression) {
        Intrinsics.checkNotNullParameter((Object)$simpleNameExpression, (String)"$simpleNameExpression");
        return $simpleNameExpression.getIdentifier();
    }

    private static final PsiElement checkNamed$lambda$4(KtNamedDeclaration $declaration) {
        Intrinsics.checkNotNullParameter((Object)$declaration, (String)"$declaration");
        PsiElement psiElement = $declaration.getNameIdentifier();
        if (psiElement == null) {
            psiElement = $declaration;
        }
        return psiElement;
    }

    static {
        Object[] objectArray = new Character[]{Character.valueOf('.'), Character.valueOf(';'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('/'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf(':'), Character.valueOf('\\')};
        INVALID_CHARS = SetsKt.setOf((Object[])objectArray);
        objectArray = new Character[]{Character.valueOf('?'), Character.valueOf('*'), Character.valueOf('\"'), Character.valueOf('|'), Character.valueOf('%')};
        DANGEROUS_CHARS = SetsKt.setOf((Object[])objectArray);
    }
}

