/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineExceptionHandler;
import org.jetbrains.kotlinx.lincheck.ClassVersionGetter;
import org.jetbrains.kotlinx.lincheck.ExecutionClassLoader;
import org.jetbrains.kotlinx.lincheck.TransformationClassWriter;
import org.jetbrains.kotlinx.lincheck.UtilsKt;
import org.jetbrains.kotlinx.lincheck.runner.Runner;
import org.jetbrains.kotlinx.lincheck.strategy.Strategy;
import org.jetbrains.kotlinx.lincheck.strategy.managed.ManagedStrategyStateHolder;
import org.jetbrains.kotlinx.lincheck.strategy.managed.ManagedStrategyTransformerKt;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.util.TraceClassVisitor;

public class TransformationClassLoader
extends ExecutionClassLoader {
    public static final String REMAPPED_PACKAGE_INTERNAL_NAME = "org/jetbrains/kotlinx/lincheck/tran$f*rmed/";
    public static final String REMAPPED_PACKAGE_CANONICAL_NAME = UtilsKt.getCanonicalClassName("org/jetbrains/kotlinx/lincheck/tran$f*rmed/");
    public static final int ASM_API = 589824;
    private final List<Function<ClassVisitor, ClassVisitor>> classTransformers;
    private final Map<String, Class<?>> cache = new ConcurrentHashMap();
    private final Remapper remapper;

    public TransformationClassLoader(Strategy strategy, Runner runner) {
        this.classTransformers = new ArrayList<Function<ClassVisitor, ClassVisitor>>();
        if (strategy.needsTransformation()) {
            this.classTransformers.add(strategy::createTransformer);
        }
        if (runner.needsTransformation()) {
            this.classTransformers.add(runner::createTransformer);
        }
        this.remapper = UtilsKt.getRemapperByTransformers(this.classTransformers.stream().map(constructor -> (ClassVisitor)constructor.apply(new TraceClassVisitor(null))).collect(Collectors.toList()));
    }

    public TransformationClassLoader(Function<ClassVisitor, ClassVisitor> classTransformer) {
        this.classTransformers = Collections.singletonList(classTransformer);
        this.remapper = null;
    }

    private static boolean doNotTransform(String className) {
        if (className.startsWith(REMAPPED_PACKAGE_CANONICAL_NAME)) {
            return false;
        }
        if (ManagedStrategyTransformerKt.isImpossibleToTransformApiClass(className)) {
            return true;
        }
        return className.startsWith("sun.") || className.startsWith("java.") || className.startsWith("jdk.internal.") || className.startsWith("kotlin.") && !className.startsWith("kotlin.collections.") && (!className.startsWith("kotlin.jvm.internal.Array") || !className.contains("Iterator")) && !className.startsWith("kotlin.ranges.") || className.startsWith("org.jetbrains.kotlinx.lincheck.") && !className.startsWith("org.jetbrains.kotlinx.lincheck.test.") && !className.equals(ManagedStrategyStateHolder.class.getName()) || className.equals(CancellableContinuation.class.getName()) || className.equals(CoroutineExceptionHandler.class.getName()) || className.equals(CoroutineDispatcher.class.getName());
    }

    boolean shouldBeTransformed(Class<?> clazz) {
        return !TransformationClassLoader.doNotTransform(this.remapClassName(clazz.getName()));
    }

    public String remapClassName(String className) {
        if (this.remapper != null) {
            String internalName = className.replace('.', '/');
            String remappedInternalName = this.remapper.mapType(internalName);
            return remappedInternalName.replace('/', '.');
        }
        return className;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> result2 = this.cache.get(name);
            if (result2 != null) {
                return result2;
            }
            if (TransformationClassLoader.doNotTransform(name)) {
                result2 = super.loadClass(name);
                this.cache.put(name, result2);
                return result2;
            }
            try {
                byte[] bytes = this.instrument(this.originalName(name));
                result2 = this.defineClass(name, bytes, 0, bytes.length);
                this.cache.put(name, result2);
                return result2;
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot transform class " + name, e);
            }
        }
    }

    private byte[] instrument(String className) throws IOException {
        TransformationClassWriter cw;
        ClassReader cr = new ClassReader(className);
        ClassVersionGetter infoGetter = new ClassVersionGetter();
        cr.accept((ClassVisitor)infoGetter, 0);
        TransformationClassWriter cv = cw = new TransformationClassWriter(infoGetter.getClassVersion(), this.remapper);
        for (Function<ClassVisitor, ClassVisitor> ct : this.classTransformers) {
            cv = ct.apply((ClassVisitor)cv);
        }
        cr.accept((ClassVisitor)cv, 8);
        return cw.toByteArray();
    }

    private String originalName(String className) {
        if (className.startsWith(REMAPPED_PACKAGE_CANONICAL_NAME)) {
            return className.substring(REMAPPED_PACKAGE_CANONICAL_NAME.length());
        }
        return className;
    }

    @Override
    public URL getResource(String name) {
        return super.getResource(name);
    }
}

