/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck.paramgen;

import java.util.Random;
import org.jetbrains.kotlinx.lincheck.paramgen.ParameterGenerator;

public class DoubleGen
implements ParameterGenerator<Double> {
    private static final float DEFAULT_BEGIN = -10.0f;
    private static final float DEFAULT_END = 10.0f;
    private static final float DEFAULT_STEP = 0.1f;
    private final Random random = new Random(0L);
    private final double begin;
    private final double end;
    private final double step;

    public DoubleGen(String configuration) {
        if (configuration.isEmpty()) {
            this.begin = -10.0;
            this.end = 10.0;
            this.step = 0.1f;
            return;
        }
        String[] args = configuration.replaceAll("\\s", "").split(":");
        switch (args.length) {
            case 2: {
                this.begin = Double.parseDouble(args[0]);
                this.end = Double.parseDouble(args[1]);
                this.step = 0.1f;
                break;
            }
            case 3: {
                this.begin = Double.parseDouble(args[0]);
                this.step = Double.parseDouble(args[1]);
                this.end = Double.parseDouble(args[2]);
                break;
            }
            default: {
                throw new IllegalArgumentException("Configuration should have two (begin and end) or three (begin, step and end) arguments separated by colon");
            }
        }
        if ((this.end - this.begin) / this.step >= 2.147483647E9) {
            throw new IllegalArgumentException("step is too small for specified range");
        }
    }

    @Override
    public Double generate() {
        double delta = this.end - this.begin;
        if (this.step == 0.0) {
            return this.begin + delta * this.random.nextDouble();
        }
        int maxSteps = (int)(delta / this.step);
        return this.begin + delta * (double)this.random.nextInt(maxSteps + 1);
    }
}

