/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck.paramgen;

import java.util.Random;
import org.jetbrains.kotlinx.lincheck.paramgen.ParameterGenerator;

public class StringGen
implements ParameterGenerator<String> {
    private static final int DEFAULT_MAX_WORD_LENGTH = 15;
    private static final String DEFAULT_ALPHABET = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_ ";
    private final Random random = new Random(0L);
    private final int maxWordLength;
    private final String alphabet;

    public StringGen(String configuration) {
        if (configuration.isEmpty()) {
            this.maxWordLength = 15;
            this.alphabet = DEFAULT_ALPHABET;
            return;
        }
        int firstCommaIndex = configuration.indexOf(58);
        if (firstCommaIndex < 0) {
            this.maxWordLength = Integer.parseInt(configuration);
            this.alphabet = DEFAULT_ALPHABET;
        } else {
            this.maxWordLength = Integer.parseInt(configuration.substring(0, firstCommaIndex));
            this.alphabet = configuration.substring(firstCommaIndex + 1);
        }
    }

    @Override
    public String generate() {
        char[] cs = new char[this.random.nextInt(this.maxWordLength)];
        for (int i = 0; i < cs.length; ++i) {
            cs[i] = this.alphabet.charAt(this.random.nextInt(this.alphabet.length()));
        }
        return new String(cs);
    }
}

