/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck.strategy.managed;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0018\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0001J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0001H\u0002J\u000e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0001J\u000e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0001J\u000e\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0001J\u0016\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0001R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/MonitorTracker;", "", "nThreads", "", "(I)V", "acquiredMonitors", "Ljava/util/IdentityHashMap;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/MonitorTracker$MonitorAcquiringInfo;", "acquiringMonitors", "", "[Ljava/lang/Object;", "waitForNotify", "", "acquireMonitor", "", "iThread", "monitor", "canAcquireMonitor", "isWaiting", "notify", "", "notifyAll", "releaseMonitor", "waitOnMonitor", "MonitorAcquiringInfo", "lincheck"})
final class MonitorTracker {
    private final IdentityHashMap<Object, MonitorAcquiringInfo> acquiredMonitors = new IdentityHashMap();
    private final Object[] acquiringMonitors;
    private final boolean[] waitForNotify;

    public final boolean acquireMonitor(int iThread, @NotNull Object monitor) {
        Intrinsics.checkNotNullParameter((Object)monitor, (String)"monitor");
        MonitorAcquiringInfo ai2 = this.acquiredMonitors.computeIfAbsent(monitor, new Function<Object, MonitorAcquiringInfo>(iThread){
            final /* synthetic */ int $iThread;

            public final MonitorAcquiringInfo apply(Object it) {
                return new MonitorAcquiringInfo(this.$iThread, 0);
            }
            {
                this.$iThread = n;
            }
        });
        if (ai2.getIThread() != iThread) {
            this.acquiringMonitors[iThread] = monitor;
            return false;
        }
        MonitorAcquiringInfo monitorAcquiringInfo = ai2;
        int n = monitorAcquiringInfo.getTimesAcquired();
        monitorAcquiringInfo.setTimesAcquired(n + 1);
        this.acquiringMonitors[iThread] = null;
        return true;
    }

    public final void releaseMonitor(@NotNull Object monitor) {
        MonitorAcquiringInfo ai2;
        Intrinsics.checkNotNullParameter((Object)monitor, (String)"monitor");
        MonitorAcquiringInfo monitorAcquiringInfo = this.acquiredMonitors.get(monitor);
        Intrinsics.checkNotNull((Object)monitorAcquiringInfo);
        Intrinsics.checkNotNullExpressionValue((Object)monitorAcquiringInfo, (String)"acquiredMonitors[monitor]!!");
        MonitorAcquiringInfo monitorAcquiringInfo2 = ai2 = monitorAcquiringInfo;
        int n = monitorAcquiringInfo2.getTimesAcquired();
        monitorAcquiringInfo2.setTimesAcquired(n + -1);
        if (ai2.getTimesAcquired() == 0) {
            this.acquiredMonitors.remove(monitor);
        }
    }

    public final boolean isWaiting(int iThread) {
        Object object = this.acquiringMonitors[iThread];
        if (object == null) {
            return false;
        }
        Object monitor = object;
        return this.waitForNotify[iThread] || !this.canAcquireMonitor(iThread, monitor);
    }

    private final boolean canAcquireMonitor(int iThread, Object monitor) {
        MonitorAcquiringInfo monitorAcquiringInfo = this.acquiredMonitors.get(monitor);
        return monitorAcquiringInfo != null ? Integer.valueOf(monitorAcquiringInfo.getIThread()).equals(iThread) : true;
    }

    public final void waitOnMonitor(int iThread, @NotNull Object monitor) {
        Intrinsics.checkNotNullParameter((Object)monitor, (String)"monitor");
        Map map = this.acquiredMonitors;
        boolean bl = false;
        Map map2 = map;
        boolean bl2 = false;
        boolean bl3 = map2.containsKey(monitor);
        bl = false;
        boolean bl4 = false;
        if (!bl3) {
            boolean bl5 = false;
            String string = "Monitor should have been acquired by this thread";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.releaseMonitor(monitor);
        this.waitForNotify[iThread] = true;
        this.acquiringMonitors[iThread] = monitor;
    }

    public final void notify(@NotNull Object monitor) {
        Intrinsics.checkNotNullParameter((Object)monitor, (String)"monitor");
        this.notifyAll(monitor);
    }

    /*
     * WARNING - void declaration
     */
    public final void notifyAll(@NotNull Object monitor) {
        Intrinsics.checkNotNullParameter((Object)monitor, (String)"monitor");
        Object[] $this$forEachIndexed$iv = this.acquiringMonitors;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void m;
            int n = index$iv++;
            Object object = item$iv;
            int iThread = n;
            boolean bl = false;
            if (monitor != m) continue;
            this.waitForNotify[iThread] = false;
        }
    }

    public MonitorTracker(int nThreads) {
        Object[] objectArray;
        int n;
        MonitorTracker monitorTracker = this;
        Object[] objectArray2 = new Object[nThreads];
        int n2 = 0;
        while (n2 < nThreads) {
            int n3 = n2;
            n = n2++;
            objectArray = objectArray2;
            boolean bl = false;
            Object var9_9 = null;
            objectArray[n] = var9_9;
        }
        objectArray = objectArray2;
        monitorTracker.acquiringMonitors = objectArray;
        monitorTracker = this;
        objectArray2 = new boolean[nThreads];
        n2 = 0;
        while (n2 < nThreads) {
            int it = n2;
            n = n2++;
            objectArray = objectArray2;
            boolean bl = false;
            boolean bl2 = false;
            objectArray[n] = bl2;
        }
        objectArray = objectArray2;
        monitorTracker.waitForNotify = (boolean[])objectArray;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\u0007\"\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/MonitorTracker$MonitorAcquiringInfo;", "", "iThread", "", "timesAcquired", "(II)V", "getIThread", "()I", "getTimesAcquired", "setTimesAcquired", "(I)V", "lincheck"})
    private static final class MonitorAcquiringInfo {
        private final int iThread;
        private int timesAcquired;

        public final int getIThread() {
            return this.iThread;
        }

        public final int getTimesAcquired() {
            return this.timesAcquired;
        }

        public final void setTimesAcquired(int n) {
            this.timesAcquired = n;
        }

        public MonitorAcquiringInfo(int iThread, int timesAcquired) {
            this.iThread = iThread;
            this.timesAcquired = timesAcquired;
        }
    }
}

