/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck.strategy.stress;

import java.io.Closeable;
import java.lang.reflect.Method;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.lincheck.execution.ExecutionScenario;
import org.jetbrains.kotlinx.lincheck.runner.CompletedInvocationResult;
import org.jetbrains.kotlinx.lincheck.runner.InvocationResult;
import org.jetbrains.kotlinx.lincheck.runner.ParallelThreadsRunner;
import org.jetbrains.kotlinx.lincheck.runner.Runner;
import org.jetbrains.kotlinx.lincheck.runner.UseClocks;
import org.jetbrains.kotlinx.lincheck.strategy.IncorrectResultsFailure;
import org.jetbrains.kotlinx.lincheck.strategy.LincheckFailure;
import org.jetbrains.kotlinx.lincheck.strategy.LincheckFailureKt;
import org.jetbrains.kotlinx.lincheck.strategy.Strategy;
import org.jetbrains.kotlinx.lincheck.strategy.stress.StressCTestConfiguration;
import org.jetbrains.kotlinx.lincheck.verifier.Verifier;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/stress/StressStrategy;", "Lorg/jetbrains/kotlinx/lincheck/strategy/Strategy;", "testCfg", "Lorg/jetbrains/kotlinx/lincheck/strategy/stress/StressCTestConfiguration;", "testClass", "Ljava/lang/Class;", "scenario", "Lorg/jetbrains/kotlinx/lincheck/execution/ExecutionScenario;", "validationFunctions", "", "Ljava/lang/reflect/Method;", "stateRepresentationFunction", "verifier", "Lorg/jetbrains/kotlinx/lincheck/verifier/Verifier;", "(Lorg/jetbrains/kotlinx/lincheck/strategy/stress/StressCTestConfiguration;Ljava/lang/Class;Lorg/jetbrains/kotlinx/lincheck/execution/ExecutionScenario;Ljava/util/List;Ljava/lang/reflect/Method;Lorg/jetbrains/kotlinx/lincheck/verifier/Verifier;)V", "invocations", "", "runner", "Lorg/jetbrains/kotlinx/lincheck/runner/Runner;", "run", "Lorg/jetbrains/kotlinx/lincheck/strategy/LincheckFailure;", "lincheck"})
public final class StressStrategy
extends Strategy {
    private final int invocations;
    private final Runner runner;
    private final Verifier verifier;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public LincheckFailure run() {
        Closeable closeable = this.runner;
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            Runner it = (Runner)closeable;
            boolean bl3 = false;
            int n = 0;
            int n2 = this.invocations;
            while (n < n2) {
                void invocation;
                InvocationResult ir = this.runner.run();
                if (ir instanceof CompletedInvocationResult) {
                    if (!this.verifier.verifyResults(this.getScenario(), ((CompletedInvocationResult)ir).getResults())) {
                        LincheckFailure lincheckFailure = new IncorrectResultsFailure(this.getScenario(), ((CompletedInvocationResult)ir).getResults(), null, 4, null);
                        return lincheckFailure;
                    }
                } else {
                    LincheckFailure lincheckFailure = LincheckFailureKt.toLincheckFailure$default(ir, this.getScenario(), null, 2, null);
                    return lincheckFailure;
                }
                ++invocation;
            }
            LincheckFailure lincheckFailure = null;
            return lincheckFailure;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public StressStrategy(@NotNull StressCTestConfiguration testCfg, @NotNull Class<?> testClass, @NotNull ExecutionScenario scenario, @NotNull List<Method> validationFunctions, @Nullable Method stateRepresentationFunction, @NotNull Verifier verifier) {
        Intrinsics.checkNotNullParameter((Object)testCfg, (String)"testCfg");
        Intrinsics.checkNotNullParameter(testClass, (String)"testClass");
        Intrinsics.checkNotNullParameter((Object)scenario, (String)"scenario");
        Intrinsics.checkNotNullParameter(validationFunctions, (String)"validationFunctions");
        Intrinsics.checkNotNullParameter((Object)verifier, (String)"verifier");
        super(scenario);
        this.verifier = verifier;
        this.invocations = testCfg.getInvocationsPerIteration();
        this.runner = new ParallelThreadsRunner(this, testClass, validationFunctions, stateRepresentationFunction, testCfg.getTimeoutMs(), UseClocks.RANDOM);
        try {
            this.runner.initialize();
        }
        catch (Throwable t) {
            this.runner.close();
            throw t;
        }
    }
}

