/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.scene.control.gauge.linear;

import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import jfxtras.internal.scene.control.gauge.linear.skin.AbstractLinearGaugeSkin;
import jfxtras.scene.control.gauge.linear.elements.Indicator;
import jfxtras.scene.control.gauge.linear.elements.Label;
import jfxtras.scene.control.gauge.linear.elements.Marker;
import jfxtras.scene.control.gauge.linear.elements.Segment;

public abstract class AbstractLinearGauge<T>
extends Control {
    private final DoubleProperty valueProperty = new SimpleDoubleProperty((Object)this, "value", 0.0);
    private final DoubleProperty minValueProperty = new SimpleDoubleProperty((Object)this, "minValue", 0.0);
    private final DoubleProperty maxValueProperty = new SimpleDoubleProperty((Object)this, "maxValue", 100.0);
    private final ObservableList<Label> labels = FXCollections.observableArrayList();
    private final ObservableList<Segment> segments = FXCollections.observableArrayList();
    private final ObservableList<Marker> markers = FXCollections.observableArrayList();
    private final ObservableList<Indicator> indicators = FXCollections.observableArrayList();

    public AbstractLinearGauge() {
        this.construct();
    }

    private void construct() {
        this.getStyleClass().add((Object)((Object)((Object)this)).getClass().getSimpleName());
    }

    public abstract String getUserAgentStylesheet();

    public abstract Skin<?> createDefaultSkin();

    public DoubleProperty valueProperty() {
        return this.valueProperty;
    }

    public double getValue() {
        return this.valueProperty.getValue();
    }

    public void setValue(double value) {
        this.valueProperty.setValue((Number)value);
    }

    public T withValue(double value) {
        this.setValue(value);
        return (T)((Object)this);
    }

    public DoubleProperty minValueProperty() {
        return this.minValueProperty;
    }

    public double getMinValue() {
        return this.minValueProperty.getValue();
    }

    public void setMinValue(double value) {
        this.minValueProperty.setValue((Number)value);
    }

    public T withMinValue(double value) {
        this.setMinValue(value);
        return (T)((Object)this);
    }

    public DoubleProperty maxValueProperty() {
        return this.maxValueProperty;
    }

    public double getMaxValue() {
        return this.maxValueProperty.getValue();
    }

    public void setMaxValue(double value) {
        this.maxValueProperty.setValue((Number)value);
    }

    public T withMaxValue(double value) {
        this.setMaxValue(value);
        return (T)((Object)this);
    }

    public ObservableList<Label> labels() {
        return this.labels;
    }

    public ObservableList<Segment> segments() {
        return this.segments;
    }

    public ObservableList<Marker> markers() {
        return this.markers;
    }

    public ObservableList<Indicator> indicators() {
        return this.indicators;
    }

    public static String segmentColorschemeCSSPath() {
        return AbstractLinearGaugeSkin.class.getResource("/jfxtras/internal/scene/control/gauge/linear/_segment.css").toExternalForm();
    }
}

