/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.scene.control.gauge.linear.elements;

import jfxtras.scene.control.gauge.linear.AbstractLinearGauge;
import jfxtras.scene.control.gauge.linear.elements.Marker;

public class PercentMarker
implements Marker {
    private final String id;
    private final double valuePercent;
    private final AbstractLinearGauge<?> linearGauge;

    public PercentMarker(AbstractLinearGauge<?> linearGauge, double valuePercent, String id) {
        this.id = id;
        this.valuePercent = valuePercent;
        this.linearGauge = linearGauge;
    }

    public PercentMarker(AbstractLinearGauge<?> linearGauge, double valuePercent) {
        this.id = null;
        this.valuePercent = valuePercent;
        this.linearGauge = linearGauge;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public double getValue() {
        double minValue = this.linearGauge.getMinValue();
        double maxValue = this.linearGauge.getMaxValue();
        return minValue + (maxValue - minValue) * this.valuePercent / 100.0;
    }
}

