/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.schema.codegen;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jibx.custom.CustomizationCommandLineBase;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshallable;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.jibx.schema.codegen.custom.SchemasetCustom;
import org.jibx.schema.validation.ValidationContext;
import org.jibx.schema.validation.ValidationProblem;
import org.jibx.util.ReflectionUtilities;

public abstract class SchemaCommandLineBase
extends CustomizationCommandLineBase {
    private static final String[] EXTRA_USAGE_LINES = new String[]{" -s       schema root directory path"};
    private String m_rootPath;
    private URL m_schemaRoot;
    private File m_schemaDir;
    private SchemasetCustom m_customRoot;

    public SchemaCommandLineBase() {
        super(EXTRA_USAGE_LINES);
    }

    public URL getSchemaRoot() {
        return this.m_schemaRoot;
    }

    public File getSchemaDir() {
        return this.m_schemaDir;
    }

    public SchemasetCustom getCustomRoot() {
        return this.m_customRoot;
    }

    @Override
    protected boolean checkParameter(CustomizationCommandLineBase.ArgList alist) {
        boolean match = true;
        String arg = alist.current();
        if ("-s".equalsIgnoreCase(arg)) {
            this.m_rootPath = alist.next();
        } else {
            match = super.checkParameter(alist);
        }
        return match;
    }

    @Override
    protected void verboseDetails() {
        System.out.println("Starting from schemas:");
        List schemas = this.getExtraArgs();
        for (int i = 0; i < schemas.size(); ++i) {
            System.out.println(" " + schemas.get(i));
        }
    }

    @Override
    protected void finishParameters(CustomizationCommandLineBase.ArgList alist) {
        super.finishParameters(alist);
        try {
            if (this.m_rootPath == null) {
                this.m_schemaRoot = new File(".").toURI().toURL();
                this.m_schemaDir = new File(".");
            } else {
                String path = this.m_rootPath;
                File pathfile = new File(path);
                if (pathfile.exists()) {
                    this.m_schemaDir = pathfile;
                    this.m_schemaRoot = pathfile.toURI().toURL();
                } else {
                    if (!path.endsWith("/")) {
                        path = path + '/';
                    }
                    this.m_schemaRoot = new URL(path);
                    if (this.m_schemaRoot.getProtocol().equals("file")) {
                        this.m_schemaDir = new File(this.m_schemaRoot.getPath());
                    }
                }
            }
        }
        catch (MalformedURLException e) {
            System.out.println("Root path '" + this.m_rootPath + "' not found as file and not recognized as URL");
            alist.setValid(false);
        }
    }

    @Override
    protected boolean loadCustomizations(String path) throws JiBXException, IOException {
        ArrayList probs;
        ValidationContext vctx = new ValidationContext();
        this.m_customRoot = new SchemasetCustom((SchemasetCustom)null);
        if (path != null) {
            IBindingFactory fact = BindingDirectory.getFactory(SchemasetCustom.class);
            IUnmarshallingContext ictx = fact.createUnmarshallingContext();
            FileInputStream is = new FileInputStream(path);
            ictx.setDocument((InputStream)is, null);
            ictx.setUserContext((Object)vctx);
            ((IUnmarshallable)this.m_customRoot).unmarshal(ictx);
        }
        if ((probs = vctx.getProblems()).size() > 0) {
            for (int i = 0; i < probs.size(); ++i) {
                ValidationProblem prob = (ValidationProblem)probs.get(i);
                System.out.print(prob.getSeverity() >= 2 ? "Error: " : "Warning: ");
                System.out.println(prob.getDescription());
            }
            if (vctx.getErrorCount() > 0 || vctx.getFatalCount() > 0) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected Map applyOverrides(Map overmap) {
        return ReflectionUtilities.applyKeyValueMap((Map)overmap, (Object)this.m_customRoot);
    }
}

