/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.wsdl.tools.custom;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jibx.custom.CustomUtils;
import org.jibx.custom.classes.CustomBase;
import org.jibx.custom.classes.IDocumentFormatter;
import org.jibx.custom.classes.JiBX_class_customs_bindingMungeAdapter;
import org.jibx.custom.classes.SharedNestingBase;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.Utility;
import org.jibx.runtime.impl.ITrackSourceImpl;
import org.jibx.runtime.impl.UnmarshallingContext;
import org.jibx.util.IClass;
import org.jibx.util.IClassItem;
import org.jibx.util.IClassLocator;
import org.jibx.util.StringArray;
import org.jibx.ws.wsdl.tools.custom.NestingBase;
import org.jibx.ws.wsdl.tools.custom.OperationCustom;

public class ServiceCustom
extends NestingBase
implements ITrackSourceImpl {
    private static final Logger s_logger = Logger.getLogger((String)ServiceCustom.class.getName());
    public static final StringArray s_allowedAttributes = new StringArray(new String[]{"binding-name", "class", "excludes", "includes", "port-name", "port-type-name", "service-address", "service-name", "wsdl-namespace"}, NestingBase.s_allowedAttributes);
    private final String m_className;
    private String m_serviceName;
    private String m_portName;
    private String m_bindingName;
    private String m_portTypeName;
    private String m_wsdlNamespace;
    private String m_serviceAddress;
    private List m_documentation;
    private String[] m_includes;
    private String[] m_excludes;
    private final ArrayList m_operations;
    private IClass m_classInformation;
    private String m_namespace;
    private /* synthetic */ String jibx_sourceDocument;
    private /* synthetic */ int jibx_sourceLine;
    private /* synthetic */ int jibx_sourceColumn;

    public ServiceCustom(SharedNestingBase parent, String clas) {
        super(parent);
        this.m_className = clas;
        this.m_operations = new ArrayList();
    }

    private void preSet(IUnmarshallingContext uctx) {
        this.validateAttributes(uctx, s_allowedAttributes);
    }

    public String getClassName() {
        return this.m_className;
    }

    public String getServiceName() {
        return this.m_serviceName;
    }

    public String getPortName() {
        return this.m_portName;
    }

    public String getBindingName() {
        return this.m_bindingName;
    }

    public String getPortTypeName() {
        return this.m_portTypeName;
    }

    public String getServiceAddress() {
        return this.m_serviceAddress;
    }

    public List getDocumentation() {
        return this.m_documentation;
    }

    public String[] getExcludes() {
        return this.m_excludes;
    }

    public String[] getIncludes() {
        return this.m_includes;
    }

    public ArrayList getOperations() {
        return this.m_operations;
    }

    @Override
    public String getWsdlNamespace() {
        return this.m_wsdlNamespace;
    }

    protected void addChild(CustomBase child) {
        if (child.getParent() != this) {
            throw new IllegalStateException("Internal error: child not linked");
        }
        this.m_operations.add(child);
    }

    static ServiceCustom factory(IUnmarshallingContext ictx) throws JiBXException {
        String clas = ((UnmarshallingContext)ictx).attributeText(null, "class");
        s_logger.debug((Object)("Creating instance for class " + clas));
        return new ServiceCustom((SharedNestingBase)ServiceCustom.getContainingObject(ictx), clas);
    }

    private String deriveServiceNamespace(String uri) {
        if (!uri.endsWith("/")) {
            uri = uri + '/';
        }
        uri = uri + this.m_serviceName;
        return uri;
    }

    public void apply(IClassLocator icl, IDocumentFormatter fmt) {
        String base;
        String uri;
        this.m_classInformation = icl.getRequiredClassInfo(this.m_className);
        int split = this.m_className.lastIndexOf(46);
        if (this.m_serviceName == null) {
            String simple = this.m_className.substring(split + 1);
            String name = ServiceCustom.convertName(simple, 1);
            this.m_serviceName = this.registerName(name, this);
            s_logger.debug((Object)("Generated service name from class name: " + this.m_serviceName + " (base " + name + ')'));
        } else if (!this.m_serviceName.equals(this.registerName(this.m_serviceName, this))) {
            throw new IllegalStateException("Service name conflict for '" + this.m_serviceName + '\'');
        }
        if (this.m_portName == null) {
            this.m_portName = this.m_serviceName + "Port";
        }
        if (this.m_bindingName == null) {
            this.m_bindingName = this.m_serviceName + "Binding";
        }
        if (this.m_portTypeName == null) {
            this.m_portTypeName = this.m_serviceName + "PortType";
        }
        if ((uri = this.getSpecifiedNamespace()) == null) {
            int style = this.getNamespaceStyle();
            String base2 = uri = ServiceCustom.deriveNamespace(this.getParent().getNamespace(), this.m_classInformation.getPackage(), style);
            if (style == 1) {
                uri = this.deriveServiceNamespace(base2);
            }
            s_logger.debug((Object)("Generated service namespace URI: " + uri + " (base " + base2 + ')'));
        }
        this.setNamespace(uri);
        if (this.m_wsdlNamespace == null) {
            String ns = ((NestingBase)this.getParent()).getWsdlNamespace();
            if (ns == null) {
                this.m_wsdlNamespace = ServiceCustom.packageToNamespace(ServiceCustom.packageOfType(this.m_className)) + '/' + this.m_serviceName;
                s_logger.debug((Object)("Generated WSDL namespace URI: " + this.m_wsdlNamespace));
            } else {
                this.m_wsdlNamespace = this.deriveServiceNamespace(ns);
                s_logger.debug((Object)("Derived WSDL namespace URI: " + this.m_wsdlNamespace));
            }
        }
        if (this.m_serviceAddress == null && (base = this.getServiceBase()) != null) {
            StringBuffer buff = new StringBuffer(base);
            if (!base.endsWith("/")) {
                buff.append('/');
            }
            buff.append(this.m_serviceName);
            this.m_serviceAddress = buff.toString();
            s_logger.debug((Object)("Generated service address: " + this.m_serviceAddress));
        }
        if (this.m_documentation == null) {
            this.m_documentation = fmt.docToNodes(this.m_classInformation.getJavaDoc());
        }
        for (int i = 0; i < this.m_operations.size(); ++i) {
            OperationCustom op = (OperationCustom)this.m_operations.get(i);
            String name = op.getOperationName();
            if (name == null || this.registerName(name, op) == name) continue;
            throw new IllegalStateException("Duplicate operation name " + name);
        }
        Set inclset = CustomUtils.noCaseNameSet(this.m_includes);
        Set exclset = CustomUtils.noCaseNameSet(this.m_excludes);
        HashMap<String, OperationCustom> opmap = new HashMap<String, OperationCustom>();
        for (int i = 0; i < this.m_operations.size(); ++i) {
            OperationCustom op = (OperationCustom)this.m_operations.get(i);
            opmap.put(op.getMethodName().toLowerCase(), op);
            s_logger.debug((Object)("Added operation " + op.getOperationName()));
        }
        IClassItem[] methods = this.m_classInformation.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            IClassItem method = methods[i];
            String name = method.getName();
            String lcname = name.toLowerCase();
            int access = method.getAccessFlags();
            OperationCustom op = (OperationCustom)opmap.get(lcname);
            if (!(op != null || Modifier.isStatic(access) || Modifier.isTransient(access) || "<init>".equals(name))) {
                boolean use = true;
                if (inclset != null) {
                    use = inclset.contains(lcname);
                } else if (exclset != null) {
                    boolean bl = use = !exclset.contains(lcname);
                }
                if (use) {
                    op = new OperationCustom(this, name);
                    this.m_operations.add(op);
                    s_logger.debug((Object)("Generated operation for method " + name));
                }
            }
            if (op == null) continue;
            op.apply(method, icl, fmt);
        }
    }

    public /* synthetic */ void jibx_setSource(String arg1, int arg2, int arg3) {
        this.jibx_sourceDocument = arg1;
        this.jibx_sourceLine = arg2;
        this.jibx_sourceColumn = arg3;
    }

    public /* synthetic */ String jibx_getDocumentName() {
        return this.jibx_sourceDocument;
    }

    public /* synthetic */ int jibx_getLineNumber() {
        return this.jibx_sourceLine;
    }

    public /* synthetic */ int jibx_getColumnNumber() {
        return this.jibx_sourceColumn;
    }

    public static /* synthetic */ ServiceCustom JiBX_wsdlgen_customs_binding_newinstance_4_0(ServiceCustom arg1, UnmarshallingContext arg2) throws JiBXException {
        if (arg1 == null) {
            arg1 = ServiceCustom.factory((IUnmarshallingContext)arg2);
        }
        return arg1;
    }

    public static /* synthetic */ ServiceCustom JiBX_wsdlgen_customs_binding_unmarshalAttr_4_0(ServiceCustom arg1, UnmarshallingContext arg2) throws JiBXException {
        ServiceCustom serviceCustom = arg1;
        arg1.preSet((IUnmarshallingContext)arg2);
        arg2.pushTrackedObject((Object)arg1);
        ServiceCustom serviceCustom2 = arg1;
        NestingBase nestingBase = NestingBase.JiBX_wsdlgen_customs_binding_unmarshalAttr_3_0(arg1, arg2);
        arg1.m_className = arg2.attributeText(null, "class");
        arg1.m_serviceName = arg2.attributeText(null, "service-name", null);
        arg1.m_portName = arg2.attributeText(null, "port-name", null);
        arg1.m_bindingName = arg2.attributeText(null, "binding-name", null);
        arg1.m_portTypeName = arg2.attributeText(null, "port-type-name", null);
        arg1.m_wsdlNamespace = arg2.attributeText(null, "wsdl-namespace", null);
        arg1.m_serviceAddress = arg2.attributeText(null, "service-address", null);
        String string = arg2.attributeText(null, "includes", null);
        arg1.m_includes = string == null ? null : Utility.deserializeTokenList((String)string);
        String string2 = arg2.attributeText(null, "excludes", null);
        arg1.m_excludes = string2 == null ? null : Utility.deserializeTokenList((String)string2);
        arg2.popObject();
        return arg1;
    }

    public static /* synthetic */ ServiceCustom JiBX_wsdlgen_customs_binding_unmarshal_4_0(ServiceCustom arg1, UnmarshallingContext arg2) throws JiBXException {
        arg2.pushObject((Object)arg1);
        ServiceCustom serviceCustom = arg1;
        arg1.m_operations = JiBX_class_customs_bindingMungeAdapter.JiBX_wsdlgen_customs_binding_unmarshal_1_72(JiBX_class_customs_bindingMungeAdapter.JiBX_class_customs_binding_newinstance_1_0(arg1.m_operations, arg2), arg2);
        arg2.popObject();
        return arg1;
    }
}

