/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.local.office;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jodconverter.core.office.NamedThreadFactory;
import org.jodconverter.core.office.OfficeException;
import org.jodconverter.core.office.RetryTimeoutException;
import org.jodconverter.local.office.ConnectRetryable;
import org.jodconverter.local.office.OfficeConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExternalOfficeConnectionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalOfficeConnectionManager.class);
    private static final long STOP_TASK_TIMEOUT = 60000L;
    private final OfficeConnection connection;
    private final ExecutorService executor;
    private final long connectTimeout;
    private final long connectRetryInterval;
    private final boolean connectFailFast;

    ExternalOfficeConnectionManager(long connectTimeout, long connectRetryInterval, boolean connectFailFast, OfficeConnection connection) {
        this.connectTimeout = connectTimeout;
        this.connectRetryInterval = connectRetryInterval;
        this.connectFailFast = connectFailFast;
        this.connection = connection;
        this.executor = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("jodconverter-extlcxnmng"));
    }

    OfficeConnection getConnection() {
        return this.connection;
    }

    void connect() throws OfficeException {
        if (this.connectFailFast) {
            this.connectAndWait();
        } else {
            this.executor.execute(() -> {
                try {
                    this.connect0();
                }
                catch (Exception ex) {
                    LOGGER.error("Could not establish connection to external process.", (Throwable)ex);
                }
            });
        }
    }

    void disconnect() throws OfficeException {
        this.executor.execute(this::disconnect0);
        this.executor.shutdown();
        try {
            LOGGER.debug("Waiting for stop task to complete ({}) millisecs)...", (Object)60000L);
            if (this.executor.awaitTermination(60000L, TimeUnit.MILLISECONDS)) {
                LOGGER.debug("Stop task executed successfully.");
            } else {
                LOGGER.debug("Could not execute stop task within {} millisecs...", (Object)60000L);
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new OfficeException("Interruption while disconnecting from external office process.", (Throwable)ex);
        }
    }

    void reconnect() {
        LOGGER.info("Reconnecting to external office process due to task timeout...");
        this.executor.execute(() -> {
            this.disconnect0();
            try {
                this.connect0();
            }
            catch (OfficeException ex) {
                LOGGER.error("Could not reconnect to external office process.", (Throwable)ex);
            }
        });
    }

    void ensureConnected() throws OfficeException {
        if (!this.connection.isConnected()) {
            this.connectAndWait();
        }
    }

    private void connectAndWait() throws OfficeException {
        LOGGER.debug("Submitting connect task...");
        Future<Void> future = this.executor.submit(this::connect0);
        try {
            LOGGER.debug("Waiting for connect task to complete...");
            future.get();
            LOGGER.debug("Connect task executed successfully.");
        }
        catch (ExecutionException ex) {
            if (ex.getCause() instanceof OfficeException) {
                throw (OfficeException)ex.getCause();
            }
            throw new OfficeException("Connect task did not complete", ex.getCause());
        }
        catch (InterruptedException ex) {
            LOGGER.debug("Connect task interrupted.");
            Thread.currentThread().interrupt();
            throw new OfficeException("Interruption while connecting to external office process.", (Throwable)ex);
        }
    }

    private Void connect0() throws OfficeException {
        if (!this.connection.isConnected()) {
            LOGGER.debug("Connecting to external office process...");
            try {
                new ConnectRetryable(this.connection).execute(this.connectRetryInterval, this.connectTimeout);
            }
            catch (RetryTimeoutException ex) {
                throw new OfficeException("Could not establish connection to external process.", (Throwable)ex);
            }
        }
        return null;
    }

    private Void disconnect0() {
        if (this.connection.isConnected()) {
            LOGGER.debug("Disconnecting from external office process...");
            this.connection.disconnect();
        }
        return null;
    }
}

