/*
 * Decompiled with CFR 0.152.
 */
package jodd.http;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import jodd.http.HttpParams;
import jodd.io.FileNameUtil;
import jodd.io.FileUtil;
import jodd.upload.MultipartStreamParser;
import jodd.util.KeyValue;
import jodd.util.MimeTypes;
import jodd.util.RandomStringUtil;
import jodd.util.StringUtil;
import jodd.util.buffer.FastByteBuffer;

public class HttpTransfer {
    protected String httpVersion = "HTTP/1.1";
    protected String host;
    protected int port = 80;
    protected String method;
    protected String path;
    protected int statusCode;
    protected String statusPhrase;
    protected Map<String, String[]> headers = new LinkedHashMap<String, String[]>();
    protected byte[] body;
    public static final byte[] SPACE = " ".getBytes();
    public static final byte[] CRLF = "\r\n".getBytes();

    public URL buildURL() {
        try {
            return new URL("http", this.host, this.port, this.path);
        }
        catch (MalformedURLException murlex) {
            return null;
        }
    }

    public String getHttpVersion() {
        return this.httpVersion;
    }

    public void setHttpVersion(String httpVersion) {
        this.httpVersion = httpVersion;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        this.path = path;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public String getStatusPhrase() {
        return this.statusPhrase;
    }

    public void setStatusPhrase(String statusPhrase) {
        this.statusPhrase = statusPhrase;
    }

    public String getHeader(String name) {
        String key = name.trim().toLowerCase();
        String[] values = this.headers.get(key);
        if (values == null) {
            return null;
        }
        return this.headers.get(key)[1];
    }

    public void removeHeader(String name) {
        String key = name.trim().toLowerCase();
        this.headers.remove(key);
    }

    public void addHeader(String name, String value) {
        String key = name.trim().toLowerCase();
        this.headers.put(key, new String[]{name, value.trim()});
    }

    public void addHeader(String name, int value) {
        this.addHeader(name, String.valueOf(value));
    }

    public byte[] getBody() {
        return this.body;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public void setQueryParameters(HttpParams httpParams) {
        String path = this.getPath();
        int ndx = path.indexOf(63);
        if (ndx != -1) {
            path = path.substring(0, ndx);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(path);
        String query = httpParams.toString();
        if (query.length() != 0) {
            sb.append('?');
            sb.append(query);
        }
        this.setPath(sb.toString());
    }

    public HttpParams getQueryParameters() {
        String path = this.getPath();
        HttpParams httpParams = null;
        int ndx = path.indexOf(63);
        if (ndx != -1) {
            String query = path.substring(ndx + 1);
            httpParams = new HttpParams();
            httpParams.addParameters(query, true);
        }
        return httpParams;
    }

    public HttpParams getRequestParameters() {
        String[] values;
        String contentType = this.getHeader("Content-Type");
        if (contentType.equals("application/x-www-form-urlencoded")) {
            try {
                return new HttpParams(new String(this.body, "ISO-8859-1"), true);
            }
            catch (UnsupportedEncodingException ignore) {
                // empty catch block
            }
        }
        HttpParams httpParams = new HttpParams();
        MultipartStreamParser multipartParser = new MultipartStreamParser();
        ByteArrayInputStream bin = new ByteArrayInputStream(this.body);
        try {
            multipartParser.parseRequestStream((InputStream)bin, "ISO-8859-1");
        }
        catch (IOException ioex) {
            return null;
        }
        for (String paramName : multipartParser.getParameterNames()) {
            values = multipartParser.getParameterValues(paramName);
            if (values.length == 1) {
                httpParams.addParameter(paramName, values[0]);
                continue;
            }
            httpParams.addParameter(paramName, values);
        }
        for (String paramName : multipartParser.getFileParameterNames()) {
            values = multipartParser.getFiles(paramName);
            if (values.length == 1) {
                httpParams.addParameter(paramName, values[0]);
                continue;
            }
            httpParams.addParameter(paramName, values);
        }
        return httpParams;
    }

    public void setRequestParameters(HttpParams httpParams) {
        if (httpParams.hasFiles()) {
            try {
                this.setMultipartRequestParameters(httpParams);
            }
            catch (IOException ignore) {
                // empty catch block
            }
            return;
        }
        String body = httpParams.toString();
        this.addHeader("Content-Type", "application/x-www-form-urlencoded");
        try {
            byte[] bytes = body.getBytes("ISO-8859-1");
            this.setBody(bytes);
            this.addHeader("Content-Length", bytes.length);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    protected void setMultipartRequestParameters(HttpParams httpParams) throws IOException {
        String boundary = StringUtil.repeat((char)'-', (int)15) + RandomStringUtil.randomAlphaNumeric((int)25);
        this.addHeader("Content-Type", "multipart/form-data, boundary=" + boundary);
        Iterator<KeyValue<String, Object>> iter = httpParams.iterate();
        StringBuilder sb = new StringBuilder();
        while (iter.hasNext()) {
            KeyValue<String, Object> entry = iter.next();
            sb.append(boundary);
            sb.append("\r\n");
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            Class<?> type = value.getClass();
            if (type == String.class) {
                sb.append("Content-Disposition: form-data; name=\"").append(name).append("\"\r\n\r\n");
                sb.append(value);
            } else if (type == String[].class) {
                String[] array;
                for (String v : array = (String[])value) {
                    sb.append("Content-Disposition: form-data; name=\"").append(name).append("\"\r\n\r\n");
                    sb.append(v);
                }
            } else if (value instanceof File) {
                File file = (File)value;
                String fileName = FileNameUtil.getName((String)file.getName());
                sb.append("Content-Disposition: form-data; name=\"").append(name).append("\";filename=\"").append(fileName).append("\"\r\n");
                sb.append("Content-Type: ").append(MimeTypes.getMimeType((String)FileNameUtil.getExtension((String)fileName))).append("\r\n");
                sb.append("Content-Transfer-Encoding: binary\r\n\r\n");
                char[] chars = FileUtil.readChars((File)file, (String)"ISO-8859-1");
                sb.append(chars);
            }
            sb.append("\r\n");
        }
        sb.append(boundary).append("--\r\n");
        try {
            byte[] bytes = sb.toString().getBytes("ISO-8859-1");
            this.setBody(bytes);
            this.addHeader("Content-Length", bytes.length);
        }
        catch (UnsupportedEncodingException ignore) {
            // empty catch block
        }
    }

    protected void append(FastByteBuffer buff, String string) {
        try {
            buff.append(string.getBytes("ISO-8859-1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public byte[] toArray() {
        FastByteBuffer buff = new FastByteBuffer();
        if (this.method != null) {
            this.append(buff, this.method);
            buff.append(SPACE);
            this.append(buff, this.path);
            buff.append(SPACE);
            this.append(buff, this.httpVersion);
            buff.append(CRLF);
        } else {
            this.append(buff, this.httpVersion);
            buff.append(SPACE);
            this.append(buff, String.valueOf(this.statusCode));
            buff.append(SPACE);
            this.append(buff, this.statusPhrase);
            buff.append(CRLF);
        }
        for (String[] values : this.headers.values()) {
            String headLine = values[0].concat(": ").concat(values[1]);
            this.append(buff, headLine);
            buff.append(CRLF);
        }
        buff.append(CRLF);
        if (this.body != null) {
            buff.append(this.body);
        }
        return buff.toArray();
    }

    public String toString() {
        try {
            return new String(this.toArray(), "ISO-8859-1");
        }
        catch (UnsupportedEncodingException ignore) {
            return null;
        }
    }

    public void send(OutputStream out) throws IOException {
        out.write(this.toArray());
        out.flush();
    }

    public void send(HttpURLConnection huc) throws IOException {
        if (this.method != null) {
            huc.setRequestMethod(this.method);
        }
        for (String[] values : this.headers.values()) {
            huc.setRequestProperty(values[0], values[1]);
        }
        huc.setDoOutput(true);
        huc.connect();
        if (this.body != null) {
            OutputStream out = huc.getOutputStream();
            out.write(this.body);
            out.flush();
        }
    }
}

