/*
 * Decompiled with CFR 0.152.
 */
package jodd.http;

import java.util.Map;
import jodd.http.HttpParamsMap;
import jodd.util.StringBand;
import jodd.util.URLCoder;
import jodd.util.URLDecoder;

public class HttpUtil {
    public static String buildQuery(HttpParamsMap queryMap, String encoding) {
        int queryMapSize = queryMap.size();
        if (queryMapSize == 0) {
            return "";
        }
        StringBand query = new StringBand(queryMapSize * 4);
        int count = 0;
        for (Map.Entry entry : queryMap.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (count != 0) {
                query.append('&');
            }
            key = URLCoder.encodeQuery((String)key, (String)encoding);
            query.append(key);
            if (value != null) {
                query.append('=');
                if (value instanceof String) {
                    String valueString = URLCoder.encodeQuery((String)((String)value), (String)encoding);
                    query.append(valueString);
                } else {
                    String[] values = (String[])value;
                    for (int i = 0; i < values.length; ++i) {
                        String s = values[i];
                        if (i != 0) {
                            query.append('&');
                            query.append(key);
                            query.append('=');
                        }
                        query.append(s);
                    }
                }
            }
            ++count;
        }
        return query.toString();
    }

    public static HttpParamsMap parseQuery(String query, boolean decode) {
        HttpParamsMap queryMap = new HttpParamsMap();
        int ndx2 = 0;
        while (true) {
            int ndx;
            if ((ndx = query.indexOf(61, ndx2)) == -1) {
                if (ndx2 >= query.length()) break;
                queryMap.put(query.substring(ndx2), (Object)null);
                break;
            }
            String name = query.substring(ndx2, ndx);
            if (decode) {
                name = URLDecoder.decode((String)name);
            }
            if ((ndx = query.indexOf(38, ndx2 = ndx + 1)) == -1) {
                ndx = query.length();
            }
            String value = query.substring(ndx2, ndx);
            if (decode) {
                value = URLDecoder.decode((String)value);
            }
            queryMap.put(name, (Object)value);
            ndx2 = ndx + 1;
        }
        return queryMap;
    }

    public static String prepareHeaderParameterName(String headerName) {
        if (headerName.equals("etag")) {
            return "ETag";
        }
        if (headerName.equals("www-authenticate")) {
            return "WWW-Authenticate";
        }
        char[] name = headerName.toCharArray();
        boolean capitalize = true;
        for (int i = 0; i < name.length; ++i) {
            char c = name[i];
            if (c == '-') {
                capitalize = true;
                continue;
            }
            if (capitalize) {
                name[i] = Character.toUpperCase(c);
                capitalize = false;
                continue;
            }
            name[i] = Character.toLowerCase(c);
        }
        return new String(name);
    }

    public static String extractMediaType(String contentType) {
        int index = contentType.indexOf(59);
        if (index == -1) {
            return contentType;
        }
        return contentType.substring(0, index);
    }

    public static String extractContentTypeCharset(String contentType) {
        return HttpUtil.extractContentTypeParameter(contentType, "charset");
    }

    public static String extractContentTypeParameter(String contentType, String parameter) {
        int eqNdx;
        int index = 0;
        while (true) {
            if ((index = contentType.indexOf(59, index)) == -1) {
                return null;
            }
            ++index;
            while (contentType.charAt(index) == ' ') {
                ++index;
            }
            eqNdx = contentType.indexOf(61, index);
            if (eqNdx == -1) {
                return null;
            }
            String paramName = contentType.substring(index, eqNdx);
            ++eqNdx;
            if (paramName.equalsIgnoreCase(parameter)) break;
            index = eqNdx;
        }
        int endIndex = contentType.indexOf(59, eqNdx);
        if (endIndex == -1) {
            return contentType.substring(eqNdx);
        }
        return contentType.substring(eqNdx, endIndex);
    }
}

