/*
 * Decompiled with CFR 0.152.
 */
package jodd.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.LinkedList;
import jodd.http.HttpProgressListener;
import jodd.http.up.Uploadable;
import jodd.io.StreamUtil;

public class Buffer {
    protected LinkedList<Object> list = new LinkedList();
    protected StringBuilder lastString;
    protected int size;

    public Buffer append(String string) {
        this.ensureLastString();
        this.lastString.append(string);
        this.size += string.length();
        return this;
    }

    public Buffer append(char c) {
        this.ensureLastString();
        this.lastString.append(c);
        ++this.size;
        return this;
    }

    public Buffer append(int number) {
        this.append(Integer.toString(number));
        return this;
    }

    public Buffer append(Uploadable uploadable) {
        this.list.add(uploadable);
        this.size += uploadable.getSize();
        this.lastString = null;
        return this;
    }

    public Buffer append(Buffer buffer) {
        if (buffer.list.size() == 0) {
            return buffer;
        }
        this.list.addAll(buffer.list);
        this.lastString = buffer.lastString;
        this.size += buffer.size;
        return this;
    }

    public int size() {
        return this.size;
    }

    private void ensureLastString() {
        if (this.lastString == null) {
            this.lastString = new StringBuilder();
            this.list.add(this.lastString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(Writer writer) throws IOException {
        for (Object e : this.list) {
            if (e instanceof StringBuilder) {
                StringBuilder sb = (StringBuilder)e;
                writer.write(sb.toString());
                continue;
            }
            if (!(e instanceof Uploadable)) continue;
            Uploadable uploadable = (Uploadable)e;
            InputStream inputStream = uploadable.openInputStream();
            try {
                StreamUtil.copy((InputStream)inputStream, (Writer)writer, (String)"ISO-8859-1");
            }
            finally {
                StreamUtil.close((InputStream)inputStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream out) throws IOException {
        for (Object e : this.list) {
            if (e instanceof StringBuilder) {
                StringBuilder sb = (StringBuilder)e;
                out.write(sb.toString().getBytes("ISO-8859-1"));
                continue;
            }
            if (!(e instanceof Uploadable)) continue;
            Uploadable uploadable = (Uploadable)e;
            InputStream inputStream = uploadable.openInputStream();
            try {
                StreamUtil.copy((InputStream)inputStream, (OutputStream)out);
            }
            finally {
                StreamUtil.close((InputStream)inputStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream out, HttpProgressListener progressListener) throws IOException {
        int size = this.size();
        int callbackSize = progressListener.callbackSize(size);
        int count = 0;
        int step = 0;
        progressListener.transferred(count);
        for (Object e : this.list) {
            int chunk;
            if (e instanceof StringBuilder) {
                StringBuilder sb = (StringBuilder)e;
                byte[] bytes = sb.toString().getBytes("ISO-8859-1");
                int offset = 0;
                while (offset < bytes.length) {
                    chunk = callbackSize - step;
                    if (offset + chunk > bytes.length) {
                        chunk = bytes.length - offset;
                    }
                    out.write(bytes, offset, chunk);
                    offset += chunk;
                    count += chunk;
                    if ((step += chunk) < callbackSize) continue;
                    progressListener.transferred(count);
                    step -= callbackSize;
                }
                continue;
            }
            if (!(e instanceof Uploadable)) continue;
            Uploadable uploadable = (Uploadable)e;
            InputStream inputStream = uploadable.openInputStream();
            int remaining = uploadable.getSize();
            try {
                while (remaining > 0) {
                    chunk = callbackSize - step;
                    if (chunk > remaining) {
                        chunk = remaining;
                    }
                    StreamUtil.copy((InputStream)inputStream, (OutputStream)out, (int)chunk);
                    remaining -= chunk;
                    count += chunk;
                    if ((step += chunk) < callbackSize) continue;
                    progressListener.transferred(count);
                    step -= callbackSize;
                }
            }
            finally {
                StreamUtil.close((InputStream)inputStream);
            }
        }
        if (step != 0) {
            progressListener.transferred(count);
        }
    }
}

