/*
 * Decompiled with CFR 0.152.
 */
package jodd.http.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import jodd.http.HttpConnection;
import jodd.http.HttpConnectionProvider;
import jodd.http.HttpException;
import jodd.http.HttpRequest;
import jodd.http.ProxyInfo;
import jodd.http.net.HTTPProxySocketFactory;
import jodd.http.net.SocketHttpConnection;
import jodd.http.net.SocketHttpSecureConnection;
import jodd.http.net.Socks4ProxySocketFactory;
import jodd.http.net.Socks5ProxySocketFactory;
import jodd.http.net.TrustManagers;
import jodd.util.StringUtil;

public class SocketHttpConnectionProvider
implements HttpConnectionProvider {
    protected ProxyInfo proxy = ProxyInfo.directProxy();
    protected String secureEnabledProtocols = System.getProperty("https.protocols");

    @Override
    public void useProxy(ProxyInfo proxyInfo) {
        this.proxy = proxyInfo;
    }

    public void setSecuredProtocols(String secureEnabledProtocols) {
        this.secureEnabledProtocols = secureEnabledProtocols;
    }

    @Override
    public HttpConnection createHttpConnection(HttpRequest httpRequest) throws IOException {
        SocketHttpConnection httpConnection;
        boolean https = httpRequest.protocol().equalsIgnoreCase("https");
        if (https) {
            SSLSocket sslSocket = this.createSSLSocket(httpRequest.host(), httpRequest.port(), httpRequest.connectionTimeout(), httpRequest.trustAllCertificates(), httpRequest.verifyHttpsHost());
            httpConnection = new SocketHttpSecureConnection(sslSocket);
        } else {
            Socket socket = this.createSocket(httpRequest.host(), httpRequest.port(), httpRequest.connectionTimeout());
            httpConnection = new SocketHttpConnection(socket);
        }
        httpConnection.setTimeout(httpRequest.timeout());
        try {
            httpConnection.init();
        }
        catch (Throwable throwable) {
            httpConnection.close();
            throw new HttpException(throwable);
        }
        return httpConnection;
    }

    protected Socket createSocket(String host, int port, int connectionTimeout) throws IOException {
        SocketFactory socketFactory = this.getSocketFactory(this.proxy, false, false);
        if (connectionTimeout < 0) {
            return socketFactory.createSocket(host, port);
        }
        Socket socket = socketFactory.createSocket();
        socket.connect(new InetSocketAddress(host, port), connectionTimeout);
        return socket;
    }

    protected SSLSocket createSSLSocket(String host, int port, int connectionTimeout, boolean trustAll, boolean verifyHttpsHost) throws IOException {
        Socket socket;
        SocketFactory socketFactory = this.getSocketFactory(this.proxy, true, trustAll);
        if (connectionTimeout < 0) {
            socket = socketFactory.createSocket(host, port);
        } else {
            socket = new Socket();
            socket.connect(new InetSocketAddress(host, port), connectionTimeout);
        }
        SSLSocket sslSocket = socket instanceof SSLSocket ? (SSLSocket)socket : (socketFactory instanceof SSLSocketFactory ? (SSLSocket)((SSLSocketFactory)socketFactory).createSocket(socket, host, port, true) : (SSLSocket)this.getDefaultSSLSocketFactory(trustAll).createSocket(socket, host, port, true));
        if (this.secureEnabledProtocols != null) {
            String[] values = StringUtil.splitc((String)this.secureEnabledProtocols, (char)',');
            StringUtil.trimAll((String[])values);
            sslSocket.setEnabledProtocols(values);
        }
        if (verifyHttpsHost) {
            SSLParameters sslParams = new SSLParameters();
            sslParams.setEndpointIdentificationAlgorithm("HTTPS");
            sslSocket.setSSLParameters(sslParams);
        }
        return sslSocket;
    }

    protected SSLSocketFactory getDefaultSSLSocketFactory(boolean trustAllCertificates) throws IOException {
        if (trustAllCertificates) {
            try {
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, TrustManagers.TRUST_ALL_CERTS, new SecureRandom());
                return sc.getSocketFactory();
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                throw new IOException(e);
            }
        }
        return (SSLSocketFactory)SSLSocketFactory.getDefault();
    }

    protected SocketFactory getSocketFactory(ProxyInfo proxy, boolean ssl, boolean trustAllCertificates) throws IOException {
        switch (proxy.getProxyType()) {
            case NONE: {
                if (ssl) {
                    return this.getDefaultSSLSocketFactory(trustAllCertificates);
                }
                return SocketFactory.getDefault();
            }
            case HTTP: {
                return new HTTPProxySocketFactory(proxy);
            }
            case SOCKS4: {
                return new Socks4ProxySocketFactory(proxy);
            }
            case SOCKS5: {
                return new Socks5ProxySocketFactory(proxy);
            }
        }
        return null;
    }
}

