/*
 * Decompiled with CFR 0.152.
 */
package jodd.http.upload;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import jodd.http.HttpException;
import jodd.http.upload.Uploadable;
import jodd.io.FileNameUtil;
import jodd.io.FileUtil;

public class FileUploadable
implements Uploadable<File> {
    protected final File file;
    protected final String fileName;
    protected final String mimeType;

    public FileUploadable(File file) {
        this.file = file;
        this.fileName = FileNameUtil.getName((String)file.getName());
        this.mimeType = null;
    }

    public FileUploadable(File file, String fileName, String mimeType) {
        this.file = file;
        this.fileName = fileName;
        this.mimeType = mimeType;
    }

    @Override
    public File getContent() {
        return this.file;
    }

    @Override
    public byte[] getBytes() {
        try {
            return FileUtil.readBytes((File)this.file);
        }
        catch (IOException ioex) {
            throw new HttpException(ioex);
        }
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public int getSize() {
        return (int)this.file.length();
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return new FileInputStream(this.file);
    }
}

