/*
 * Decompiled with CFR 0.152.
 */
package jodd.csselly.selector;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jodd.csselly.CSSellyException;
import jodd.csselly.Selector;
import jodd.csselly.selector.PseudoClass;
import jodd.csselly.selector.PseudoClasses;
import jodd.lagarto.dom.Node;
import jodd.lagarto.dom.NodeFilter;
import jodd.lagarto.dom.NodeListFilter;
import jodd.util.ClassUtil;

public class PseudoClassSelector
extends Selector
implements NodeFilter,
NodeListFilter {
    protected static final Map<String, PseudoClass> PSEUDO_CLASS_MAP = new HashMap<String, PseudoClass>(26);
    protected final PseudoClass pseudoClass;

    public static void registerPseudoClass(Class<? extends PseudoClass> pseudoClassType) {
        PseudoClass pseudoClass;
        try {
            pseudoClass = (PseudoClass)ClassUtil.newInstance(pseudoClassType);
        }
        catch (Exception ex) {
            throw new CSSellyException(ex);
        }
        PSEUDO_CLASS_MAP.put(pseudoClass.getPseudoClassName(), pseudoClass);
    }

    public static PseudoClass lookupPseudoClass(String pseudoClassName) {
        PseudoClass pseudoClass = PSEUDO_CLASS_MAP.get(pseudoClassName);
        if (pseudoClass == null) {
            throw new CSSellyException("Unsupported pseudo class: " + pseudoClassName);
        }
        return pseudoClass;
    }

    public PseudoClassSelector(String pseudoClassName) {
        super(Selector.Type.PSEUDO_CLASS);
        this.pseudoClass = PseudoClassSelector.lookupPseudoClass(pseudoClassName.trim());
    }

    public PseudoClass getPseudoClass() {
        return this.pseudoClass;
    }

    @Override
    public boolean accept(Node node) {
        return this.pseudoClass.match(node);
    }

    @Override
    public boolean accept(List<Node> currentResults, Node node, int index) {
        return this.pseudoClass.matchInRange(currentResults, node, index);
    }

    static {
        PseudoClassSelector.registerPseudoClass(PseudoClasses.EMPTY.class);
        PseudoClassSelector.registerPseudoClass(PseudoClasses.FIRST_CHILD.class);
        PseudoClassSelector.registerPseudoClass(PseudoClasses.FIRST_OF_TYPE.class);
        PseudoClassSelector.registerPseudoClass(PseudoClasses.LAST_CHILD.class);
        PseudoClassSelector.registerPseudoClass(PseudoClasses.LAST_OF_TYPE.class);
        PseudoClassSelector.registerPseudoClass(PseudoClasses.ONLY_CHILD.class);
        PseudoClassSelector.registerPseudoClass(PseudoClasses.ONLY_OF_TYPE.class);
        PseudoClassSelector.registerPseudoClass(PseudoClasses.ROOT.class);
        PseudoClassSelector.registerPseudoClass(PseudoClasses.FIRST.class);
        PseudoClassSelector.registerPseudoClass(PseudoClasses.LAST.class);
        PseudoClassSelector.registerPseudoClass(PseudoClasses.BUTTON.class);
        PseudoClassSelector.registerPseudoClass(PseudoClasses.CHECKBOX.class);
        PseudoClassSelector.registerPseudoClass(PseudoClasses.FILE.class);
        PseudoClassSelector.registerPseudoClass(PseudoClasses.IMAGE.class);
        PseudoClassSelector.registerPseudoClass(PseudoClasses.INPUT.class);
        PseudoClassSelector.registerPseudoClass(PseudoClasses.HEADER.class);
        PseudoClassSelector.registerPseudoClass(PseudoClasses.PARENT.class);
        PseudoClassSelector.registerPseudoClass(PseudoClasses.PASSWORD.class);
        PseudoClassSelector.registerPseudoClass(PseudoClasses.RADIO.class);
        PseudoClassSelector.registerPseudoClass(PseudoClasses.RESET.class);
        PseudoClassSelector.registerPseudoClass(PseudoClasses.SELECTED.class);
        PseudoClassSelector.registerPseudoClass(PseudoClasses.CHECKED.class);
        PseudoClassSelector.registerPseudoClass(PseudoClasses.SUBMIT.class);
        PseudoClassSelector.registerPseudoClass(PseudoClasses.TEXT.class);
        PseudoClassSelector.registerPseudoClass(PseudoClasses.EVEN.class);
        PseudoClassSelector.registerPseudoClass(PseudoClasses.ODD.class);
    }
}

