/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.nativewindow.x11;

import javax.media.nativewindow.DefaultGraphicsDevice;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.nativewindow.ToolkitLock;
import jogamp.nativewindow.x11.X11Lib;
import jogamp.nativewindow.x11.X11Util;

public class X11GraphicsDevice
extends DefaultGraphicsDevice
implements Cloneable {
    boolean handleOwner;
    final boolean isXineramaEnabled;

    public X11GraphicsDevice(String string, int n) {
        super(NativeWindowFactory.TYPE_X11, string, n);
        this.handleOwner = false;
        this.isXineramaEnabled = false;
    }

    public X11GraphicsDevice(long l, int n, boolean bl) {
        super(NativeWindowFactory.TYPE_X11, X11Lib.XDisplayString(l), n, l);
        if (0L == l) {
            throw new NativeWindowException("null display");
        }
        this.handleOwner = bl;
        this.isXineramaEnabled = X11Util.XineramaIsEnabled(this);
    }

    public X11GraphicsDevice(long l, int n, ToolkitLock toolkitLock, boolean bl) {
        super(NativeWindowFactory.TYPE_X11, X11Lib.XDisplayString(l), n, l, toolkitLock);
        if (0L == l) {
            throw new NativeWindowException("null display");
        }
        this.handleOwner = bl;
        this.isXineramaEnabled = X11Util.XineramaIsEnabled(this);
    }

    private static int getDefaultScreenImpl(long l) {
        return X11Lib.DefaultScreen(l);
    }

    public int getDefaultScreen() {
        long l = this.getHandle();
        if (0L == l) {
            throw new NativeWindowException("null display");
        }
        int n = X11GraphicsDevice.getDefaultScreenImpl(l);
        if (DEBUG) {
            System.err.println(Thread.currentThread().getName() + " - X11GraphicsDevice.getDefaultDisplay() of " + this + ": " + n + ", count " + X11Lib.ScreenCount(l));
        }
        return n;
    }

    public int getDefaultVisualID() {
        long l = this.getHandle();
        if (0L == l) {
            throw new NativeWindowException("null display");
        }
        return X11Lib.DefaultVisualID(l, X11GraphicsDevice.getDefaultScreenImpl(l));
    }

    public final boolean isXineramaEnabled() {
        return this.isXineramaEnabled;
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    public boolean open() {
        if (this.handleOwner && 0L == this.handle) {
            if (DEBUG) {
                System.err.println(Thread.currentThread().getName() + " - X11GraphicsDevice.open(): " + this);
            }
            this.handle = X11Util.openDisplay(this.connection);
            if (0L == this.handle) {
                throw new NativeWindowException("X11GraphicsDevice.open() failed: " + this);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean close() {
        if (this.handleOwner && 0L != this.handle) {
            if (DEBUG) {
                System.err.println(Thread.currentThread().getName() + " - X11GraphicsDevice.close(): " + this);
            }
            X11Util.closeDisplay(this.handle);
        }
        return super.close();
    }

    @Override
    public boolean isHandleOwner() {
        return this.handleOwner;
    }

    @Override
    public void clearHandleOwner() {
        this.handleOwner = false;
    }

    @Override
    protected Object getHandleOwnership() {
        return this.handleOwner;
    }

    @Override
    protected Object setHandleOwnership(Object object) {
        Boolean bl = this.handleOwner;
        this.handleOwner = (Boolean)object;
        return bl;
    }
}

