/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.av.impl;

import com.jogamp.common.util.VersionNumber;
import com.jogamp.gluegen.runtime.ProcAddressTable;
import com.jogamp.opengl.util.GLPixelStorageModes;
import com.jogamp.opengl.util.av.AudioSink;
import com.jogamp.opengl.util.av.AudioSinkFactory;
import com.jogamp.opengl.util.av.GLMediaPlayer;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureSequence;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.media.opengl.GL;
import javax.media.opengl.GLException;
import jogamp.opengl.GLContextImpl;
import jogamp.opengl.util.av.EGLMediaPlayerImpl;
import jogamp.opengl.util.av.SyncedRingbuffer;
import jogamp.opengl.util.av.impl.FFMPEGDynamicLibraryBundleInfo;

public class FFMPEGMediaPlayer
extends EGLMediaPlayerImpl {
    private static final int TEMP_BUFFER_COUNT = 20;
    public static final VersionNumber avUtilVersion;
    public static final VersionNumber avFormatVersion;
    public static final VersionNumber avCodecVersion;
    static final boolean available;
    protected long moviePtr = 0L;
    protected long procAddrGLTexSubImage2D = 0L;
    protected EGLMediaPlayerImpl.EGLTextureFrame lastTex = null;
    protected GLPixelStorageModes psm;
    protected PixelFormat vPixelFmt = null;
    protected int vPlanes = 0;
    protected int vBitsPerPixel = 0;
    protected int vBytesPerPixelPerPlane = 0;
    protected int[] vLinesize = new int[]{0, 0, 0};
    protected int[] vTexWidth = new int[]{0, 0, 0};
    protected int texWidth;
    protected int texHeight;
    protected ByteBuffer texCopy;
    protected String singleTexComp = "r";
    protected static final boolean USE_AUDIO_PUSHER = false;
    protected final int AudioFrameCount = 8;
    protected final AudioSink audioSink;
    protected final int maxAvailableAudio;
    protected AudioSink.AudioDataFormat chosenAudioFormat;
    protected final SyncedRingbuffer<AudioSink.AudioFrame> audioFramesBuffer = null;
    static int AudioPusherInstanceId;
    private AudioPusher audioPusher = null;
    private String textureLookupFunctionName = "ffmpegTexture2D";
    private long lastAudioTime = 0L;
    private int lastAudioPTS = 0;
    private static final int audio_dt_d = 400;
    private long lastVideoTime = 0L;
    private int lastVideoPTS = 0;
    private static final int video_dt_d = 9;

    public static final boolean isAvailable() {
        return available;
    }

    private static VersionNumber getAVVersion(int n) {
        return new VersionNumber(n >> 16 & 0xFF, n >> 8 & 0xFF, n >> 0 & 0xFF);
    }

    public FFMPEGMediaPlayer() {
        super(EGLMediaPlayerImpl.TextureType.GL, false);
        if (!available) {
            throw new RuntimeException("FFMPEGMediaPlayer not available");
        }
        this.setTextureCount(1);
        this.moviePtr = this.createInstance0(DEBUG);
        if (0L == this.moviePtr) {
            throw new GLException("Couldn't create FFMPEGInstance");
        }
        this.psm = new GLPixelStorageModes();
        this.audioSink = AudioSinkFactory.createDefault();
        this.maxAvailableAudio = this.audioSink.getQueuedByteCount();
    }

    @Override
    protected TextureSequence.TextureFrame createTexImage(GL gL, int n, int[] nArray) {
        if (EGLMediaPlayerImpl.TextureType.GL != this.texType) {
            throw new InternalError("n/a");
        }
        Texture texture = super.createTexImageImpl(gL, n, nArray, this.texWidth, this.texHeight, true);
        this.lastTex = new EGLMediaPlayerImpl.EGLTextureFrame(null, texture, 0L, 0L);
        return this.lastTex;
    }

    @Override
    protected void destroyTexImage(GL gL, TextureSequence.TextureFrame textureFrame) {
        this.lastTex = null;
        super.destroyTexImage(gL, textureFrame);
    }

    @Override
    protected void destroyImpl(GL gL) {
        if (this.moviePtr != 0L) {
            this.destroyInstance0(this.moviePtr);
            this.moviePtr = 0L;
        }
    }

    @Override
    protected void initGLStreamImpl(GL gL, int[] nArray) throws IOException {
        int n;
        if (0L == this.moviePtr) {
            throw new GLException("FFMPEG native instance null");
        }
        String string = this.urlConn.getURL().toExternalForm();
        this.chosenAudioFormat = this.audioSink.initSink(this.audioSink.getPreferredFormat(), 8);
        System.err.println("setURL: p1 " + this);
        this.setStream0(this.moviePtr, string, -1, -1, 8);
        System.err.println("setURL: p2 " + this);
        int n2 = 6408;
        switch (this.vBytesPerPixelPerPlane) {
            case 1: {
                if (gL.isGL3ES3()) {
                    n = 6403;
                    n2 = 6403;
                    this.singleTexComp = "r";
                    break;
                }
                n = 6406;
                n2 = 6406;
                this.singleTexComp = "a";
                break;
            }
            case 3: {
                n = 6407;
                n2 = 6407;
                break;
            }
            case 4: {
                n = 6408;
                n2 = 6408;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported bytes-per-pixel / plane " + this.vBytesPerPixelPerPlane);
            }
        }
        this.setTextureFormat(n2, n);
        this.setTextureType(5121);
        GLContextImpl gLContextImpl = (GLContextImpl)gL.getContext();
        ProcAddressTable procAddressTable = gLContextImpl.getGLProcAddressTable();
        this.procAddrGLTexSubImage2D = this.getAddressFor(procAddressTable, "glTexSubImage2D");
        if (0L == this.procAddrGLTexSubImage2D) {
            throw new InternalError("glTexSubImage2D n/a in ProcAddressTable: " + procAddressTable.getClass().getName() + " of " + gLContextImpl.getGLVersion());
        }
    }

    private final long getAddressFor(final ProcAddressTable procAddressTable, final String string) {
        return AccessController.doPrivileged(new PrivilegedAction<Long>(){

            @Override
            public Long run() {
                try {
                    return procAddressTable.getAddressFor(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return 0L;
                }
            }
        });
    }

    private final void pushSound(ByteBuffer byteBuffer, int n, int n2) {
        this.pushAudioFrame(new AudioSink.AudioFrame(byteBuffer, n, n2));
    }

    private final void pushAudioFrame(AudioSink.AudioFrame audioFrame) {
        long l = audioFrame.audioPTS - this.lastAudioPTS;
        long l2 = System.currentTimeMillis();
        long l3 = l2 - this.lastAudioTime;
        long l4 = (long)((float)(l - l3) / this.getPlaySpeed());
        boolean bl = l4 > 400L;
        long l5 = l4 - 200L;
        if (DEBUG) {
            int n = this.audioSink.getQueuedTime();
            System.err.println("s: pts-a " + audioFrame.audioPTS + ", qAT " + n + ", pts-d " + l + ", now_d " + l3 + ", dt " + l4 + ", sleep " + bl + ", sleepP " + l5 + " ms");
        }
        if (bl) {
            try {
                Thread.sleep(l5);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            this.lastAudioTime = System.currentTimeMillis();
        } else {
            this.lastAudioTime = l2;
        }
        if (this.audioSink.isDataAvailable(audioFrame.dataSize)) {
            this.audioSink.writeData(audioFrame);
            this.lastAudioPTS = audioFrame.audioPTS;
        }
    }

    private final void stopAudioPusher() {
    }

    private final void startAudioPusher() {
    }

    private void updateAttributes2(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        this.vPixelFmt = PixelFormat.valueOf(n);
        this.vPlanes = n2;
        this.vBitsPerPixel = n3;
        this.vBytesPerPixelPerPlane = n4;
        this.vLinesize[0] = n5;
        this.vLinesize[1] = n6;
        this.vLinesize[2] = n7;
        this.vTexWidth[0] = n8;
        this.vTexWidth[1] = n9;
        this.vTexWidth[2] = n10;
        switch (this.vPixelFmt) {
            case YUV420P: {
                this.texWidth = this.vTexWidth[0] + this.vTexWidth[1];
                this.texHeight = this.height;
                break;
            }
            case RGB24: 
            case BGR24: 
            case ARGB: 
            case RGBA: 
            case ABGR: 
            case BGRA: {
                this.texWidth = this.vTexWidth[0];
                this.texHeight = this.height;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported pixelformat: " + (Object)((Object)this.vPixelFmt));
            }
        }
        if (DEBUG) {
            System.err.println("XXX0: fmt " + (Object)((Object)this.vPixelFmt) + ", planes " + this.vPlanes + ", bpp " + this.vBitsPerPixel + "/" + this.vBytesPerPixelPerPlane);
            for (int i = 0; i < 3; ++i) {
                System.err.println("XXX0 " + i + ": " + this.vTexWidth[i] + "/" + this.vLinesize[i]);
            }
            System.err.println("XXX0 total tex " + this.texWidth + "x" + this.texHeight);
        }
    }

    @Override
    public String getTextureLookupFunctionName(String string) throws IllegalStateException {
        if (GLMediaPlayer.State.Uninitialized == this.state) {
            throw new IllegalStateException("Instance not initialized: " + this);
        }
        if (PixelFormat.YUV420P == this.vPixelFmt) {
            if (null != string && string.length() > 0) {
                this.textureLookupFunctionName = string;
            }
            return this.textureLookupFunctionName;
        }
        return super.getTextureLookupFunctionName(string);
    }

    @Override
    public String getTextureLookupFragmentShaderImpl() throws IllegalStateException {
        if (GLMediaPlayer.State.Uninitialized == this.state) {
            throw new IllegalStateException("Instance not initialized: " + this);
        }
        float f = (float)this.getWidth() / (float)this.texWidth;
        switch (this.vPixelFmt) {
            case YUV420P: {
                return "vec4 " + this.textureLookupFunctionName + "(in " + this.getTextureSampler2DType() + " image, in vec2 texCoord) {\n" + "  vec2 u_off = vec2(" + f + ", 0.0);\n" + "  vec2 v_off = vec2(" + f + ", 0.5);\n" + "  vec2 tc_half = texCoord*0.5;\n" + "  float y,u,v,r,g,b;\n" + "  y = texture2D(image, texCoord)." + this.singleTexComp + ";\n" + "  u = texture2D(image, u_off+tc_half)." + this.singleTexComp + ";\n" + "  v = texture2D(image, v_off+tc_half)." + this.singleTexComp + ";\n" + "  y = 1.1643*(y-0.0625);\n" + "  u = u-0.5;\n" + "  v = v-0.5;\n" + "  r = y+1.5958*v;\n" + "  g = y-0.39173*u-0.81290*v;\n" + "  b = y+2.017*u;\n" + "  return vec4(r, g, b, 1);\n" + "}\n";
            }
        }
        return super.getTextureLookupFragmentShaderImpl();
    }

    @Override
    protected synchronized int getCurrentPositionImpl() {
        return 0L != this.moviePtr ? this.getVideoPTS0(this.moviePtr) : 0;
    }

    @Override
    protected synchronized boolean setPlaySpeedImpl(float f) {
        return true;
    }

    @Override
    public synchronized boolean startImpl() {
        if (0L == this.moviePtr) {
            return false;
        }
        this.startAudioPusher();
        return true;
    }

    @Override
    public synchronized boolean pauseImpl() {
        if (0L == this.moviePtr) {
            return false;
        }
        this.stopAudioPusher();
        return true;
    }

    @Override
    public synchronized boolean stopImpl() {
        if (0L == this.moviePtr) {
            return false;
        }
        this.stopAudioPusher();
        return true;
    }

    @Override
    protected synchronized int seekImpl(int n) {
        if (0L == this.moviePtr) {
            throw new GLException("FFMPEG native instance null");
        }
        this.stopAudioPusher();
        int n2 = this.getVideoPTS0(this.moviePtr);
        int n3 = this.seek0(this.moviePtr, n);
        System.err.println("Seek: " + n2 + " -> " + n + " : " + n3);
        this.lastAudioPTS = n3;
        this.lastVideoPTS = n3;
        this.startAudioPusher();
        return n3;
    }

    @Override
    protected TextureSequence.TextureFrame getLastTextureImpl() {
        return this.lastTex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected TextureSequence.TextureFrame getNextTextureImpl(GL gL, boolean bl) {
        if (0L == this.moviePtr) {
            throw new GLException("FFMPEG native instance null");
        }
        if (null != this.lastTex) {
            this.psm.setUnpackAlignment(gL, 1);
            try {
                Texture texture = this.lastTex.getTexture();
                gL.glActiveTexture(33984 + this.getTextureUnit());
                texture.enable(gL);
                texture.bind(gL);
                int n = 0;
                for (int i = 10; n != 2 && i >= 0; --i) {
                    n = this.readNextPacket0(this.moviePtr, this.procAddrGLTexSubImage2D, this.textureTarget, this.textureFormat, this.textureType);
                }
            }
            finally {
                this.psm.restore(gL);
            }
            int n = this.getVideoPTS0(this.moviePtr);
            if (bl) {
                long l = n - this.lastAudioPTS - 444;
                long l2 = System.currentTimeMillis();
                long l3 = l2 - this.lastAudioTime;
                long l4 = Math.min(47L, (long)((float)(l - l3) / this.getPlaySpeed()));
                boolean bl2 = l4 > 9L && l4 < 1000L && this.audioSink.getQueuedByteCount() < this.maxAvailableAudio - 10000;
                long l5 = l4 - 9L;
                if (DEBUG) {
                    int n2 = this.audioSink.getQueuedTime();
                    System.err.println("s: pts-v " + n + ", qAT " + n2 + ", pts-d " + l + ", now_d " + l3 + ", dt " + l4 + ", sleep " + bl2 + ", sleepP " + l5 + " ms");
                }
                if (bl2) {
                    try {
                        Thread.sleep(l5);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.lastVideoTime = System.currentTimeMillis();
                } else {
                    this.lastVideoTime = l2;
                }
            }
            this.lastVideoPTS = n;
        }
        return this.lastTex;
    }

    private static native int getAvUtilVersion0();

    private static native int getAvFormatVersion0();

    private static native int getAvCodecVersion0();

    private static native boolean initIDs0();

    private native long createInstance0(boolean var1);

    private native void destroyInstance0(long var1);

    private native void setStream0(long var1, String var3, int var4, int var5, int var6);

    private native int getVideoPTS0(long var1);

    private native int getAudioPTS0(long var1);

    private native Buffer getAudioBuffer0(long var1, int var3);

    private native int readNextPacket0(long var1, long var3, int var5, int var6, int var7);

    private native int seek0(long var1, int var3);

    static {
        if (FFMPEGDynamicLibraryBundleInfo.initSingleton()) {
            avUtilVersion = FFMPEGMediaPlayer.getAVVersion(FFMPEGMediaPlayer.getAvUtilVersion0());
            avFormatVersion = FFMPEGMediaPlayer.getAVVersion(FFMPEGMediaPlayer.getAvFormatVersion0());
            avCodecVersion = FFMPEGMediaPlayer.getAVVersion(FFMPEGMediaPlayer.getAvCodecVersion0());
            System.err.println("LIB_AV Util  : " + avUtilVersion);
            System.err.println("LIB_AV Format: " + avFormatVersion);
            System.err.println("LIB_AV Codec : " + avCodecVersion);
            FFMPEGMediaPlayer.initIDs0();
            available = true;
        } else {
            avUtilVersion = null;
            avFormatVersion = null;
            avCodecVersion = null;
            available = false;
        }
        AudioPusherInstanceId = 0;
    }

    public static enum PixelFormat {
        YUV420P,
        YUYV422,
        RGB24,
        BGR24,
        YUV422P,
        YUV444P,
        YUV410P,
        YUV411P,
        GRAY8,
        MONOWHITE,
        MONOBLACK,
        PAL8,
        YUVJ420P,
        YUVJ422P,
        YUVJ444P,
        XVMC_MPEG2_MC,
        XVMC_MPEG2_IDCT,
        UYVY422,
        UYYVYY411,
        BGR8,
        BGR4,
        BGR4_BYTE,
        RGB8,
        RGB4,
        RGB4_BYTE,
        NV12,
        NV21,
        ARGB,
        RGBA,
        ABGR,
        BGRA,
        GRAY16BE,
        GRAY16LE,
        YUV440P,
        YUVJ440P,
        YUVA420P,
        VDPAU_H264,
        VDPAU_MPEG1,
        VDPAU_MPEG2,
        VDPAU_WMV3,
        VDPAU_VC1,
        RGB48BE,
        RGB48LE,
        RGB565BE,
        RGB565LE,
        RGB555BE,
        RGB555LE,
        BGR565BE,
        BGR565LE,
        BGR555BE,
        BGR555LE,
        VAAPI_MOCO,
        VAAPI_IDCT,
        VAAPI_VLD,
        YUV420P16LE,
        YUV420P16BE,
        YUV422P16LE,
        YUV422P16BE,
        YUV444P16LE,
        YUV444P16BE,
        VDPAU_MPEG4,
        DXVA2_VLD,
        RGB444LE,
        RGB444BE,
        BGR444LE,
        BGR444BE,
        Y400A,
        BGR48BE,
        BGR48LE,
        YUV420P9BE,
        YUV420P9LE,
        YUV420P10BE,
        YUV420P10LE,
        YUV422P10BE,
        YUV422P10LE,
        YUV444P9BE,
        YUV444P9LE,
        YUV444P10BE,
        YUV444P10LE,
        YUV422P9BE,
        YUV422P9LE,
        VDA_VLD,
        GBRP,
        GBRP9BE,
        GBRP9LE,
        GBRP10BE,
        GBRP10LE,
        GBRP16BE,
        GBRP16LE,
        COUNT;


        public static PixelFormat valueOf(int n) {
            for (PixelFormat pixelFormat : PixelFormat.values()) {
                if (pixelFormat.ordinal() != n) continue;
                return pixelFormat;
            }
            return null;
        }
    }

    class AudioPusher
    extends Thread {
        volatile boolean shallStop = false;
        volatile boolean isBlocked = false;

        AudioPusher() {
            this.setDaemon(true);
        }

        public void requestStop() {
            this.shallStop = true;
            if (this.isBlocked) {
                this.interrupt();
            }
        }

        public boolean isRunning() {
            return !this.shallStop;
        }

        @Override
        public void run() {
            this.setName(this.getName() + "-AudioPusher_" + AudioPusherInstanceId);
            ++AudioPusherInstanceId;
            while (!this.shallStop) {
                AudioSink.AudioFrame audioFrame;
                try {
                    this.isBlocked = true;
                    audioFrame = FFMPEGMediaPlayer.this.audioFramesBuffer.getBlocking(true);
                }
                catch (InterruptedException interruptedException) {
                    if (!this.shallStop) {
                        interruptedException.printStackTrace();
                    }
                    this.shallStop = true;
                    return;
                }
                this.isBlocked = false;
                if (null == audioFrame) continue;
                FFMPEGMediaPlayer.this.pushAudioFrame(audioFrame);
            }
        }
    }
}

