/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.maven;

import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import javax.xml.bind.JAXB;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.jooq.util.GenerationTool;
import org.jooq.util.jaxb.Configuration;
import org.jooq.util.jaxb.Generator;
import org.jooq.util.jaxb.Jdbc;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.TEST)
public class Plugin
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    private MavenProject project;
    @Parameter
    private Jdbc jdbc;
    @Parameter
    private Generator generator;

    public void execute() throws MojoExecutionException {
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClassLoader());
            String dir = this.generator.getTarget().getDirectory();
            if (!new File(dir).isAbsolute()) {
                this.generator.getTarget().setDirectory(this.project.getBasedir() + File.separator + dir);
            }
            Configuration configuration = new Configuration();
            configuration.setJdbc(this.jdbc);
            configuration.setGenerator(this.generator);
            StringWriter writer = new StringWriter();
            JAXB.marshal((Object)configuration, (Writer)writer);
            this.getLog().debug((CharSequence)("Using this configuration:\n" + writer.toString()));
            GenerationTool.generate((Configuration)configuration);
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Error running jOOQ code generation tool", ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
        }
        this.project.addCompileSourceRoot(this.generator.getTarget().getDirectory());
    }

    private ClassLoader getClassLoader() throws MojoExecutionException {
        try {
            List classpathElements = this.project.getRuntimeClasspathElements();
            URL[] urls = new URL[classpathElements.size()];
            for (int i = 0; i < urls.length; ++i) {
                urls[i] = new File((String)classpathElements.get(i)).toURI().toURL();
            }
            return new URLClassLoader(urls, ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Couldn't create a classloader.", e);
        }
    }
}

