/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.model;

import java.lang.reflect.AnnotatedElement;
import java.util.LinkedHashMap;
import java.util.Map;
import org.dmg.pmml.Apply;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.AnnotationInspector;
import org.jpmml.schema.Added;
import org.jpmml.schema.Removed;
import org.jpmml.schema.Version;

public class SchemaInspector
extends AnnotationInspector {
    private Version minimum = Version.PMML_3_0;
    private Version maximum = Version.PMML_4_2;
    private static Map<String, Version> functionVersions = new LinkedHashMap<String, Version>();

    @Override
    public VisitorAction visit(PMMLObject object) {
        VisitorAction result = super.visit(object);
        if (object instanceof Apply) {
            Apply apply = (Apply)object;
            this.inspect(apply.getFunction());
        }
        return result;
    }

    @Override
    public void inspect(AnnotatedElement element) {
        Removed removed;
        Added added = element.getAnnotation(Added.class);
        if (added != null) {
            this.updateMinimum(added.value());
        }
        if ((removed = element.getAnnotation(Removed.class)) != null) {
            this.updateMaximum(removed.value());
        }
    }

    private void inspect(String function) {
        Version version = functionVersions.get(function);
        if (version != null) {
            this.updateMinimum(version);
        }
    }

    public Version getMinimum() {
        return this.minimum;
    }

    private void updateMinimum(Version minimum) {
        if (minimum != null && minimum.compareTo((Enum)this.minimum) > 0) {
            this.minimum = minimum;
        }
    }

    public Version getMaximum() {
        return this.maximum;
    }

    private void updateMaximum(Version maximum) {
        if (maximum != null && maximum.compareTo((Enum)this.maximum) < 0) {
            this.maximum = maximum;
        }
    }

    private static void declareFunctions(Version version, String ... functions) {
        for (String function : functions) {
            functionVersions.put(function, version);
        }
    }

    static {
        SchemaInspector.declareFunctions(Version.PMML_3_0, "+", "-", "*", "/", "min", "max", "sum", "avg", "log10", "ln", "sqrt", "abs", "uppercase", "substring", "trimBlanks", "formatNumber", "formatDatetime", "dateDaysSinceYear", "dateSecondsSinceYear", "dateSecondsSinceMidnight");
        SchemaInspector.declareFunctions(Version.PMML_3_1, "exp", "pow", "threshold", "floor", "ceil", "round");
        SchemaInspector.declareFunctions(Version.PMML_4_0, "isMissing", "isNotMissing", "equal", "notEqual", "lessThan", "lessOrEqual", "greaterThan", "greaterOrEqual", "and", "or", "not", "isIn", "isNotIn", "if");
        SchemaInspector.declareFunctions(Version.PMML_4_1, "median", "product", "lowercase");
        SchemaInspector.declareFunctions(Version.PMML_4_2, "concat", "replace", "matches");
    }
}

