/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.False;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.SimpleSetPredicate;
import org.dmg.pmml.True;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions", "predicates"})
@XmlRootElement(name="CompoundPredicate", namespace="http://www.dmg.org/PMML-4_2")
public class CompoundPredicate
extends Predicate
implements HasExtensions {
    @XmlAttribute(name="booleanOperator", required=true)
    private BooleanOperator booleanOperator;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElements(value={@XmlElement(name="SimplePredicate", namespace="http://www.dmg.org/PMML-4_2", type=SimplePredicate.class), @XmlElement(name="CompoundPredicate", namespace="http://www.dmg.org/PMML-4_2", type=CompoundPredicate.class), @XmlElement(name="SimpleSetPredicate", namespace="http://www.dmg.org/PMML-4_2", type=SimpleSetPredicate.class), @XmlElement(name="True", namespace="http://www.dmg.org/PMML-4_2", type=True.class), @XmlElement(name="False", namespace="http://www.dmg.org/PMML-4_2", type=False.class)})
    private List<Predicate> predicates;

    public CompoundPredicate() {
    }

    public CompoundPredicate(BooleanOperator booleanOperator) {
        this.booleanOperator = booleanOperator;
    }

    public BooleanOperator getBooleanOperator() {
        return this.booleanOperator;
    }

    public CompoundPredicate setBooleanOperator(BooleanOperator booleanOperator) {
        this.booleanOperator = booleanOperator;
        return this;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public List<Predicate> getPredicates() {
        if (this.predicates == null) {
            this.predicates = new ArrayList<Predicate>();
        }
        return this.predicates;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    public CompoundPredicate addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasPredicates() {
        return this.predicates != null && this.predicates.size() > 0;
    }

    public CompoundPredicate addPredicates(Predicate ... predicates) {
        this.getPredicates().addAll(Arrays.asList(predicates));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE && this.hasPredicates()) {
                status = PMMLObject.traverse(visitor, this.getPredicates());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum BooleanOperator {
        OR("or"),
        AND("and"),
        XOR("xor"),
        SURROGATE("surrogate");

        private final String value;

        private BooleanOperator(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static BooleanOperator fromValue(String v) {
            for (BooleanOperator c : BooleanOperator.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }
}

