/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Aggregate;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Constant;
import org.dmg.pmml.Discretize;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Extension;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.HasExpression;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.NormContinuous;
import org.dmg.pmml.NormDiscrete;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.TextIndexNormalization;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions", "textIndexNormalizations", "expression"})
@XmlRootElement(name="TextIndex", namespace="http://www.dmg.org/PMML-4_2")
@Added(value=Version.PMML_4_2)
public class TextIndex
extends Expression
implements HasExpression,
HasExtensions {
    @XmlAttribute(name="textField", required=true)
    @XmlJavaTypeAdapter(value=FieldNameAdapter.class)
    private FieldName textField;
    @XmlAttribute(name="localTermWeights")
    private LocalTermWeights localTermWeights;
    @XmlAttribute(name="isCaseSensitive")
    private Boolean isCaseSensitive;
    @XmlAttribute(name="maxLevenshteinDistance")
    private Integer maxLevenshteinDistance;
    @XmlAttribute(name="countHits")
    private CountHits countHits;
    @XmlAttribute(name="wordSeparatorCharacterRE")
    private String wordSeparatorCharacterRE;
    @XmlAttribute(name="tokenize")
    private Boolean tokenize;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElement(name="TextIndexNormalization", namespace="http://www.dmg.org/PMML-4_2")
    private List<TextIndexNormalization> textIndexNormalizations;
    @XmlElements(value={@XmlElement(name="Constant", namespace="http://www.dmg.org/PMML-4_2", type=Constant.class), @XmlElement(name="FieldRef", namespace="http://www.dmg.org/PMML-4_2", type=FieldRef.class), @XmlElement(name="NormContinuous", namespace="http://www.dmg.org/PMML-4_2", type=NormContinuous.class), @XmlElement(name="NormDiscrete", namespace="http://www.dmg.org/PMML-4_2", type=NormDiscrete.class), @XmlElement(name="Discretize", namespace="http://www.dmg.org/PMML-4_2", type=Discretize.class), @XmlElement(name="MapValues", namespace="http://www.dmg.org/PMML-4_2", type=MapValues.class), @XmlElement(name="TextIndex", namespace="http://www.dmg.org/PMML-4_2", type=TextIndex.class), @XmlElement(name="Apply", namespace="http://www.dmg.org/PMML-4_2", type=Apply.class), @XmlElement(name="Aggregate", namespace="http://www.dmg.org/PMML-4_2", type=Aggregate.class)})
    private Expression expression;
    private static final Boolean DEFAULT_IS_CASE_SENSITIVE = false;
    private static final Integer DEFAULT_MAX_LEVENSHTEIN_DISTANCE = 0;
    private static final Boolean DEFAULT_TOKENIZE = true;

    public TextIndex() {
    }

    public TextIndex(FieldName textField) {
        this.textField = textField;
    }

    public FieldName getTextField() {
        return this.textField;
    }

    public TextIndex setTextField(FieldName textField) {
        this.textField = textField;
        return this;
    }

    public LocalTermWeights getLocalTermWeights() {
        if (this.localTermWeights == null) {
            return LocalTermWeights.TERM_FREQUENCY;
        }
        return this.localTermWeights;
    }

    public TextIndex setLocalTermWeights(LocalTermWeights localTermWeights) {
        this.localTermWeights = localTermWeights;
        return this;
    }

    public boolean isIsCaseSensitive() {
        if (this.isCaseSensitive == null) {
            return DEFAULT_IS_CASE_SENSITIVE;
        }
        return this.isCaseSensitive;
    }

    public TextIndex setIsCaseSensitive(Boolean isCaseSensitive) {
        this.isCaseSensitive = isCaseSensitive;
        return this;
    }

    public Integer getMaxLevenshteinDistance() {
        if (this.maxLevenshteinDistance == null) {
            return DEFAULT_MAX_LEVENSHTEIN_DISTANCE;
        }
        return this.maxLevenshteinDistance;
    }

    public TextIndex setMaxLevenshteinDistance(Integer maxLevenshteinDistance) {
        this.maxLevenshteinDistance = maxLevenshteinDistance;
        return this;
    }

    public CountHits getCountHits() {
        if (this.countHits == null) {
            return CountHits.ALL_HITS;
        }
        return this.countHits;
    }

    public TextIndex setCountHits(CountHits countHits) {
        this.countHits = countHits;
        return this;
    }

    public String getWordSeparatorCharacterRE() {
        if (this.wordSeparatorCharacterRE == null) {
            return "\\s";
        }
        return this.wordSeparatorCharacterRE;
    }

    public TextIndex setWordSeparatorCharacterRE(String wordSeparatorCharacterRE) {
        this.wordSeparatorCharacterRE = wordSeparatorCharacterRE;
        return this;
    }

    public boolean isTokenize() {
        if (this.tokenize == null) {
            return DEFAULT_TOKENIZE;
        }
        return this.tokenize;
    }

    public TextIndex setTokenize(Boolean tokenize) {
        this.tokenize = tokenize;
        return this;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public List<TextIndexNormalization> getTextIndexNormalizations() {
        if (this.textIndexNormalizations == null) {
            this.textIndexNormalizations = new ArrayList<TextIndexNormalization>();
        }
        return this.textIndexNormalizations;
    }

    @Override
    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public TextIndex setExpression(Expression expression) {
        this.expression = expression;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    public TextIndex addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasTextIndexNormalizations() {
        return this.textIndexNormalizations != null && this.textIndexNormalizations.size() > 0;
    }

    public TextIndex addTextIndexNormalizations(TextIndexNormalization ... textIndexNormalizations) {
        this.getTextIndexNormalizations().addAll(Arrays.asList(textIndexNormalizations));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE && this.hasTextIndexNormalizations()) {
                status = PMMLObject.traverse(visitor, this.getTextIndexNormalizations());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, (Visitable)this.getExpression());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum LocalTermWeights {
        TERM_FREQUENCY("termFrequency"),
        BINARY("binary"),
        LOGARITHMIC("logarithmic"),
        AUGMENTED_NORMALIZED_TERM_FREQUENCY("augmentedNormalizedTermFrequency");

        private final String value;

        private LocalTermWeights(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static LocalTermWeights fromValue(String v) {
            for (LocalTermWeights c : LocalTermWeights.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }

    @XmlType(name="")
    @XmlEnum
    public static enum CountHits {
        ALL_HITS("allHits"),
        BEST_HITS("bestHits");

        private final String value;

        private CountHits(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static CountHits fromValue(String v) {
            for (CountHits c : CountHits.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }
}

