/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.model;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public abstract class SkipFilter
extends XMLFilterImpl {
    private int depth = 0;

    public SkipFilter() {
    }

    public SkipFilter(XMLReader reader) {
        super(reader);
    }

    public abstract boolean isSkipped(String var1, String var2);

    public Attributes filterAttributes(String namespaceURI, String localName, Attributes attributes) {
        return attributes;
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.isSkipping()) {
            throw new SAXException();
        }
        super.startDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.isSkipping()) {
            throw new SAXException();
        }
        super.endDocument();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) throws SAXException {
        if (this.isSkipped(namespaceURI, localName)) {
            ++this.depth;
            return;
        }
        if (this.isSkipping()) {
            return;
        }
        Attributes filteredAttributes = this.filterAttributes(namespaceURI, localName, attributes);
        super.startElement(namespaceURI, localName, qualifiedName, filteredAttributes);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qualifiedName) throws SAXException {
        if (this.isSkipped(namespaceURI, localName)) {
            --this.depth;
            return;
        }
        if (this.isSkipping()) {
            return;
        }
        super.endElement(namespaceURI, localName, qualifiedName);
    }

    @Override
    public void characters(char[] buffer, int index, int length) throws SAXException {
        if (this.isSkipping()) {
            return;
        }
        super.characters(buffer, index, length);
    }

    private boolean isSkipping() {
        return this.depth > 0;
    }
}

