/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.model;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import org.dmg.pmml.PMMLObject;

public class ReflectionUtil {
    private static final Predicate<Field> FIELD_SELECTOR = new Predicate<Field>(){

        @Override
        public boolean test(Field field) {
            if (this.hasValidName(field)) {
                int modifiers = field.getModifiers();
                return !Modifier.isStatic(modifiers);
            }
            return false;
        }

        private boolean hasValidName(Field field) {
            String name = field.getName();
            if (name.length() > 0) {
                return Character.isLetterOrDigit(name.charAt(0));
            }
            return false;
        }
    };
    private static final ConcurrentMap<Class<?>, List<Field>> classFields = new ConcurrentHashMap();
    private static final ConcurrentMap<Class<?>, Map<Field, Method>> classGetterMethods = new ConcurrentHashMap();
    private static final Set<Class<?>> primitiveWrapperClasses = new HashSet<Class>(Arrays.asList(Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Boolean.class, Character.class));

    private ReflectionUtil() {
    }

    public static boolean equals(Object left, Object right) {
        if (left instanceof PMMLObject && right instanceof PMMLObject) {
            return ReflectionUtil.equals((PMMLObject)left, (PMMLObject)right);
        }
        return Objects.equals(left, right);
    }

    public static boolean equals(PMMLObject left, PMMLObject right) {
        if (!Objects.equals(left.getClass(), right.getClass())) {
            throw new IllegalArgumentException();
        }
        Map<Field, Method> getterMethods = ReflectionUtil.getGetterMethods(left.getClass());
        Set<Map.Entry<Field, Method>> entries = getterMethods.entrySet();
        for (Map.Entry entry : entries) {
            boolean equals;
            Object rightValue;
            Object leftValue;
            Field field = (Field)entry.getKey();
            Method getterMethod = (Method)entry.getValue();
            if (List.class.equals(field.getType())) {
                leftValue = ReflectionUtil.getFieldValue(field, left);
                rightValue = ReflectionUtil.getFieldValue(field, right);
            } else {
                leftValue = ReflectionUtil.getGetterMethodValue(getterMethod, left);
                rightValue = ReflectionUtil.getGetterMethodValue(getterMethod, right);
            }
            leftValue = ReflectionUtil.standardizeValue(leftValue);
            rightValue = ReflectionUtil.standardizeValue(rightValue);
            if (leftValue instanceof List && rightValue instanceof List) {
                List leftValues = (List)leftValue;
                List rightValues = (List)rightValue;
                if (leftValues.size() == rightValues.size()) {
                    equals = true;
                    int max = leftValues.size();
                    for (int i = 0; i < max && (equals &= ReflectionUtil.equals(leftValues.get(i), rightValues.get(i))); ++i) {
                    }
                } else {
                    equals = false;
                }
            } else {
                equals = ReflectionUtil.equals(leftValue, rightValue);
            }
            if (equals) continue;
            return false;
        }
        return true;
    }

    public static <E extends PMMLObject> void copyState(E from, E to) {
        Class<?> toClazz;
        Class<?> fromClazz = from.getClass();
        if (!fromClazz.isAssignableFrom(toClazz = to.getClass())) {
            throw new IllegalArgumentException();
        }
        List<Field> fields = ReflectionUtil.getFields(fromClazz);
        for (Field field : fields) {
            E value = ReflectionUtil.getFieldValue(field, from);
            ReflectionUtil.setFieldValue(field, to, value);
        }
    }

    public static Field getField(Class<?> clazz, String name) {
        while (clazz != null) {
            try {
                Field field = clazz.getDeclaredField(name);
                if (!FIELD_SELECTOR.test(field)) {
                    throw new IllegalArgumentException(name);
                }
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                clazz = clazz.getSuperclass();
            }
        }
        throw new RuntimeException(new NoSuchFieldException(name));
    }

    public static List<Field> getFields(Class<?> clazz) {
        List<Field> result = (List<Field>)classFields.get(clazz);
        if (result == null) {
            result = ReflectionUtil.loadFields(clazz);
            classFields.putIfAbsent(clazz, result);
        }
        return result;
    }

    public static Method getGetterMethod(Field field) {
        String prefix = Boolean.class.equals(field.getType()) ? "is" : "get";
        String name = field.getName();
        if (name.length() > 0) {
            name = prefix + name.substring(0, 1).toUpperCase() + name.substring(1);
        }
        Class<?> clazz = field.getDeclaringClass();
        try {
            return clazz.getDeclaredMethod(name, null);
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException(nsme);
        }
    }

    public static Map<Field, Method> getGetterMethods(Class<?> clazz) {
        Map<Field, Method> result = (Map<Field, Method>)classGetterMethods.get(clazz);
        if (result == null) {
            result = ReflectionUtil.loadGetterMethods(clazz);
            classGetterMethods.putIfAbsent(clazz, result);
        }
        return result;
    }

    public static <E> E getFieldValue(Field field, Object object) {
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        try {
            return (E)field.get(object);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
    }

    public static void setFieldValue(Field field, Object object, Object value) {
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        try {
            field.set(object, value);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
    }

    public static <E> E getGetterMethodValue(Method method, Object object) {
        try {
            return (E)method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isPrimitiveWrapper(Class<?> clazz) {
        return primitiveWrapperClasses.contains(clazz);
    }

    public static boolean isDefaultValue(Object value) {
        if (value instanceof Boolean) {
            return Boolean.FALSE.equals(value);
        }
        if (value instanceof Character) {
            Character character = (Character)value;
            return character.charValue() == '\u0000';
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return Double.compare(number.doubleValue(), 0.0) == 0;
        }
        return false;
    }

    private static Object standardizeValue(Object value) {
        List list;
        if (value instanceof List && (list = (List)value).isEmpty()) {
            return null;
        }
        return value;
    }

    private static List<Field> loadFields(Class<?> clazz) {
        ArrayList<Field> result = new ArrayList<Field>();
        while (clazz != null) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                if (!FIELD_SELECTOR.test(field)) continue;
                result.add(field);
            }
            clazz = clazz.getSuperclass();
        }
        return Collections.unmodifiableList(result);
    }

    private static Map<Field, Method> loadGetterMethods(Class<?> clazz) {
        LinkedHashMap<Field, Method> result = new LinkedHashMap<Field, Method>();
        List<Field> fields = ReflectionUtil.getFields(clazz);
        for (Field field : fields) {
            Method getterMethod = ReflectionUtil.getGetterMethod(field);
            result.put(field, getterMethod);
        }
        return Collections.unmodifiableMap(result);
    }
}

