/*
 * Decompiled with CFR 0.152.
 */
package jay.yydebug;

import java.io.PrintStream;
import jay.yydebug.yyDebug;

public class yyDebugAdapter
implements yyDebug {
    protected final PrintStream out;

    public yyDebugAdapter(PrintStream out) {
        this.out = out;
    }

    public yyDebugAdapter() {
        this(System.out);
    }

    public void push(int state, Object value) {
        this.out.println("push\tstate " + state + "\tvalue " + value);
    }

    public void lex(int state, int token, String name, Object value) {
        this.out.println("lex\tstate " + state + "\treading " + name + "\tvalue " + value);
    }

    public void shift(int from, int to, int errorFlag) {
        switch (errorFlag) {
            default: {
                this.out.println("shift\tfrom state " + from + " to " + to);
                break;
            }
            case 0: 
            case 1: 
            case 2: {
                this.out.println("shift\tfrom state " + from + " to " + to + "\t" + errorFlag + " left to recover");
                break;
            }
            case 3: {
                this.out.println("shift\tfrom state " + from + " to " + to + "\ton error");
            }
        }
    }

    public void pop(int state) {
        this.out.println("pop\tstate " + state + "\ton error");
    }

    public void discard(int state, int token, String name, Object value) {
        this.out.println("discard\tstate " + state + "\ttoken " + name + "\tvalue " + value);
    }

    public void reduce(int from, int to, int rule, String text, int len) {
        this.out.println("reduce\tstate " + from + "\tuncover " + to + "\trule (" + rule + ") " + text);
    }

    public void shift(int from, int to) {
        this.out.println("goto\tfrom state " + from + " to " + to);
    }

    public void accept(Object value) {
        this.out.println("accept\tvalue " + value);
    }

    public void error(String message) {
        this.out.println("error\t" + message);
    }

    public void reject() {
        this.out.println("reject");
    }
}

