/*
 * Decompiled with CFR 0.152.
 */
package jay.yydebug;

import java.awt.TextArea;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class yyInputStream
extends InputStream
implements KeyListener {
    protected final StringBuffer line = new StringBuffer();
    protected ArrayList queue = new ArrayList();

    public synchronized int available() throws IOException {
        if (this.queue == null) {
            throw new IOException("closed");
        }
        return this.queue.isEmpty() ? 0 : ((byte[])this.queue.get(0)).length;
    }

    public synchronized void close() throws IOException {
        if (this.queue == null) {
            throw new IOException("closed");
        }
        this.queue = null;
    }

    public synchronized int read() throws IOException {
        if (this.queue == null) {
            throw new IOException("closed");
        }
        while (this.queue.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                throw new IOException("interrupted");
            }
        }
        byte[] buf = (byte[])this.queue.get(0);
        switch (buf.length) {
            case 0: {
                return -1;
            }
            case 1: {
                this.queue.remove(0);
                break;
            }
            default: {
                byte[] nbuf = new byte[buf.length - 1];
                System.arraycopy(buf, 1, nbuf, 0, nbuf.length);
                this.queue.set(0, nbuf);
                this.notifyAll();
            }
        }
        return buf[0] & 0xFF;
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (this.queue == null) {
            throw new IOException("closed");
        }
        while (this.queue.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                throw new IOException("interrupted");
            }
        }
        byte[] buf = (byte[])this.queue.get(0);
        if (buf.length == 0) {
            return -1;
        }
        if (buf.length <= len) {
            System.arraycopy(buf, 0, b, off, buf.length);
            this.queue.remove(0);
            return buf.length;
        }
        System.arraycopy(buf, 0, b, off, len);
        byte[] nbuf = new byte[buf.length - len];
        System.arraycopy(buf, len, nbuf, 0, nbuf.length);
        this.queue.set(0, nbuf);
        this.notifyAll();
        return len;
    }

    public long skip(long len) {
        return 0L;
    }

    public void keyPressed(KeyEvent ke) {
        TextArea ta = (TextArea)ke.getComponent();
        int pos = ta.getText().length();
        ta.select(pos, pos);
        ta.setCaretPosition(pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyTyped(KeyEvent ke) {
        TextArea ta = (TextArea)ke.getComponent();
        char ch = ke.getKeyChar();
        switch (ch) {
            case '\n': 
            case '\r': {
                this.line.append('\n');
                break;
            }
            case '\u0004': {
                ta.append("^D");
                ta.setCaretPosition(ta.getText().length());
                break;
            }
            case '\b': {
                int len = this.line.length();
                if (len > 0) {
                    this.line.setLength(len - 1);
                }
                return;
            }
            case '\u0015': {
                this.line.setLength(0);
                ta.append("^U\n");
                ta.setCaretPosition(ta.getText().length());
                return;
            }
            default: {
                this.line.append(ch);
                return;
            }
        }
        yyInputStream yyInputStream2 = this;
        synchronized (yyInputStream2) {
            this.queue.add(this.line.toString().getBytes());
            this.notifyAll();
        }
        this.line.setLength(0);
    }

    public void keyReleased(KeyEvent ke) {
    }
}

