/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2_commons.plugin.elementwrapper;

import com.sun.tools.xjc.model.Model;
import com.sun.tools.xjc.model.nav.NClass;
import com.sun.tools.xjc.model.nav.NType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.jvnet.jaxb2_commons.plugin.CustomizedIgnoring;
import org.jvnet.jaxb2_commons.plugin.Ignoring;
import org.jvnet.jaxb2_commons.plugin.elementwrapper.Customizations;
import org.jvnet.jaxb2_commons.plugin.model.AbstractModelPlugin;
import org.jvnet.jaxb2_commons.xjc.model.concrete.origin.DummyPropertyInfoOrigin;
import org.jvnet.jaxb2_commons.xml.bind.model.MClassInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MElementPropertyInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MElementRefPropertyInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MElementRefsPropertyInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MElementsPropertyInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MModelInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MPropertyInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MPropertyInfoVisitor;
import org.jvnet.jaxb2_commons.xml.bind.model.MTypeInfoVisitor;
import org.jvnet.jaxb2_commons.xml.bind.model.concrete.CMElementPropertyInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.concrete.CMElementRefPropertyInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.concrete.CMElementRefsPropertyInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.concrete.CMElementsPropertyInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.origin.MPropertyInfoOrigin;
import org.jvnet.jaxb2_commons.xml.bind.model.util.DefaultPropertyInfoVisitor;
import org.jvnet.jaxb2_commons.xml.bind.model.util.DefaultTypeInfoVisitor;
import org.xml.sax.ErrorHandler;

public class ElementWrapperPlugin
extends AbstractModelPlugin {
    private Ignoring ignoring = new CustomizedIgnoring(Customizations.IGNORED_ELEMENT_NAME);

    public String getOptionName() {
        return "XelementWrapper";
    }

    public String getUsage() {
        return "Generates @XmlElementWrapper annotations.";
    }

    @Override
    protected void postProcessModel(Model model, final MModelInfo<NType, NClass> mmodel, ErrorHandler errorHandler) {
        ArrayList classInfos = new ArrayList(mmodel.getClassInfos());
        for (final MClassInfo rootClassInfo : classInfos) {
            ArrayList properties = new ArrayList(rootClassInfo.getProperties());
            for (MPropertyInfo propertyInfo0 : properties) {
                propertyInfo0.acceptPropertyInfoVisitor((MPropertyInfoVisitor)new DefaultPropertyInfoVisitor<NType, NClass, Void>(){

                    public Void visitElementPropertyInfo(MElementPropertyInfo<NType, NClass> wrapperPropertyInfo) {
                        ElementWrapperPlugin.this.processWrapperElementPropertyInfo((MModelInfo<NType, NClass>)mmodel, (MClassInfo<NType, NClass>)rootClassInfo, wrapperPropertyInfo);
                        return null;
                    }
                });
            }
        }
    }

    public Ignoring getIgnoring() {
        return this.ignoring;
    }

    public void setIgnoring(Ignoring ignoring) {
        this.ignoring = ignoring;
    }

    public Collection<QName> getCustomizationElementNames() {
        return Arrays.asList(Customizations.IGNORED_ELEMENT_NAME);
    }

    protected void processWrapperElementPropertyInfo(final MModelInfo<NType, NClass> mmodel, final MClassInfo<NType, NClass> rootClassInfo, final MElementPropertyInfo<NType, NClass> wrapperPropertyInfo) {
        wrapperPropertyInfo.getTypeInfo().acceptTypeInfoVisitor((MTypeInfoVisitor)new DefaultTypeInfoVisitor<NType, NClass, Void>(){

            public Void visitClassInfo(MClassInfo<NType, NClass> wrapperClassInfo) {
                MPropertyInfo wrappedPropertyInfo;
                if (wrapperClassInfo.getProperties().size() == 1 && (wrappedPropertyInfo = (MPropertyInfo)wrapperClassInfo.getProperties().get(0)).isCollection()) {
                    ElementWrapperPlugin.this.processWrappedPropertyInfo((MModelInfo<NType, NClass>)mmodel, (MClassInfo<NType, NClass>)rootClassInfo, (MElementPropertyInfo<NType, NClass>)wrapperPropertyInfo, wrapperClassInfo, (MPropertyInfo<NType, NClass>)wrappedPropertyInfo);
                }
                return null;
            }
        });
    }

    protected void processWrappedPropertyInfo(final MModelInfo<NType, NClass> mmodel, final MClassInfo<NType, NClass> rootClassInfo, final MElementPropertyInfo<NType, NClass> wrapperPropertyInfo, final MClassInfo<NType, NClass> wrapperClassInfo, MPropertyInfo<NType, NClass> wrappedPropertyInfo) {
        wrappedPropertyInfo.acceptPropertyInfoVisitor((MPropertyInfoVisitor)new DefaultPropertyInfoVisitor<NType, NClass, Void>(){

            public Void visitElementPropertyInfo(MElementPropertyInfo<NType, NClass> wrappedPropertyInfo) {
                ElementWrapperPlugin.this.processWrappedElementPropertyInfo((MModelInfo<NType, NClass>)mmodel, (MClassInfo<NType, NClass>)rootClassInfo, (MElementPropertyInfo<NType, NClass>)wrapperPropertyInfo, (MClassInfo<NType, NClass>)wrapperClassInfo, wrappedPropertyInfo);
                return null;
            }

            public Void visitElementsPropertyInfo(MElementsPropertyInfo<NType, NClass> wrappedPropertyInfo) {
                ElementWrapperPlugin.this.processWrappedElementsPropertyInfo((MModelInfo<NType, NClass>)mmodel, (MClassInfo<NType, NClass>)rootClassInfo, (MElementPropertyInfo<NType, NClass>)wrapperPropertyInfo, (MClassInfo<NType, NClass>)wrapperClassInfo, wrappedPropertyInfo);
                return null;
            }

            public Void visitElementRefPropertyInfo(MElementRefPropertyInfo<NType, NClass> wrappedPropertyInfo) {
                ElementWrapperPlugin.this.processWrappedElementRefPropertyInfo((MModelInfo<NType, NClass>)mmodel, (MClassInfo<NType, NClass>)rootClassInfo, (MElementPropertyInfo<NType, NClass>)wrapperPropertyInfo, (MClassInfo<NType, NClass>)wrapperClassInfo, wrappedPropertyInfo);
                return null;
            }

            public Void visitElementRefsPropertyInfo(MElementRefsPropertyInfo<NType, NClass> wrappedPropertyInfo) {
                ElementWrapperPlugin.this.processWrappedElementRefsPropertyInfo((MModelInfo<NType, NClass>)mmodel, (MClassInfo<NType, NClass>)rootClassInfo, (MElementPropertyInfo<NType, NClass>)wrapperPropertyInfo, (MClassInfo<NType, NClass>)wrapperClassInfo, wrappedPropertyInfo);
                return null;
            }
        });
    }

    protected void processWrappedElementPropertyInfo(MModelInfo<NType, NClass> mmodel, MClassInfo<NType, NClass> rootClassInfo, MElementPropertyInfo<NType, NClass> wrapperPropertyInfo, MClassInfo<NType, NClass> wrapperClassInfo, MElementPropertyInfo<NType, NClass> wrappedPropertyInfo) {
        System.out.println("Class info:" + rootClassInfo.getName());
        System.out.println("Wrapper property info:" + wrapperPropertyInfo.getPrivateName());
        System.out.println("Wrapper class info :" + wrapperClassInfo.getName());
        System.out.println("Wrapped property info:" + wrappedPropertyInfo.getPrivateName());
        CMElementPropertyInfo propertyInfo = new CMElementPropertyInfo((MPropertyInfoOrigin)new DummyPropertyInfoOrigin(), wrapperClassInfo, wrapperPropertyInfo.getPrivateName(), wrappedPropertyInfo.isCollection(), wrappedPropertyInfo.isRequired(), wrappedPropertyInfo.getTypeInfo(), wrappedPropertyInfo.getElementName(), wrapperPropertyInfo.getWrapperElementName(), wrappedPropertyInfo.isNillable(), wrappedPropertyInfo.getDefaultValue(), wrappedPropertyInfo.getDefaultValueNamespaceContext());
        rootClassInfo.addProperty((MPropertyInfo)propertyInfo);
        rootClassInfo.removeProperty(wrapperPropertyInfo);
        mmodel.removeClassInfo(wrapperClassInfo);
    }

    protected void processWrappedElementsPropertyInfo(MModelInfo<NType, NClass> mmodel, MClassInfo<NType, NClass> rootClassInfo, MElementPropertyInfo<NType, NClass> wrapperPropertyInfo, MClassInfo<NType, NClass> wrapperClassInfo, MElementsPropertyInfo<NType, NClass> wrappedPropertyInfo) {
        System.out.println("Class info:" + rootClassInfo.getName());
        System.out.println("Wrapper property info:" + wrapperPropertyInfo.getPrivateName());
        System.out.println("Wrapper class info :" + wrapperClassInfo.getName());
        System.out.println("Wrapped property info:" + wrappedPropertyInfo.getPrivateName());
        CMElementsPropertyInfo propertyInfo = new CMElementsPropertyInfo((MPropertyInfoOrigin)new DummyPropertyInfoOrigin(), wrapperClassInfo, wrapperPropertyInfo.getPrivateName(), wrappedPropertyInfo.isCollection(), wrappedPropertyInfo.isRequired(), (Collection)wrappedPropertyInfo.getElementTypeInfos(), wrapperPropertyInfo.getElementName());
        rootClassInfo.addProperty((MPropertyInfo)propertyInfo);
        rootClassInfo.removeProperty(wrapperPropertyInfo);
        mmodel.removeClassInfo(wrapperClassInfo);
    }

    protected void processWrappedElementRefPropertyInfo(MModelInfo<NType, NClass> mmodel, MClassInfo<NType, NClass> rootClassInfo, MElementPropertyInfo<NType, NClass> wrapperPropertyInfo, MClassInfo<NType, NClass> wrapperClassInfo, MElementRefPropertyInfo<NType, NClass> wrappedPropertyInfo) {
        System.out.println("Class info:" + rootClassInfo.getName());
        System.out.println("Wrapper property info:" + wrapperPropertyInfo.getPrivateName());
        System.out.println("Wrapper class info :" + wrapperClassInfo.getName());
        System.out.println("Wrapped property info:" + wrappedPropertyInfo.getPrivateName());
        CMElementRefPropertyInfo propertyInfo = new CMElementRefPropertyInfo((MPropertyInfoOrigin)new DummyPropertyInfoOrigin(), wrapperClassInfo, wrapperPropertyInfo.getPrivateName(), wrappedPropertyInfo.isCollection(), wrappedPropertyInfo.isRequired(), wrappedPropertyInfo.getTypeInfo(), wrappedPropertyInfo.getElementName(), wrapperPropertyInfo.getElementName(), wrappedPropertyInfo.isMixed(), wrappedPropertyInfo.isDomAllowed(), wrappedPropertyInfo.isTypedObjectAllowed(), wrappedPropertyInfo.getDefaultValue(), wrappedPropertyInfo.getDefaultValueNamespaceContext());
        rootClassInfo.addProperty((MPropertyInfo)propertyInfo);
        rootClassInfo.removeProperty(wrapperPropertyInfo);
        mmodel.removeClassInfo(wrapperClassInfo);
    }

    protected void processWrappedElementRefsPropertyInfo(MModelInfo<NType, NClass> mmodel, MClassInfo<NType, NClass> rootClassInfo, MElementPropertyInfo<NType, NClass> wrapperPropertyInfo, MClassInfo<NType, NClass> wrapperClassInfo, MElementRefsPropertyInfo<NType, NClass> wrappedPropertyInfo) {
        System.out.println("Class info:" + rootClassInfo.getName());
        System.out.println("Wrapper property info:" + wrapperPropertyInfo.getPrivateName());
        System.out.println("Wrapper class info :" + wrapperClassInfo.getName());
        System.out.println("Wrapped property info:" + wrappedPropertyInfo.getPrivateName());
        CMElementRefsPropertyInfo propertyInfo = new CMElementRefsPropertyInfo((MPropertyInfoOrigin)new DummyPropertyInfoOrigin(), wrapperClassInfo, wrapperPropertyInfo.getPrivateName(), wrappedPropertyInfo.isCollection(), wrappedPropertyInfo.isRequired(), (Collection)wrappedPropertyInfo.getElementTypeInfos(), wrapperPropertyInfo.getElementName(), wrappedPropertyInfo.isMixed(), wrappedPropertyInfo.isDomAllowed(), wrappedPropertyInfo.isTypedObjectAllowed());
        rootClassInfo.addProperty((MPropertyInfo)propertyInfo);
        rootClassInfo.removeProperty(wrapperPropertyInfo);
        mmodel.removeClassInfo(wrapperClassInfo);
    }
}

