/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.command;

import org.jxls.area.Area;
import org.jxls.command.AbstractCommand;
import org.jxls.command.Command;
import org.jxls.common.AreaRef;
import org.jxls.common.CellRef;
import org.jxls.common.Context;
import org.jxls.common.ImageType;
import org.jxls.common.Size;
import org.jxls.transform.Transformer;

public class ImageCommand
extends AbstractCommand {
    byte[] imageBytes;
    ImageType imageType = ImageType.PNG;
    Area area;
    String src;

    public ImageCommand() {
    }

    public ImageCommand(String image, ImageType imageType) {
        this.src = image;
        this.imageType = imageType;
    }

    public ImageCommand(byte[] imageBytes, ImageType imageType) {
        this.imageBytes = imageBytes;
        this.imageType = imageType;
    }

    public String getSrc() {
        return this.src;
    }

    public void setSrc(String src) {
        this.src = src;
    }

    public void setImageType(String strType) {
        this.imageType = ImageType.valueOf(strType);
    }

    @Override
    public Command addArea(Area area) {
        if (this.areaList.size() >= 1) {
            throw new IllegalArgumentException("You can add only a single area to 'image' command");
        }
        this.area = area;
        return super.addArea(area);
    }

    @Override
    public String getName() {
        return "image";
    }

    @Override
    public Size applyAt(CellRef cellRef, Context context) {
        if (this.area == null) {
            throw new IllegalArgumentException("No area is defined for image command");
        }
        Transformer transformer = this.getTransformer();
        AreaRef areaRef = new AreaRef(cellRef, this.area.getSize());
        byte[] imgBytes = this.imageBytes;
        if (this.src != null) {
            Object imgObj = this.getTransformationConfig().getExpressionEvaluator().evaluate(this.src, context.toMap());
            if (!(imgObj instanceof byte[])) {
                throw new IllegalArgumentException("src value must contain image bytes (byte[])");
            }
            imgBytes = (byte[])imgObj;
        }
        transformer.addImage(areaRef, imgBytes, this.imageType);
        return this.area.getSize();
    }
}

