/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.formula;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jxls.common.CellData;
import org.jxls.common.CellRef;
import org.jxls.formula.FormulaProcessor;
import org.jxls.transform.Transformer;
import org.jxls.util.Util;

public class FastFormulaProcessor
implements FormulaProcessor {
    @Override
    public void processAreaFormulas(Transformer transformer) {
        Set<CellData> formulaCells = transformer.getFormulaCells();
        for (CellData formulaCellData : formulaCells) {
            List<String> formulaCellRefs = Util.getFormulaCellRefs(formulaCellData.getFormula());
            List<String> jointedCellRefs = Util.getJointedCellRefs(formulaCellData.getFormula());
            List<CellRef> targetFormulaCells = formulaCellData.getTargetPos();
            HashMap<CellRef, List<CellRef>> targetCellRefMap = new HashMap<CellRef, List<CellRef>>();
            HashMap jointedCellRefMap = new HashMap();
            for (String cellRef : formulaCellRefs) {
                CellRef pos = new CellRef(cellRef);
                if (!pos.isValid()) continue;
                if (pos.getSheetName() == null) {
                    pos.setSheetName(formulaCellData.getSheetName());
                    pos.setIgnoreSheetNameInFormat(true);
                }
                List<CellRef> targetCellDataList = transformer.getTargetCellRef(pos);
                targetCellRefMap.put(pos, targetCellDataList);
            }
            for (String jointedCellRef : jointedCellRefs) {
                List<String> nestedCellRefs = Util.getCellRefsFromJointedCellRef(jointedCellRef);
                ArrayList<CellRef> jointedCellRefList = new ArrayList<CellRef>();
                for (String string : nestedCellRefs) {
                    CellRef cellRef = new CellRef(string);
                    if (cellRef.getSheetName() == null) {
                        cellRef.setSheetName(formulaCellData.getSheetName());
                        cellRef.setIgnoreSheetNameInFormat(true);
                    }
                    List<CellRef> targetCellDataList = transformer.getTargetCellRef(cellRef);
                    jointedCellRefList.addAll(targetCellDataList);
                }
                jointedCellRefMap.put(jointedCellRef, jointedCellRefList);
            }
            ArrayList<CellRef> usedCellRefs = new ArrayList<CellRef>();
            for (int i = 0; i < targetFormulaCells.size(); ++i) {
                List<CellRef> range;
                CellRef targetFormulaCellRef = targetFormulaCells.get(i);
                String targetFormulaString = formulaCellData.getFormula();
                boolean isFormulaCellRefsEmpty = true;
                for (Map.Entry<CellRef, List<CellRef>> entry : targetCellRefMap.entrySet()) {
                    String replacementString;
                    List targetCells = (List)entry.getValue();
                    if (targetCells.isEmpty()) continue;
                    isFormulaCellRefsEmpty = false;
                    if (formulaCellData.getFormulaStrategy() == CellData.FormulaStrategy.BY_COLUMN) {
                        List<CellRef> targetCellRefs = Util.createTargetCellRefListByColumn(targetFormulaCellRef, targetCells, usedCellRefs);
                        usedCellRefs.addAll(targetCellRefs);
                        replacementString = Util.createTargetCellRef(targetCellRefs);
                    } else if (targetCells.size() == targetFormulaCells.size()) {
                        CellRef targetCellRefCellRef = (CellRef)targetCells.get(i);
                        replacementString = targetCellRefCellRef.getCellName();
                    } else {
                        List<List<CellRef>> rangeList = Util.groupByRanges(targetCells, targetFormulaCells.size());
                        if (rangeList.size() == targetFormulaCells.size()) {
                            range = rangeList.get(i);
                            replacementString = Util.createTargetCellRef(range);
                        } else {
                            replacementString = Util.createTargetCellRef(targetCells);
                        }
                    }
                    targetFormulaString = targetFormulaString.replaceAll("(?<!U_\\([^)]{0,100})" + Util.sheetNameRegex(entry) + Pattern.quote(entry.getKey().getCellName()), Matcher.quoteReplacement(replacementString));
                }
                for (Map.Entry entry : jointedCellRefMap.entrySet()) {
                    String replacementString;
                    List targetCellRefList = (List)entry.getValue();
                    if (targetCellRefList.isEmpty()) continue;
                    isFormulaCellRefsEmpty = false;
                    List<List<CellRef>> rangeList = Util.groupByRanges(targetCellRefList, targetFormulaCells.size());
                    if (rangeList.size() == targetFormulaCells.size()) {
                        range = rangeList.get(i);
                        replacementString = Util.createTargetCellRef(range);
                    } else {
                        replacementString = Util.createTargetCellRef(targetCellRefList);
                    }
                    targetFormulaString = targetFormulaString.replaceAll(Pattern.quote((String)entry.getKey()), replacementString);
                }
                String string = targetFormulaCellRef.getFormattedSheetName() + '!';
                targetFormulaString = targetFormulaString.replaceAll(string, "");
                if (isFormulaCellRefsEmpty) {
                    targetFormulaString = formulaCellData.getDefaultValue() != null ? formulaCellData.getDefaultValue() : "0";
                }
                transformer.setFormula(new CellRef(targetFormulaCellRef.getSheetName(), targetFormulaCellRef.getRow(), targetFormulaCellRef.getCol()), targetFormulaString);
            }
        }
    }
}

