/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa;

import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.OAuthClientModel;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredCredentialModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.SocialLinkModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.jpa.ApplicationAdapter;
import org.keycloak.models.jpa.OAuthClientAdapter;
import org.keycloak.models.jpa.RoleAdapter;
import org.keycloak.models.jpa.UserAdapter;
import org.keycloak.models.jpa.entities.ApplicationEntity;
import org.keycloak.models.jpa.entities.CredentialEntity;
import org.keycloak.models.jpa.entities.OAuthClientEntity;
import org.keycloak.models.jpa.entities.RealmEntity;
import org.keycloak.models.jpa.entities.RealmRoleEntity;
import org.keycloak.models.jpa.entities.RequiredCredentialEntity;
import org.keycloak.models.jpa.entities.RoleEntity;
import org.keycloak.models.jpa.entities.SocialLinkEntity;
import org.keycloak.models.jpa.entities.UserEntity;
import org.keycloak.models.jpa.entities.UserRoleMappingEntity;
import org.keycloak.models.jpa.entities.UserScopeMappingEntity;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.Pbkdf2PasswordEncoder;
import org.keycloak.models.utils.TimeBasedOTP;

public class RealmAdapter
implements RealmModel {
    protected RealmEntity realm;
    protected EntityManager em;
    protected volatile transient PublicKey publicKey;
    protected volatile transient PrivateKey privateKey;
    private PasswordPolicy passwordPolicy;

    public RealmAdapter(EntityManager em, RealmEntity realm) {
        this.em = em;
        this.realm = realm;
    }

    public String getId() {
        return this.realm.getId();
    }

    public String getName() {
        return this.realm.getName();
    }

    public void setName(String name) {
        this.realm.setName(name);
        this.em.flush();
    }

    public boolean isEnabled() {
        return this.realm.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.realm.setEnabled(enabled);
        this.em.flush();
    }

    public boolean isSslNotRequired() {
        return this.realm.isSslNotRequired();
    }

    public void setSslNotRequired(boolean sslNotRequired) {
        this.realm.setSslNotRequired(sslNotRequired);
        this.em.flush();
    }

    public boolean isRegistrationAllowed() {
        return this.realm.isRegistrationAllowed();
    }

    public void setRegistrationAllowed(boolean registrationAllowed) {
        this.realm.setRegistrationAllowed(registrationAllowed);
        this.em.flush();
    }

    public boolean isVerifyEmail() {
        return this.realm.isVerifyEmail();
    }

    public void setVerifyEmail(boolean verifyEmail) {
        this.realm.setVerifyEmail(verifyEmail);
        this.em.flush();
    }

    public boolean isResetPasswordAllowed() {
        return this.realm.isResetPasswordAllowed();
    }

    public void setResetPasswordAllowed(boolean resetPasswordAllowed) {
        this.realm.setResetPasswordAllowed(resetPasswordAllowed);
        this.em.flush();
    }

    public int getTokenLifespan() {
        return this.realm.getTokenLifespan();
    }

    public void setTokenLifespan(int tokenLifespan) {
        this.realm.setTokenLifespan(tokenLifespan);
        this.em.flush();
    }

    public int getAccessCodeLifespan() {
        return this.realm.getAccessCodeLifespan();
    }

    public void setAccessCodeLifespan(int accessCodeLifespan) {
        this.realm.setAccessCodeLifespan(accessCodeLifespan);
        this.em.flush();
    }

    public int getAccessCodeLifespanUserAction() {
        return this.realm.getAccessCodeLifespanUserAction();
    }

    public void setAccessCodeLifespanUserAction(int accessCodeLifespanUserAction) {
        this.realm.setAccessCodeLifespanUserAction(accessCodeLifespanUserAction);
        this.em.flush();
    }

    public String getPublicKeyPem() {
        return this.realm.getPublicKeyPem();
    }

    public void setPublicKeyPem(String publicKeyPem) {
        this.realm.setPublicKeyPem(publicKeyPem);
        this.em.flush();
    }

    public String getPrivateKeyPem() {
        return this.realm.getPrivateKeyPem();
    }

    public void setPrivateKeyPem(String privateKeyPem) {
        this.realm.setPrivateKeyPem(privateKeyPem);
        this.em.flush();
    }

    public PublicKey getPublicKey() {
        if (this.publicKey != null) {
            return this.publicKey;
        }
        this.publicKey = KeycloakModelUtils.getPublicKey((String)this.getPublicKeyPem());
        return this.publicKey;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
        String publicKeyPem = KeycloakModelUtils.getPemFromKey((Key)publicKey);
        this.setPublicKeyPem(publicKeyPem);
    }

    public PrivateKey getPrivateKey() {
        if (this.privateKey != null) {
            return this.privateKey;
        }
        this.privateKey = KeycloakModelUtils.getPrivateKey((String)this.getPrivateKeyPem());
        return this.privateKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
        String privateKeyPem = KeycloakModelUtils.getPemFromKey((Key)privateKey);
        this.setPrivateKeyPem(privateKeyPem);
    }

    protected RequiredCredentialModel initRequiredCredentialModel(String type) {
        RequiredCredentialModel model = (RequiredCredentialModel)RequiredCredentialModel.BUILT_IN.get(type);
        if (model == null) {
            throw new RuntimeException("Unknown credential type " + type);
        }
        return model;
    }

    public void addRequiredCredential(String type) {
        RequiredCredentialModel model = this.initRequiredCredentialModel(type);
        this.addRequiredCredential(model);
        this.em.flush();
    }

    public void addRequiredCredential(RequiredCredentialModel model) {
        RequiredCredentialEntity entity = new RequiredCredentialEntity();
        entity.setInput(model.isInput());
        entity.setSecret(model.isSecret());
        entity.setType(model.getType());
        entity.setFormLabel(model.getFormLabel());
        this.em.persist((Object)entity);
        this.realm.getRequiredCredentials().add(entity);
        this.em.flush();
    }

    public void updateRequiredCredentials(Set<String> creds) {
        Collection<RequiredCredentialEntity> relationships = this.realm.getRequiredCredentials();
        if (relationships == null) {
            relationships = new ArrayList<RequiredCredentialEntity>();
        }
        HashSet<String> already = new HashSet<String>();
        ArrayList<RequiredCredentialEntity> remove = new ArrayList<RequiredCredentialEntity>();
        for (RequiredCredentialEntity rel : relationships) {
            if (!creds.contains(rel.getType())) {
                remove.add(rel);
                continue;
            }
            already.add(rel.getType());
        }
        for (RequiredCredentialEntity entity : remove) {
            relationships.remove(entity);
            this.em.remove((Object)entity);
        }
        for (String cred : creds) {
            if (already.contains(cred)) continue;
            this.addRequiredCredential(cred);
        }
        this.em.flush();
    }

    public List<RequiredCredentialModel> getRequiredCredentials() {
        ArrayList<RequiredCredentialModel> requiredCredentialModels = new ArrayList<RequiredCredentialModel>();
        Collection<RequiredCredentialEntity> entities = this.realm.getRequiredCredentials();
        if (entities == null) {
            return requiredCredentialModels;
        }
        for (RequiredCredentialEntity entity : entities) {
            RequiredCredentialModel model = new RequiredCredentialModel();
            model.setFormLabel(entity.getFormLabel());
            model.setType(entity.getType());
            model.setSecret(entity.isSecret());
            model.setInput(entity.isInput());
            requiredCredentialModels.add(model);
        }
        return requiredCredentialModels;
    }

    public List<RequiredCredentialModel> getRequiredApplicationCredentials() {
        ArrayList<RequiredCredentialModel> requiredCredentialModels = new ArrayList<RequiredCredentialModel>();
        Collection<RequiredCredentialEntity> entities = this.realm.getRequiredAppCredentials();
        if (entities == null) {
            return requiredCredentialModels;
        }
        for (RequiredCredentialEntity entity : entities) {
            RequiredCredentialModel model = new RequiredCredentialModel();
            model.setFormLabel(entity.getFormLabel());
            model.setType(entity.getType());
            model.setSecret(entity.isSecret());
            model.setInput(entity.isInput());
            requiredCredentialModels.add(model);
        }
        return requiredCredentialModels;
    }

    public List<RequiredCredentialModel> getRequiredOAuthClientCredentials() {
        ArrayList<RequiredCredentialModel> requiredCredentialModels = new ArrayList<RequiredCredentialModel>();
        Collection<RequiredCredentialEntity> entities = this.realm.getRequiredOAuthClCredentials();
        if (entities == null) {
            return requiredCredentialModels;
        }
        for (RequiredCredentialEntity entity : entities) {
            RequiredCredentialModel model = new RequiredCredentialModel();
            model.setFormLabel(entity.getFormLabel());
            model.setType(entity.getType());
            model.setSecret(entity.isSecret());
            model.setInput(entity.isInput());
            requiredCredentialModels.add(model);
        }
        return requiredCredentialModels;
    }

    public void addRequiredOAuthClientCredential(RequiredCredentialModel model) {
        RequiredCredentialEntity entity = new RequiredCredentialEntity();
        entity.setInput(model.isInput());
        entity.setSecret(model.isSecret());
        entity.setType(model.getType());
        entity.setFormLabel(model.getFormLabel());
        this.em.persist((Object)entity);
        this.realm.getRequiredOAuthClCredentials().add(entity);
        this.em.flush();
    }

    public void addRequiredOAuthClientCredential(String type) {
        RequiredCredentialModel model = this.initRequiredCredentialModel(type);
        this.addRequiredOAuthClientCredential(model);
        this.em.flush();
    }

    public void addRequiredResourceCredential(RequiredCredentialModel model) {
        RequiredCredentialEntity entity = new RequiredCredentialEntity();
        entity.setInput(model.isInput());
        entity.setSecret(model.isSecret());
        entity.setType(model.getType());
        entity.setFormLabel(model.getFormLabel());
        this.em.persist((Object)entity);
        this.realm.getRequiredAppCredentials().add(entity);
        this.em.flush();
    }

    public void addRequiredResourceCredential(String type) {
        RequiredCredentialModel model = this.initRequiredCredentialModel(type);
        this.addRequiredResourceCredential(model);
        this.em.flush();
    }

    public void updateRequiredOAuthClientCredentials(Set<String> creds) {
        Collection<RequiredCredentialEntity> relationships = this.realm.getRequiredOAuthClCredentials();
        if (relationships == null) {
            relationships = new ArrayList<RequiredCredentialEntity>();
        }
        HashSet<String> already = new HashSet<String>();
        ArrayList<RequiredCredentialEntity> remove = new ArrayList<RequiredCredentialEntity>();
        for (RequiredCredentialEntity rel : relationships) {
            if (!creds.contains(rel.getType())) {
                remove.add(rel);
                continue;
            }
            already.add(rel.getType());
        }
        for (RequiredCredentialEntity entity : remove) {
            relationships.remove(entity);
            this.em.remove((Object)entity);
        }
        for (String cred : creds) {
            if (already.contains(cred)) continue;
            this.addRequiredOAuthClientCredential(cred);
        }
        this.em.flush();
    }

    public void updateRequiredApplicationCredentials(Set<String> creds) {
        Collection<RequiredCredentialEntity> relationships = this.realm.getRequiredAppCredentials();
        if (relationships == null) {
            relationships = new ArrayList<RequiredCredentialEntity>();
        }
        HashSet<String> already = new HashSet<String>();
        ArrayList<RequiredCredentialEntity> remove = new ArrayList<RequiredCredentialEntity>();
        for (RequiredCredentialEntity rel : relationships) {
            if (!creds.contains(rel.getType())) {
                remove.add(rel);
                continue;
            }
            already.add(rel.getType());
        }
        for (RequiredCredentialEntity entity : remove) {
            relationships.remove(entity);
            this.em.remove((Object)entity);
        }
        for (String cred : creds) {
            if (already.contains(cred)) continue;
            this.addRequiredResourceCredential(cred);
        }
        this.em.flush();
    }

    public UserModel getUser(String name) {
        TypedQuery query = this.em.createNamedQuery("getRealmUserByLoginName", UserEntity.class);
        query.setParameter("loginName", (Object)name);
        query.setParameter("realm", (Object)this.realm);
        List results = query.getResultList();
        if (results.size() == 0) {
            return null;
        }
        return new UserAdapter((UserEntity)results.get(0));
    }

    public UserModel getUserByEmail(String email) {
        TypedQuery query = this.em.createNamedQuery("getRealmUserByEmail", UserEntity.class);
        query.setParameter("email", (Object)email);
        query.setParameter("realm", (Object)this.realm);
        List results = query.getResultList();
        return results.isEmpty() ? null : new UserAdapter((UserEntity)results.get(0));
    }

    public UserModel addUser(String username) {
        UserEntity entity = new UserEntity();
        entity.setLoginName(username);
        entity.setRealm(this.realm);
        this.em.persist((Object)entity);
        this.em.flush();
        UserAdapter userModel = new UserAdapter(entity);
        for (String r : this.getDefaultRoles()) {
            this.grantRole(userModel, this.getRole(r));
        }
        for (ApplicationModel application : this.getApplications()) {
            for (String r : application.getDefaultRoles()) {
                this.grantRole(userModel, application.getRole(r));
            }
        }
        return userModel;
    }

    public boolean removeUser(String name) {
        TypedQuery query = this.em.createNamedQuery("getRealmUserByLoginName", UserEntity.class);
        query.setParameter("loginName", (Object)name);
        query.setParameter("realm", (Object)this.realm);
        List results = query.getResultList();
        if (results.size() == 0) {
            return false;
        }
        this.removeUser((UserEntity)results.get(0));
        return true;
    }

    private void removeUser(UserEntity user) {
        this.em.createQuery("delete from " + UserScopeMappingEntity.class.getSimpleName() + " where user = :user").setParameter("user", (Object)user).executeUpdate();
        this.em.createQuery("delete from " + UserRoleMappingEntity.class.getSimpleName() + " where user = :user").setParameter("user", (Object)user).executeUpdate();
        this.em.createQuery("delete from " + SocialLinkEntity.class.getSimpleName() + " where user = :user").setParameter("user", (Object)user).executeUpdate();
        this.em.remove((Object)user);
    }

    public List<String> getDefaultRoles() {
        Collection<RoleEntity> entities = this.realm.getDefaultRoles();
        ArrayList<String> roles = new ArrayList<String>();
        if (entities == null) {
            return roles;
        }
        for (RoleEntity entity : entities) {
            roles.add(entity.getName());
        }
        return roles;
    }

    public void addDefaultRole(String name) {
        RoleModel role = this.getRole(name);
        if (role == null) {
            role = this.addRole(name);
        }
        Collection<RoleEntity> entities = this.realm.getDefaultRoles();
        for (RoleEntity entity : entities) {
            if (!entity.getId().equals(role.getId())) continue;
            return;
        }
        entities.add(((RoleAdapter)role).getRole());
        this.em.flush();
    }

    public static boolean contains(String str, String[] array) {
        for (String s : array) {
            if (!str.equals(s)) continue;
            return true;
        }
        return false;
    }

    public void updateDefaultRoles(String[] defaultRoles) {
        Collection<RoleEntity> entities = this.realm.getDefaultRoles();
        HashSet<String> already = new HashSet<String>();
        ArrayList<RoleEntity> remove = new ArrayList<RoleEntity>();
        for (RoleEntity rel : entities) {
            if (!RealmAdapter.contains(rel.getName(), defaultRoles)) {
                remove.add(rel);
                continue;
            }
            already.add(rel.getName());
        }
        for (RoleEntity entity : remove) {
            entities.remove(entity);
        }
        this.em.flush();
        for (String roleName : defaultRoles) {
            if (already.contains(roleName)) continue;
            this.addDefaultRole(roleName);
        }
        this.em.flush();
    }

    public Map<String, ApplicationModel> getApplicationNameMap() {
        HashMap<String, ApplicationModel> map = new HashMap<String, ApplicationModel>();
        for (ApplicationModel app : this.getApplications()) {
            map.put(app.getName(), app);
        }
        return map;
    }

    public List<ApplicationModel> getApplications() {
        ArrayList<ApplicationModel> list = new ArrayList<ApplicationModel>();
        if (this.realm.getApplications() == null) {
            return list;
        }
        for (ApplicationEntity entity : this.realm.getApplications()) {
            list.add(new ApplicationAdapter(this, this.em, entity));
        }
        return list;
    }

    public ApplicationModel addApplication(String name) {
        ApplicationEntity applicationData = new ApplicationEntity();
        UserEntity user = new UserEntity();
        user.setLoginName(name);
        user.setRealm(this.realm);
        user.setEnabled(true);
        this.em.persist((Object)user);
        applicationData.setApplicationUser(user);
        applicationData.setName(name);
        applicationData.setEnabled(true);
        this.realm.getApplications().add(applicationData);
        this.em.persist((Object)applicationData);
        this.em.flush();
        ApplicationAdapter resource = new ApplicationAdapter(this, this.em, applicationData);
        this.em.flush();
        return resource;
    }

    public boolean removeApplication(String id) {
        if (id == null) {
            return false;
        }
        ApplicationModel application = this.getApplicationById(id);
        if (application == null) {
            return false;
        }
        for (RoleModel role : application.getRoles()) {
            application.removeRoleById(role.getId());
        }
        ApplicationEntity applicationEntity = null;
        Iterator<ApplicationEntity> it = this.realm.getApplications().iterator();
        while (it.hasNext()) {
            ApplicationEntity ae = it.next();
            if (!ae.getId().equals(id)) continue;
            applicationEntity = ae;
            it.remove();
            break;
        }
        for (ApplicationEntity a : this.realm.getApplications()) {
            if (!a.getId().equals(id)) continue;
            applicationEntity = a;
        }
        if (application == null) {
            return false;
        }
        this.em.remove((Object)applicationEntity);
        this.removeUser(applicationEntity.getApplicationUser());
        return true;
    }

    public ApplicationModel getApplicationById(String id) {
        ApplicationEntity app = (ApplicationEntity)this.em.find(ApplicationEntity.class, (Object)id);
        if (app == null) {
            return null;
        }
        return new ApplicationAdapter(this, this.em, app);
    }

    public ApplicationModel getApplicationByName(String name) {
        return this.getApplicationNameMap().get(name);
    }

    public UserModel getUserBySocialLink(SocialLinkModel socialLink) {
        TypedQuery query = this.em.createNamedQuery("findUserByLinkAndRealm", UserEntity.class);
        query.setParameter("realm", (Object)this.realm);
        query.setParameter("socialProvider", (Object)socialLink.getSocialProvider());
        query.setParameter("socialUsername", (Object)socialLink.getSocialUsername());
        List results = query.getResultList();
        if (results.isEmpty()) {
            return null;
        }
        if (results.size() > 1) {
            throw new IllegalStateException("More results found for socialProvider=" + socialLink.getSocialProvider() + ", socialUsername=" + socialLink.getSocialUsername() + ", results=" + results);
        }
        UserEntity user = (UserEntity)results.get(0);
        return new UserAdapter(user);
    }

    public Set<SocialLinkModel> getSocialLinks(UserModel user) {
        TypedQuery query = this.em.createNamedQuery("findSocialLinkByUser", SocialLinkEntity.class);
        query.setParameter("user", (Object)((UserAdapter)user).getUser());
        List results = query.getResultList();
        HashSet<SocialLinkModel> set = new HashSet<SocialLinkModel>();
        for (SocialLinkEntity entity : results) {
            set.add(new SocialLinkModel(entity.getSocialProvider(), entity.getSocialUsername()));
        }
        return set;
    }

    public void addSocialLink(UserModel user, SocialLinkModel socialLink) {
        SocialLinkEntity entity = new SocialLinkEntity();
        entity.setRealm(this.realm);
        entity.setSocialProvider(socialLink.getSocialProvider());
        entity.setSocialUsername(socialLink.getSocialUsername());
        entity.setUser(((UserAdapter)user).getUser());
        this.em.persist((Object)entity);
        this.em.flush();
    }

    public void removeSocialLink(UserModel user, SocialLinkModel socialLink) {
        TypedQuery query = this.em.createNamedQuery("findSocialLinkByAll", SocialLinkEntity.class);
        query.setParameter("realm", (Object)this.realm);
        query.setParameter("user", (Object)((UserAdapter)user).getUser());
        query.setParameter("socialProvider", (Object)socialLink.getSocialProvider());
        query.setParameter("socialUsername", (Object)socialLink.getSocialUsername());
        List results = query.getResultList();
        for (SocialLinkEntity entity : results) {
            this.em.remove((Object)entity);
        }
        this.em.flush();
    }

    public boolean isSocial() {
        return this.realm.isSocial();
    }

    public void setSocial(boolean social) {
        this.realm.setSocial(social);
        this.em.flush();
    }

    public boolean isUpdateProfileOnInitialSocialLogin() {
        return this.realm.isUpdateProfileOnInitialSocialLogin();
    }

    public void setUpdateProfileOnInitialSocialLogin(boolean updateProfileOnInitialSocialLogin) {
        this.realm.setUpdateProfileOnInitialSocialLogin(updateProfileOnInitialSocialLogin);
        this.em.flush();
    }

    public List<UserModel> getUsers() {
        TypedQuery query = this.em.createQuery("select u from UserEntity u where u.realm = :realm", UserEntity.class);
        query.setParameter("realm", (Object)this.realm);
        List results = query.getResultList();
        ArrayList<UserModel> users = new ArrayList<UserModel>();
        for (UserEntity entity : results) {
            users.add(new UserAdapter(entity));
        }
        return users;
    }

    public List<UserModel> searchForUser(String search) {
        TypedQuery query = this.em.createQuery("select u from UserEntity u where u.realm = :realm and ( lower(u.loginName) like :search or lower(concat(u.firstName, ' ', u.lastName)) like :search or u.email like :search )", UserEntity.class);
        query.setParameter("realm", (Object)this.realm);
        query.setParameter("search", (Object)("%" + search.toLowerCase() + "%"));
        List results = query.getResultList();
        ArrayList<UserModel> users = new ArrayList<UserModel>();
        for (UserEntity entity : results) {
            users.add(new UserAdapter(entity));
        }
        return users;
    }

    public List<UserModel> searchForUserByAttributes(Map<String, String> attributes) {
        StringBuilder builder = new StringBuilder("select u from UserEntity u");
        boolean first = true;
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            String attribute = null;
            if (entry.getKey().equals("username")) {
                attribute = "lower(loginName)";
            } else if (entry.getKey().equalsIgnoreCase("firstName")) {
                attribute = "lower(firstName)";
            } else if (entry.getKey().equalsIgnoreCase("lastName")) {
                attribute = "lower(lastName)";
            } else if (entry.getKey().equalsIgnoreCase("email")) {
                attribute = "lower(email)";
            }
            if (attribute == null) continue;
            if (first) {
                first = false;
                builder.append(" where ");
            } else {
                builder.append(" and ");
            }
            builder.append(attribute).append(" like '%").append(entry.getValue().toLowerCase()).append("%'");
        }
        String q = builder.toString();
        TypedQuery query = this.em.createQuery(q, UserEntity.class);
        List results = query.getResultList();
        ArrayList<UserModel> users = new ArrayList<UserModel>();
        for (UserEntity entity : results) {
            users.add(new UserAdapter(entity));
        }
        return users;
    }

    public OAuthClientModel addOAuthClient(String name) {
        OAuthClientEntity data = new OAuthClientEntity();
        UserEntity user = new UserEntity();
        user.setLoginName(name);
        user.setRealm(this.realm);
        user.setEnabled(true);
        this.em.persist((Object)user);
        data.setAgent(user);
        data.setName(name);
        data.setRealm(this.realm);
        this.em.persist((Object)data);
        this.em.flush();
        return new OAuthClientAdapter(data);
    }

    public boolean removeOAuthClient(String id) {
        OAuthClientEntity client = (OAuthClientEntity)this.em.find(OAuthClientEntity.class, (Object)id);
        this.em.createQuery("delete from " + UserScopeMappingEntity.class.getSimpleName() + " where user = :user").setParameter("user", (Object)client.getAgent()).executeUpdate();
        this.em.createQuery("delete from " + UserRoleMappingEntity.class.getSimpleName() + " where user = :user").setParameter("user", (Object)client.getAgent()).executeUpdate();
        this.removeUser(client.getAgent());
        this.em.remove((Object)client);
        return true;
    }

    public OAuthClientModel getOAuthClient(String name) {
        TypedQuery query = this.em.createNamedQuery("findOAuthClientByUser", OAuthClientEntity.class);
        query.setParameter("name", (Object)name);
        query.setParameter("realm", (Object)this.realm);
        List entities = query.getResultList();
        if (entities.size() == 0) {
            return null;
        }
        return new OAuthClientAdapter((OAuthClientEntity)entities.get(0));
    }

    public OAuthClientModel getOAuthClientById(String id) {
        OAuthClientEntity client = (OAuthClientEntity)this.em.find(OAuthClientEntity.class, (Object)id);
        if (client == null) {
            return null;
        }
        return new OAuthClientAdapter(client);
    }

    public List<OAuthClientModel> getOAuthClients() {
        TypedQuery query = this.em.createNamedQuery("findOAuthClientByRealm", OAuthClientEntity.class);
        query.setParameter("realm", (Object)this.realm);
        List entities = query.getResultList();
        ArrayList<OAuthClientModel> list = new ArrayList<OAuthClientModel>();
        for (OAuthClientEntity entity : entities) {
            list.add(new OAuthClientAdapter(entity));
        }
        return list;
    }

    public Map<String, String> getSmtpConfig() {
        return this.realm.getSmtpConfig();
    }

    public void setSmtpConfig(Map<String, String> smtpConfig) {
        this.realm.setSmtpConfig(smtpConfig);
        this.em.flush();
    }

    public Map<String, String> getSocialConfig() {
        return this.realm.getSocialConfig();
    }

    public void setSocialConfig(Map<String, String> socialConfig) {
        this.realm.setSocialConfig(socialConfig);
        this.em.flush();
    }

    public RoleModel getRole(String name) {
        TypedQuery query = this.em.createNamedQuery("getRealmRoleByName", RealmRoleEntity.class);
        query.setParameter("name", (Object)name);
        query.setParameter("realm", (Object)this.realm);
        List roles = query.getResultList();
        if (roles.size() == 0) {
            return null;
        }
        return new RoleAdapter(this, this.em, (RoleEntity)roles.get(0));
    }

    public RoleModel addRole(String name) {
        RoleModel role = this.getRole(name);
        if (role != null) {
            return role;
        }
        RealmRoleEntity entity = new RealmRoleEntity();
        entity.setName(name);
        entity.setRealm(this.realm);
        this.realm.getRoles().add(entity);
        this.em.persist((Object)entity);
        this.em.flush();
        return new RoleAdapter(this, this.em, entity);
    }

    public boolean removeRoleById(String id) {
        RoleModel role = this.getRoleById(id);
        if (role == null) {
            return false;
        }
        if (role == null) {
            return false;
        }
        RoleEntity roleEntity = ((RoleAdapter)role).getRole();
        this.realm.getRoles().remove(role);
        this.realm.getDefaultRoles().remove(role);
        this.em.createQuery("delete from " + UserRoleMappingEntity.class.getSimpleName() + " where role = :role").setParameter("role", (Object)roleEntity).executeUpdate();
        this.em.createQuery("delete from " + UserScopeMappingEntity.class.getSimpleName() + " where role = :role").setParameter("role", (Object)roleEntity).executeUpdate();
        this.em.remove((Object)roleEntity);
        return true;
    }

    public Set<RoleModel> getRoles() {
        HashSet<RoleModel> list = new HashSet<RoleModel>();
        Collection<RealmRoleEntity> roles = this.realm.getRoles();
        if (roles == null) {
            return list;
        }
        for (RoleEntity roleEntity : roles) {
            list.add(new RoleAdapter(this, this.em, roleEntity));
        }
        return list;
    }

    public RoleModel getRoleById(String id) {
        RoleEntity entity = (RoleEntity)this.em.find(RoleEntity.class, (Object)id);
        if (entity == null) {
            return null;
        }
        return new RoleAdapter(this, this.em, entity);
    }

    public boolean hasRole(UserModel user, RoleModel role) {
        Set<RoleModel> roles = this.getRoleMappings(user);
        if (roles.contains(role)) {
            return true;
        }
        for (RoleModel mapping : roles) {
            if (!mapping.hasRole(role)) continue;
            return true;
        }
        return false;
    }

    protected TypedQuery<UserRoleMappingEntity> getUserRoleMappingEntityTypedQuery(UserAdapter user, RoleAdapter role) {
        TypedQuery query = this.em.createNamedQuery("userHasRole", UserRoleMappingEntity.class);
        query.setParameter("user", (Object)user.getUser());
        query.setParameter("role", (Object)role.getRole());
        return query;
    }

    public void grantRole(UserModel user, RoleModel role) {
        if (this.hasRole(user, role)) {
            return;
        }
        UserRoleMappingEntity entity = new UserRoleMappingEntity();
        entity.setUser(((UserAdapter)user).getUser());
        entity.setRole(((RoleAdapter)role).getRole());
        this.em.persist((Object)entity);
        this.em.flush();
    }

    public Set<RoleModel> getRealmRoleMappings(UserModel user) {
        Set<RoleModel> roleMappings = this.getRoleMappings(user);
        HashSet<RoleModel> realmRoles = new HashSet<RoleModel>();
        for (RoleModel role : roleMappings) {
            RoleContainerModel container = role.getContainer();
            if (!(container instanceof RealmModel)) continue;
            realmRoles.add(role);
        }
        return realmRoles;
    }

    public Set<RoleModel> getRoleMappings(UserModel user) {
        TypedQuery query = this.em.createNamedQuery("userRoleMappings", UserRoleMappingEntity.class);
        query.setParameter("user", (Object)((UserAdapter)user).getUser());
        List entities = query.getResultList();
        HashSet<RoleModel> roles = new HashSet<RoleModel>();
        for (UserRoleMappingEntity entity : entities) {
            roles.add(new RoleAdapter(this, this.em, entity.getRole()));
        }
        return roles;
    }

    public void deleteRoleMapping(UserModel user, RoleModel role) {
        TypedQuery<UserRoleMappingEntity> query = this.getUserRoleMappingEntityTypedQuery((UserAdapter)user, (RoleAdapter)role);
        List results = query.getResultList();
        if (results.size() == 0) {
            return;
        }
        for (UserRoleMappingEntity entity : results) {
            this.em.remove((Object)entity);
        }
        this.em.flush();
    }

    public Set<RoleModel> getRealmScopeMappings(UserModel user) {
        Set<RoleModel> roleMappings = this.getScopeMappings(user);
        HashSet<RoleModel> appRoles = new HashSet<RoleModel>();
        for (RoleModel role : roleMappings) {
            RoleContainerModel container = role.getContainer();
            if (!(container instanceof RealmModel) || !((RealmModel)container).getId().equals(this.getId())) continue;
            appRoles.add(role);
        }
        return appRoles;
    }

    public Set<RoleModel> getScopeMappings(UserModel agent) {
        TypedQuery query = this.em.createNamedQuery("userScopeMappings", UserScopeMappingEntity.class);
        query.setParameter("user", (Object)((UserAdapter)agent).getUser());
        List entities = query.getResultList();
        HashSet<RoleModel> roles = new HashSet<RoleModel>();
        for (UserScopeMappingEntity entity : entities) {
            roles.add(new RoleAdapter(this, this.em, entity.getRole()));
        }
        return roles;
    }

    public void addScopeMapping(UserModel agent, RoleModel role) {
        if (this.hasScope(agent, role)) {
            return;
        }
        UserScopeMappingEntity entity = new UserScopeMappingEntity();
        entity.setUser(((UserAdapter)agent).getUser());
        entity.setRole(((RoleAdapter)role).getRole());
        this.em.persist((Object)entity);
    }

    public void deleteScopeMapping(UserModel user, RoleModel role) {
        TypedQuery<UserScopeMappingEntity> query = this.getRealmScopeMappingQuery((UserAdapter)user, (RoleAdapter)role);
        List results = query.getResultList();
        if (results.size() == 0) {
            return;
        }
        for (UserScopeMappingEntity entity : results) {
            this.em.remove((Object)entity);
        }
    }

    public boolean hasScope(UserModel user, RoleModel role) {
        TypedQuery<UserScopeMappingEntity> query = this.getRealmScopeMappingQuery((UserAdapter)user, (RoleAdapter)role);
        return query.getResultList().size() > 0;
    }

    protected TypedQuery<UserScopeMappingEntity> getRealmScopeMappingQuery(UserAdapter user, RoleAdapter role) {
        TypedQuery query = this.em.createNamedQuery("userHasScope", UserScopeMappingEntity.class);
        query.setParameter("user", (Object)user.getUser());
        query.setParameter("role", (Object)role.getRole());
        return query;
    }

    public UserCredentialModel getSecret(UserModel user) {
        for (CredentialEntity cred : ((UserAdapter)user).getUser().getCredentials()) {
            if (!cred.getType().equals("secret")) continue;
            return UserCredentialModel.secret((String)cred.getValue());
        }
        return null;
    }

    public boolean validatePassword(UserModel user, String password) {
        for (CredentialEntity cred : ((UserAdapter)user).getUser().getCredentials()) {
            if (!cred.getType().equals("password")) continue;
            return new Pbkdf2PasswordEncoder(cred.getSalt()).verify(password, cred.getValue());
        }
        return false;
    }

    public boolean validateSecret(UserModel user, String secret) {
        for (CredentialEntity cred : ((UserAdapter)user).getUser().getCredentials()) {
            if (!cred.getType().equals("secret")) continue;
            return secret.equals(cred.getValue());
        }
        return false;
    }

    public boolean validateTOTP(UserModel user, String password, String token) {
        if (!this.validatePassword(user, password)) {
            return false;
        }
        for (CredentialEntity cred : ((UserAdapter)user).getUser().getCredentials()) {
            if (!cred.getType().equals("totp")) continue;
            return new TimeBasedOTP().validate(token, cred.getValue().getBytes());
        }
        return false;
    }

    public void updateCredential(UserModel user, UserCredentialModel cred) {
        CredentialEntity credentialEntity = null;
        UserEntity userEntity = ((UserAdapter)user).getUser();
        for (CredentialEntity entity : userEntity.getCredentials()) {
            if (!entity.getType().equals(cred.getType())) continue;
            credentialEntity = entity;
        }
        if (credentialEntity == null) {
            credentialEntity = new CredentialEntity();
            credentialEntity.setType(cred.getType());
            credentialEntity.setDevice(cred.getDevice());
            credentialEntity.setUser(userEntity);
            this.em.persist((Object)credentialEntity);
            userEntity.getCredentials().add(credentialEntity);
        }
        if (cred.getType().equals("password")) {
            byte[] salt = Pbkdf2PasswordEncoder.getSalt();
            credentialEntity.setValue(new Pbkdf2PasswordEncoder(salt).encode(cred.getValue()));
            credentialEntity.setSalt(salt);
        } else {
            credentialEntity.setValue(cred.getValue());
        }
        credentialEntity.setDevice(cred.getDevice());
        this.em.flush();
    }

    public PasswordPolicy getPasswordPolicy() {
        if (this.passwordPolicy == null) {
            this.passwordPolicy = new PasswordPolicy(this.realm.getPasswordPolicy());
        }
        return this.passwordPolicy;
    }

    public void setPasswordPolicy(PasswordPolicy policy) {
        this.passwordPolicy = policy;
        this.realm.setPasswordPolicy(policy.toString());
        this.em.flush();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof RealmAdapter)) {
            return false;
        }
        RealmAdapter r = (RealmAdapter)o;
        return r.getId().equals(this.getId());
    }

    public String getLoginTheme() {
        return this.realm.getLoginTheme();
    }

    public void setLoginTheme(String name) {
        this.realm.setLoginTheme(name);
        this.em.flush();
    }

    public String getAccountTheme() {
        return this.realm.getAccountTheme();
    }

    public void setAccountTheme(String name) {
        this.realm.setAccountTheme(name);
        this.em.flush();
    }
}

