/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.SocialLinkModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.models.jpa.UserAdapter;
import org.keycloak.models.jpa.entities.SocialLinkEntity;
import org.keycloak.models.jpa.entities.UserEntity;
import org.keycloak.models.utils.CredentialValidation;
import org.keycloak.models.utils.KeycloakModelUtils;

public class JpaUserProvider
implements UserProvider {
    private final KeycloakSession session;
    protected EntityManager em;

    public JpaUserProvider(KeycloakSession session, EntityManager em) {
        this.session = session;
        this.em = em;
    }

    public UserModel addUser(RealmModel realm, String id, String username, boolean addDefaultRoles) {
        if (id == null) {
            id = KeycloakModelUtils.generateId();
        }
        UserEntity entity = new UserEntity();
        entity.setId(id);
        entity.setUsername(username);
        entity.setRealmId(realm.getId());
        this.em.persist((Object)entity);
        this.em.flush();
        UserAdapter userModel = new UserAdapter(realm, this.em, entity);
        if (addDefaultRoles) {
            for (String r : realm.getDefaultRoles()) {
                userModel.grantRole(realm.getRole(r));
            }
            for (ApplicationModel application : realm.getApplications()) {
                for (String r : application.getDefaultRoles()) {
                    userModel.grantRole(application.getRole(r));
                }
            }
        }
        return userModel;
    }

    public UserModel addUser(RealmModel realm, String username) {
        return this.addUser(realm, KeycloakModelUtils.generateId(), username, true);
    }

    public boolean removeUser(RealmModel realm, UserModel user) {
        UserEntity userEntity = (UserEntity)this.em.find(UserEntity.class, (Object)user.getId());
        if (userEntity == null) {
            return false;
        }
        this.removeUser(userEntity);
        return true;
    }

    private void removeUser(UserEntity user) {
        this.em.createNamedQuery("deleteUserRoleMappingsByUser").setParameter("user", (Object)user).executeUpdate();
        this.em.createNamedQuery("deleteSocialLinkByUser").setParameter("user", (Object)user).executeUpdate();
        this.em.remove((Object)user);
    }

    public void addSocialLink(RealmModel realm, UserModel user, SocialLinkModel socialLink) {
        SocialLinkEntity entity = new SocialLinkEntity();
        entity.setRealmId(realm.getId());
        entity.setSocialProvider(socialLink.getSocialProvider());
        entity.setSocialUserId(socialLink.getSocialUserId());
        entity.setSocialUsername(socialLink.getSocialUsername());
        UserEntity userEntity = (UserEntity)this.em.getReference(UserEntity.class, (Object)user.getId());
        entity.setUser(userEntity);
        this.em.persist((Object)entity);
        this.em.flush();
    }

    public boolean removeSocialLink(RealmModel realm, UserModel user, String socialProvider) {
        SocialLinkEntity entity = this.findSocialLink(user, socialProvider);
        if (entity != null) {
            this.em.remove((Object)entity);
            this.em.flush();
            return true;
        }
        return false;
    }

    public void preRemove(RealmModel realm) {
        int num = this.em.createNamedQuery("deleteUserRoleMappingsByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteUserRequiredActionsByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteSocialLinkByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteCredentialsByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteUserAttributesByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteUsersByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
    }

    public void preRemove(RealmModel realm, RoleModel role) {
        this.em.createNamedQuery("deleteUserRoleMappingsByRole").setParameter("roleId", (Object)role.getId()).executeUpdate();
    }

    public UserModel getUserById(String id, RealmModel realm) {
        TypedQuery query = this.em.createNamedQuery("getRealmUserById", UserEntity.class);
        query.setParameter("id", (Object)id);
        query.setParameter("realmId", (Object)realm.getId());
        List entities = query.getResultList();
        if (entities.size() == 0) {
            return null;
        }
        return new UserAdapter(realm, this.em, (UserEntity)entities.get(0));
    }

    public UserModel getUserByUsername(String username, RealmModel realm) {
        TypedQuery query = this.em.createNamedQuery("getRealmUserByUsername", UserEntity.class);
        query.setParameter("username", (Object)username);
        query.setParameter("realmId", (Object)realm.getId());
        List results = query.getResultList();
        if (results.size() == 0) {
            return null;
        }
        return new UserAdapter(realm, this.em, (UserEntity)results.get(0));
    }

    public UserModel getUserByEmail(String email, RealmModel realm) {
        TypedQuery query = this.em.createNamedQuery("getRealmUserByEmail", UserEntity.class);
        query.setParameter("email", (Object)email);
        query.setParameter("realmId", (Object)realm.getId());
        List results = query.getResultList();
        return results.isEmpty() ? null : new UserAdapter(realm, this.em, (UserEntity)results.get(0));
    }

    public void close() {
    }

    public UserModel getUserBySocialLink(SocialLinkModel socialLink, RealmModel realm) {
        TypedQuery query = this.em.createNamedQuery("findUserByLinkAndRealm", UserEntity.class);
        query.setParameter("realmId", (Object)realm.getId());
        query.setParameter("socialProvider", (Object)socialLink.getSocialProvider());
        query.setParameter("socialUserId", (Object)socialLink.getSocialUserId());
        List results = query.getResultList();
        if (results.isEmpty()) {
            return null;
        }
        if (results.size() > 1) {
            throw new IllegalStateException("More results found for socialProvider=" + socialLink.getSocialProvider() + ", socialUserId=" + socialLink.getSocialUserId() + ", results=" + results);
        }
        UserEntity user = (UserEntity)results.get(0);
        return new UserAdapter(realm, this.em, user);
    }

    public List<UserModel> getUsers(RealmModel realm) {
        return this.getUsers(realm, -1, -1);
    }

    public int getUsersCount(RealmModel realm) {
        Object count = this.em.createNamedQuery("getRealmUserCount").setParameter("realmId", (Object)realm.getId()).getSingleResult();
        return ((Number)count).intValue();
    }

    public List<UserModel> getUsers(RealmModel realm, int firstResult, int maxResults) {
        TypedQuery query = this.em.createNamedQuery("getAllUsersByRealm", UserEntity.class);
        query.setParameter("realmId", (Object)realm.getId());
        if (firstResult != -1) {
            query.setFirstResult(firstResult);
        }
        if (maxResults != -1) {
            query.setMaxResults(maxResults);
        }
        List results = query.getResultList();
        ArrayList<UserModel> users = new ArrayList<UserModel>();
        for (UserEntity entity : results) {
            users.add(new UserAdapter(realm, this.em, entity));
        }
        return users;
    }

    public List<UserModel> searchForUser(String search, RealmModel realm) {
        return this.searchForUser(search, realm, -1, -1);
    }

    public List<UserModel> searchForUser(String search, RealmModel realm, int firstResult, int maxResults) {
        TypedQuery query = this.em.createNamedQuery("searchForUser", UserEntity.class);
        query.setParameter("realmId", (Object)realm.getId());
        query.setParameter("search", (Object)("%" + search.toLowerCase() + "%"));
        if (firstResult != -1) {
            query.setFirstResult(firstResult);
        }
        if (maxResults != -1) {
            query.setMaxResults(maxResults);
        }
        List results = query.getResultList();
        ArrayList<UserModel> users = new ArrayList<UserModel>();
        for (UserEntity entity : results) {
            users.add(new UserAdapter(realm, this.em, entity));
        }
        return users;
    }

    public List<UserModel> searchForUserByAttributes(Map<String, String> attributes, RealmModel realm) {
        return this.searchForUserByAttributes(attributes, realm, -1, -1);
    }

    public List<UserModel> searchForUserByAttributes(Map<String, String> attributes, RealmModel realm, int firstResult, int maxResults) {
        StringBuilder builder = new StringBuilder("select u from UserEntity u");
        boolean first = true;
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            String attribute = null;
            if (entry.getKey().equals("username")) {
                attribute = "lower(username)";
            } else if (entry.getKey().equalsIgnoreCase("firstName")) {
                attribute = "lower(firstName)";
            } else if (entry.getKey().equalsIgnoreCase("lastName")) {
                attribute = "lower(lastName)";
            } else if (entry.getKey().equalsIgnoreCase("email")) {
                attribute = "lower(email)";
            }
            if (attribute == null) continue;
            if (first) {
                first = false;
                builder.append(" where realm = :realm");
            } else {
                builder.append(" and ");
            }
            builder.append(attribute).append(" like '%").append(entry.getValue().toLowerCase()).append("%'");
        }
        builder.append(" order by u.username");
        String q = builder.toString();
        TypedQuery query = this.em.createQuery(q, UserEntity.class);
        query.setParameter("realmId", (Object)realm.getId());
        if (firstResult != -1) {
            query.setFirstResult(firstResult);
        }
        if (maxResults != -1) {
            query.setMaxResults(maxResults);
        }
        List results = query.getResultList();
        ArrayList<UserModel> users = new ArrayList<UserModel>();
        for (UserEntity entity : results) {
            users.add(new UserAdapter(realm, this.em, entity));
        }
        return users;
    }

    private SocialLinkEntity findSocialLink(UserModel user, String socialProvider) {
        TypedQuery query = this.em.createNamedQuery("findSocialLinkByUserAndProvider", SocialLinkEntity.class);
        UserEntity userEntity = (UserEntity)this.em.getReference(UserEntity.class, (Object)user.getId());
        query.setParameter("user", (Object)userEntity);
        query.setParameter("socialProvider", (Object)socialProvider);
        List results = query.getResultList();
        return results.size() > 0 ? (SocialLinkEntity)results.get(0) : null;
    }

    public Set<SocialLinkModel> getSocialLinks(UserModel user, RealmModel realm) {
        TypedQuery query = this.em.createNamedQuery("findSocialLinkByUser", SocialLinkEntity.class);
        UserEntity userEntity = (UserEntity)this.em.getReference(UserEntity.class, (Object)user.getId());
        query.setParameter("user", (Object)userEntity);
        List results = query.getResultList();
        HashSet<SocialLinkModel> set = new HashSet<SocialLinkModel>();
        for (SocialLinkEntity entity : results) {
            set.add(new SocialLinkModel(entity.getSocialProvider(), entity.getSocialUserId(), entity.getSocialUsername()));
        }
        return set;
    }

    public SocialLinkModel getSocialLink(UserModel user, String socialProvider, RealmModel realm) {
        SocialLinkEntity entity = this.findSocialLink(user, socialProvider);
        return entity != null ? new SocialLinkModel(entity.getSocialProvider(), entity.getSocialUserId(), entity.getSocialUsername()) : null;
    }

    public boolean validCredentials(RealmModel realm, UserModel user, List<UserCredentialModel> input) {
        return CredentialValidation.validCredentials((RealmModel)realm, (UserModel)user, input);
    }

    public boolean validCredentials(RealmModel realm, UserModel user, UserCredentialModel ... input) {
        return CredentialValidation.validCredentials((RealmModel)realm, (UserModel)user, (UserCredentialModel[])input);
    }
}

