/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.jpa.store;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.keycloak.authorization.jpa.entities.PolicyEntity;
import org.keycloak.authorization.jpa.entities.ResourceServerEntity;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.models.utils.KeycloakModelUtils;

public class JPAPolicyStore
implements PolicyStore {
    private final EntityManager entityManager;

    public JPAPolicyStore(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public Policy create(String name, String type, ResourceServer resourceServer) {
        PolicyEntity entity = new PolicyEntity();
        entity.setId(KeycloakModelUtils.generateId());
        entity.setName(name);
        entity.setType(type);
        entity.setResourceServer((ResourceServerEntity)resourceServer);
        this.entityManager.persist((Object)entity);
        return entity;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void delete(String id) {
        Policy policy = this.findById(id);
        if (policy != null) {
            this.getEntityManager().remove((Object)policy);
        }
    }

    public Policy findById(String id) {
        return (Policy)this.getEntityManager().find(PolicyEntity.class, (Object)id);
    }

    public Policy findByName(String name, String resourceServerId) {
        try {
            Query query = this.getEntityManager().createQuery("from PolicyEntity where name = :name and resourceServer.id = :serverId");
            query.setParameter("name", (Object)name);
            query.setParameter("serverId", (Object)resourceServerId);
            return (Policy)query.getSingleResult();
        }
        catch (NoResultException nre) {
            return null;
        }
    }

    public List<Policy> findByResourceServer(String resourceServerId) {
        Query query = this.getEntityManager().createQuery("from PolicyEntity where resourceServer.id = :serverId");
        query.setParameter("serverId", (Object)resourceServerId);
        return query.getResultList();
    }

    public List<Policy> findByResourceServer(Map<String, String[]> attributes, String resourceServerId, int firstResult, int maxResult) {
        CriteriaBuilder builder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery querybuilder = builder.createQuery(PolicyEntity.class);
        Root root = querybuilder.from(PolicyEntity.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.equal((Expression)root.get("resourceServer").get("id"), (Object)resourceServerId));
        attributes.forEach((name, value) -> {
            if ("permission".equals(name)) {
                if (Boolean.valueOf(value[0]).booleanValue()) {
                    predicates.add(root.get("type").in(new Object[]{"resource", "scope"}));
                } else {
                    predicates.add(builder.not((Expression)root.get("type").in(new Object[]{"resource", "scope"})));
                }
            } else if ("id".equals(name)) {
                predicates.add(root.get(name).in((Object[])value));
            } else {
                predicates.add(builder.like(builder.lower((Expression)root.get(name)), "%" + value[0].toLowerCase() + "%"));
            }
        });
        querybuilder.where(predicates.toArray(new Predicate[predicates.size()])).orderBy(new Order[]{builder.asc((Expression)root.get("name"))});
        TypedQuery query = this.entityManager.createQuery(querybuilder);
        if (firstResult != -1) {
            query.setFirstResult(firstResult);
        }
        if (maxResult != -1) {
            query.setMaxResults(maxResult);
        }
        return query.getResultList();
    }

    public List<Policy> findByResource(String resourceId) {
        Query query = this.getEntityManager().createQuery("select p from PolicyEntity p inner join p.resources r where r.id = :resourceId");
        query.setParameter("resourceId", (Object)resourceId);
        return query.getResultList();
    }

    public List<Policy> findByResourceType(String resourceType, String resourceServerId) {
        ArrayList<Policy> policies = new ArrayList<Policy>();
        Query query = this.getEntityManager().createQuery("from PolicyEntity where resourceServer.id = :serverId");
        query.setParameter("serverId", (Object)resourceServerId);
        List models = query.getResultList();
        for (Policy policy : models) {
            String defaultType = (String)policy.getConfig().get("defaultResourceType");
            if (defaultType == null || !defaultType.equals(resourceType) || !policy.getResources().isEmpty()) continue;
            policies.add(policy);
        }
        return policies;
    }

    public List<Policy> findByScopeIds(List<String> scopeIds, String resourceServerId) {
        if (scopeIds == null || scopeIds.isEmpty()) {
            return Collections.emptyList();
        }
        Query query = this.getEntityManager().createQuery("select pe from PolicyEntity pe where pe.id IN (select p.id from PolicyEntity p inner join p.scopes s where p.resourceServer.id = :serverId and s.id in (:scopeIds) and p.resources is empty group by p.id) order by pe.name");
        query.setParameter("serverId", (Object)resourceServerId);
        query.setParameter("scopeIds", scopeIds);
        return query.getResultList();
    }

    public List<Policy> findByType(String type) {
        Query query = this.getEntityManager().createQuery("select p from PolicyEntity p where p.type = :type");
        query.setParameter("type", (Object)type);
        return query.getResultList();
    }

    public List<Policy> findDependentPolicies(String policyId) {
        Query query = this.getEntityManager().createQuery("select p from PolicyEntity p inner join p.associatedPolicies ap where ap.id in (:policyId)");
        query.setParameter("policyId", Arrays.asList(policyId));
        return query.getResultList();
    }
}

