/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.TypedQuery;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Base64;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.UserCredentialStore;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.jpa.entities.CredentialEntity;
import org.keycloak.models.jpa.entities.UserEntity;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.utils.StreamsUtil;

public class JpaUserCredentialStore
implements UserCredentialStore {
    public static final int PRIORITY_DIFFERENCE = 10;
    protected static final Logger logger = Logger.getLogger(JpaUserCredentialStore.class);
    private final KeycloakSession session;
    protected final EntityManager em;

    public JpaUserCredentialStore(KeycloakSession session, EntityManager em) {
        this.session = session;
        this.em = em;
    }

    public void updateCredential(RealmModel realm, UserModel user, CredentialModel cred) {
        CredentialEntity entity = (CredentialEntity)this.em.find(CredentialEntity.class, (Object)cred.getId());
        if (!this.checkCredentialEntity(entity, user)) {
            return;
        }
        entity.setCreatedDate(cred.getCreatedDate());
        entity.setUserLabel(cred.getUserLabel());
        entity.setType(cred.getType());
        entity.setSecretData(cred.getSecretData());
        entity.setCredentialData(cred.getCredentialData());
    }

    public CredentialModel createCredential(RealmModel realm, UserModel user, CredentialModel cred) {
        CredentialEntity entity = this.createCredentialEntity(realm, user, cred);
        return this.toModel(entity);
    }

    public boolean removeStoredCredential(RealmModel realm, UserModel user, String id) {
        CredentialEntity entity = this.removeCredentialEntity(realm, user, id);
        return entity != null;
    }

    public CredentialModel getStoredCredentialById(RealmModel realm, UserModel user, String id) {
        CredentialEntity entity = (CredentialEntity)this.em.find(CredentialEntity.class, (Object)id);
        if (!this.checkCredentialEntity(entity, user)) {
            return null;
        }
        CredentialModel model = this.toModel(entity);
        return model;
    }

    CredentialModel toModel(CredentialEntity entity) {
        CredentialModel model = new CredentialModel();
        model.setId(entity.getId());
        model.setType(entity.getType());
        model.setCreatedDate(entity.getCreatedDate());
        model.setUserLabel(entity.getUserLabel());
        if (entity.getSalt() != null) {
            String newSecretData = entity.getSecretData().replace("__SALT__", Base64.encodeBytes((byte[])entity.getSalt()));
            entity.setSecretData(newSecretData);
            entity.setSalt(null);
        }
        model.setSecretData(entity.getSecretData());
        model.setCredentialData(entity.getCredentialData());
        return model;
    }

    public Stream<CredentialModel> getStoredCredentialsStream(RealmModel realm, UserModel user) {
        return this.getStoredCredentialEntities(realm, user).map(this::toModel);
    }

    private Stream<CredentialEntity> getStoredCredentialEntities(RealmModel realm, UserModel user) {
        UserEntity userEntity = (UserEntity)this.em.getReference(UserEntity.class, (Object)user.getId());
        TypedQuery query = this.em.createNamedQuery("credentialByUser", CredentialEntity.class).setParameter("user", (Object)userEntity);
        return StreamsUtil.closing((Stream)query.getResultStream());
    }

    public Stream<CredentialModel> getStoredCredentialsByTypeStream(RealmModel realm, UserModel user, String type) {
        return this.getStoredCredentialsStream(realm, user).filter(credential -> Objects.equals(type, credential.getType()));
    }

    public CredentialModel getStoredCredentialByNameAndType(RealmModel realm, UserModel user, String name, String type) {
        return this.getStoredCredentialsStream(realm, user).filter(credential -> Objects.equals(type, credential.getType()) && Objects.equals(name, credential.getUserLabel())).findFirst().orElse(null);
    }

    public void close() {
    }

    CredentialEntity createCredentialEntity(RealmModel realm, UserModel user, CredentialModel cred) {
        CredentialEntity entity = new CredentialEntity();
        String id = cred.getId() == null ? KeycloakModelUtils.generateId() : cred.getId();
        entity.setId(id);
        entity.setCreatedDate(cred.getCreatedDate());
        entity.setUserLabel(cred.getUserLabel());
        entity.setType(cred.getType());
        entity.setSecretData(cred.getSecretData());
        entity.setCredentialData(cred.getCredentialData());
        UserEntity userRef = (UserEntity)this.em.getReference(UserEntity.class, (Object)user.getId());
        entity.setUser(userRef);
        List credentials = this.getStoredCredentialEntities(realm, user).collect(Collectors.toList());
        int priority = credentials.isEmpty() ? 10 : ((CredentialEntity)credentials.get(credentials.size() - 1)).getPriority() + 10;
        entity.setPriority(priority);
        this.em.persist((Object)entity);
        return entity;
    }

    CredentialEntity removeCredentialEntity(RealmModel realm, UserModel user, String id) {
        CredentialEntity entity = (CredentialEntity)this.em.find(CredentialEntity.class, (Object)id, LockModeType.PESSIMISTIC_WRITE);
        if (!this.checkCredentialEntity(entity, user)) {
            return null;
        }
        int currentPriority = entity.getPriority();
        this.getStoredCredentialEntities(realm, user).forEach(cred -> {
            if (cred.getPriority() > currentPriority) {
                cred.setPriority(cred.getPriority() - 10);
            }
        });
        this.em.remove((Object)entity);
        this.em.flush();
        return entity;
    }

    public boolean moveCredentialTo(RealmModel realm, UserModel user, String id, String newPreviousCredentialId) {
        List newList = this.getStoredCredentialEntities(realm, user).collect(Collectors.toList());
        int ourCredentialIndex = -1;
        int newPreviousCredentialIndex = -1;
        CredentialEntity ourCredential = null;
        int i = 0;
        for (CredentialEntity credential : newList) {
            if (id.equals(credential.getId())) {
                ourCredentialIndex = i;
                ourCredential = credential;
            } else if (newPreviousCredentialId != null && newPreviousCredentialId.equals(credential.getId())) {
                newPreviousCredentialIndex = i;
            }
            ++i;
        }
        if (ourCredentialIndex == -1) {
            logger.warnf("Not found credential with id [%s] of user [%s]", (Object)id, (Object)user.getUsername());
            return false;
        }
        if (newPreviousCredentialId != null && newPreviousCredentialIndex == -1) {
            logger.warnf("Can't move up credential with id [%s] of user [%s]", (Object)id, (Object)user.getUsername());
            return false;
        }
        int toMoveIndex = newPreviousCredentialId == null ? 0 : newPreviousCredentialIndex + 1;
        newList.add(toMoveIndex, ourCredential);
        int indexToRemove = toMoveIndex < ourCredentialIndex ? ourCredentialIndex + 1 : ourCredentialIndex;
        newList.remove(indexToRemove);
        int expectedPriority = 0;
        for (CredentialEntity credential : newList) {
            if (credential.getPriority() == (expectedPriority += 10)) continue;
            credential.setPriority(expectedPriority);
            logger.tracef("Priority of credential [%s] of user [%s] changed to [%d]", (Object)credential.getId(), (Object)user.getUsername(), (Object)expectedPriority);
        }
        return true;
    }

    private boolean checkCredentialEntity(CredentialEntity entity, UserModel user) {
        return entity != null && entity.getUser() != null && entity.getUser().getId().equals(user.getId());
    }
}

