/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa;

import jakarta.persistence.EntityExistsException;
import jakarta.persistence.EntityManager;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.hibernate.exception.ConstraintViolationException;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ModelException;

public class PersistenceExceptionConverter
implements InvocationHandler {
    private static final Pattern WRITE_METHOD_NAMES = Pattern.compile("persist|merge");
    private final EntityManager em;
    private final boolean batchEnabled;
    private final int batchSize;
    private int changeCount = 0;

    public static EntityManager create(KeycloakSession session, EntityManager em) {
        return (EntityManager)Proxy.newProxyInstance(EntityManager.class.getClassLoader(), new Class[]{EntityManager.class}, (InvocationHandler)new PersistenceExceptionConverter(session, em));
    }

    private PersistenceExceptionConverter(KeycloakSession session, EntityManager em) {
        this.batchEnabled = (Boolean)session.getAttributeOrDefault("org.keycloak.storage.batch_enabled", (Object)false);
        this.batchSize = (Integer)session.getAttributeOrDefault("org.keycloak.storage.batch_size", (Object)100);
        this.em = em;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            this.flushInBatchIfEnabled(method);
            return method.invoke((Object)this.em, args);
        }
        catch (InvocationTargetException e) {
            throw PersistenceExceptionConverter.convert(e.getCause());
        }
    }

    private void flushInBatchIfEnabled(Method method) {
        if (this.batchEnabled && WRITE_METHOD_NAMES.matcher(method.getName()).matches() && this.changeCount++ > this.batchSize) {
            this.em.flush();
            this.em.clear();
            this.changeCount = 0;
        }
    }

    public static ModelException convert(Throwable t) {
        Predicate<Throwable> checkDuplicationMessage = throwable -> {
            String message = throwable.getCause() != null ? throwable.getCause().getMessage() : throwable.getMessage();
            return message.toLowerCase().contains("duplicate");
        };
        Predicate<Throwable> throwModelDuplicateEx = throwable -> throwable instanceof EntityExistsException || throwable instanceof ConstraintViolationException || throwable instanceof SQLIntegrityConstraintViolationException;
        throwModelDuplicateEx = throwModelDuplicateEx.or(checkDuplicationMessage);
        if (t.getCause() != null && throwModelDuplicateEx.test(t.getCause())) {
            throw new ModelDuplicateException(t.getCause());
        }
        if (throwModelDuplicateEx.test(t)) {
            throw new ModelDuplicateException(t);
        }
        throw new ModelException(t);
    }
}

