/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa.updater.liquibase.lock;

import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.common.Profile;
import org.keycloak.common.util.Time;
import org.keycloak.connections.jpa.updater.liquibase.lock.LiquibaseDBLockProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.dblock.DBLockProviderFactory;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;

public class LiquibaseDBLockProviderFactory
implements DBLockProviderFactory,
EnvironmentDependentProviderFactory {
    private static final Logger logger = Logger.getLogger(LiquibaseDBLockProviderFactory.class);
    public static final int PROVIDER_PRIORITY = 1;
    private long lockWaitTimeoutMillis;

    protected long getLockWaitTimeoutMillis() {
        return this.lockWaitTimeoutMillis;
    }

    public void init(Config.Scope config) {
        int lockWaitTimeout = config.getInt("lockWaitTimeout", Integer.valueOf(900));
        this.lockWaitTimeoutMillis = Time.toMillis((long)lockWaitTimeout);
        logger.debugf("Liquibase lock provider configured with lockWaitTime: %d seconds", lockWaitTimeout);
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public LiquibaseDBLockProvider create(KeycloakSession session) {
        return new LiquibaseDBLockProvider(this, session);
    }

    public void setTimeouts(long lockRecheckTimeMillis, long lockWaitTimeoutMillis) {
        this.lockWaitTimeoutMillis = lockWaitTimeoutMillis;
    }

    public void close() {
    }

    public String getId() {
        return "jpa";
    }

    public int order() {
        return 1;
    }

    public List<ProviderConfigProperty> getConfigMetadata() {
        return ProviderConfigurationBuilder.create().property().name("lockWaitTimeout").type("int").helpText("The maximum time to wait when waiting to release a database lock.").add().build();
    }

    public boolean isSupported() {
        return !Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.MAP_STORAGE);
    }
}

