/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.organization.jpa;

import org.keycloak.Config;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.ModelValidationException;
import org.keycloak.models.RealmModel;
import org.keycloak.organization.OrganizationProvider;
import org.keycloak.organization.OrganizationProviderFactory;
import org.keycloak.organization.jpa.JpaOrganizationProvider;
import org.keycloak.organization.utils.Organizations;
import org.keycloak.provider.ProviderEvent;

public class JpaOrganizationProviderFactory
implements OrganizationProviderFactory {
    public OrganizationProvider create(KeycloakSession session) {
        return new JpaOrganizationProvider(session);
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
        factory.register(this::handleEvents);
    }

    public void close() {
    }

    public String getId() {
        return "jpa";
    }

    private void handleEvents(ProviderEvent event) {
        GroupModel group;
        GroupModel.GroupEvent groupEvent;
        KeycloakSession session;
        if (event instanceof RealmModel.RealmPostCreateEvent) {
            RealmModel realm = ((RealmModel.RealmPostCreateEvent)event).getCreatedRealm();
            this.configureAuthenticationFlows(realm);
        }
        if (event instanceof RealmModel.RealmRemovedEvent) {
            KeycloakSession session2 = ((RealmModel.RealmRemovedEvent)event).getKeycloakSession();
            OrganizationProvider provider = (OrganizationProvider)session2.getProvider(OrganizationProvider.class);
            provider.removeAll();
        }
        if (event instanceof GroupModel.GroupEvent && !Organizations.canManageOrganizationGroup((KeycloakSession)(session = (groupEvent = (GroupModel.GroupEvent)event).getKeycloakSession()), (GroupModel)(group = groupEvent.getGroup()))) {
            throw new ModelValidationException("Can not update organization group");
        }
    }

    private void configureAuthenticationFlows(RealmModel realm) {
        this.addOrganizationFirstBrokerFlowStep(realm);
        this.addOrganizationBrowserFlowStep(realm);
    }

    private void addOrganizationFirstBrokerFlowStep(RealmModel realm) {
        AuthenticationFlowModel firstBrokerLoginFlow = realm.getFirstBrokerLoginFlow();
        if (firstBrokerLoginFlow == null) {
            return;
        }
        if (realm.getAuthenticationExecutionsStream(firstBrokerLoginFlow.getId()).map(AuthenticationExecutionModel::getAuthenticator).anyMatch("idp-add-organization-member"::equals)) {
            return;
        }
        if (!Config.getAdminRealm().equals(realm.getName())) {
            AuthenticationFlowModel conditionalOrg = new AuthenticationFlowModel();
            conditionalOrg.setTopLevel(false);
            conditionalOrg.setBuiltIn(true);
            conditionalOrg.setAlias("First Broker Login - Conditional Organization");
            conditionalOrg.setDescription("Flow to determine if the authenticator that adds organization members is to be used");
            conditionalOrg.setProviderId("basic-flow");
            conditionalOrg = realm.addAuthenticationFlow(conditionalOrg);
            AuthenticationExecutionModel execution = new AuthenticationExecutionModel();
            execution.setParentFlow(firstBrokerLoginFlow.getId());
            execution.setRequirement(AuthenticationExecutionModel.Requirement.CONDITIONAL);
            execution.setFlowId(conditionalOrg.getId());
            execution.setPriority(50);
            execution.setAuthenticatorFlow(true);
            realm.addAuthenticatorExecution(execution);
            execution = new AuthenticationExecutionModel();
            execution.setParentFlow(conditionalOrg.getId());
            execution.setRequirement(AuthenticationExecutionModel.Requirement.REQUIRED);
            execution.setAuthenticator("conditional-user-configured");
            execution.setPriority(10);
            execution.setAuthenticatorFlow(false);
            realm.addAuthenticatorExecution(execution);
            execution = new AuthenticationExecutionModel();
            execution.setParentFlow(conditionalOrg.getId());
            execution.setRequirement(AuthenticationExecutionModel.Requirement.REQUIRED);
            execution.setAuthenticator("idp-add-organization-member");
            execution.setPriority(20);
            execution.setAuthenticatorFlow(false);
            realm.addAuthenticatorExecution(execution);
        }
    }

    public void addOrganizationBrowserFlowStep(RealmModel realm) {
        AuthenticationFlowModel browserFlow = realm.getBrowserFlow();
        if (browserFlow == null) {
            return;
        }
        if (realm.getAuthenticationExecutionsStream(browserFlow.getId()).map(AuthenticationExecutionModel::getAuthenticator).anyMatch("organization"::equals)) {
            return;
        }
        if (!Config.getAdminRealm().equals(realm.getName())) {
            AuthenticationFlowModel organizations = new AuthenticationFlowModel();
            organizations.setTopLevel(false);
            organizations.setBuiltIn(true);
            organizations.setAlias("Organization");
            organizations.setProviderId("basic-flow");
            organizations = realm.addAuthenticationFlow(organizations);
            AuthenticationExecutionModel execution = new AuthenticationExecutionModel();
            execution.setParentFlow(browserFlow.getId());
            execution.setRequirement(AuthenticationExecutionModel.Requirement.ALTERNATIVE);
            execution.setFlowId(organizations.getId());
            execution.setPriority(26);
            execution.setAuthenticatorFlow(true);
            realm.addAuthenticatorExecution(execution);
            AuthenticationFlowModel conditionalOrg = new AuthenticationFlowModel();
            conditionalOrg.setTopLevel(false);
            conditionalOrg.setBuiltIn(true);
            conditionalOrg.setAlias("Browser - Conditional Organization");
            conditionalOrg.setDescription("Flow to determine if the organization identity-first login is to be used");
            conditionalOrg.setProviderId("basic-flow");
            conditionalOrg = realm.addAuthenticationFlow(conditionalOrg);
            execution = new AuthenticationExecutionModel();
            execution.setParentFlow(organizations.getId());
            execution.setRequirement(AuthenticationExecutionModel.Requirement.CONDITIONAL);
            execution.setFlowId(conditionalOrg.getId());
            execution.setPriority(10);
            execution.setAuthenticatorFlow(true);
            realm.addAuthenticatorExecution(execution);
            execution = new AuthenticationExecutionModel();
            execution.setParentFlow(conditionalOrg.getId());
            execution.setRequirement(AuthenticationExecutionModel.Requirement.REQUIRED);
            execution.setAuthenticator("conditional-user-configured");
            execution.setPriority(10);
            execution.setAuthenticatorFlow(false);
            realm.addAuthenticatorExecution(execution);
            execution = new AuthenticationExecutionModel();
            execution.setParentFlow(conditionalOrg.getId());
            execution.setRequirement(AuthenticationExecutionModel.Requirement.ALTERNATIVE);
            execution.setAuthenticator("organization");
            execution.setPriority(20);
            execution.setAuthenticatorFlow(false);
            realm.addAuthenticatorExecution(execution);
        }
    }
}

