/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.common.util.Time;
import org.keycloak.component.ComponentModel;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.UserCredentialStore;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientTemplateModel;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ModelException;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.models.jpa.UserAdapter;
import org.keycloak.models.jpa.entities.CredentialAttributeEntity;
import org.keycloak.models.jpa.entities.CredentialEntity;
import org.keycloak.models.jpa.entities.FederatedIdentityEntity;
import org.keycloak.models.jpa.entities.UserConsentEntity;
import org.keycloak.models.jpa.entities.UserConsentProtocolMapperEntity;
import org.keycloak.models.jpa.entities.UserConsentRoleEntity;
import org.keycloak.models.jpa.entities.UserEntity;
import org.keycloak.models.utils.DefaultRoles;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.storage.UserStorageProvider;

public class JpaUserProvider
implements UserProvider,
UserCredentialStore {
    private static final String EMAIL = "email";
    private static final String USERNAME = "username";
    private static final String FIRST_NAME = "firstName";
    private static final String LAST_NAME = "lastName";
    private final KeycloakSession session;
    protected EntityManager em;

    public JpaUserProvider(KeycloakSession session, EntityManager em) {
        this.session = session;
        this.em = em;
    }

    public UserModel addUser(RealmModel realm, String id, String username, boolean addDefaultRoles, boolean addDefaultRequiredActions) {
        if (id == null) {
            id = KeycloakModelUtils.generateId();
        }
        UserEntity entity = new UserEntity();
        entity.setId(id);
        entity.setCreatedTimestamp(System.currentTimeMillis());
        entity.setUsername(username.toLowerCase());
        entity.setRealmId(realm.getId());
        this.em.persist((Object)entity);
        this.em.flush();
        UserAdapter userModel = new UserAdapter(this.session, realm, this.em, entity);
        if (addDefaultRoles) {
            DefaultRoles.addDefaultRoles((RealmModel)realm, (UserModel)userModel);
            for (GroupModel g : realm.getDefaultGroups()) {
                userModel.joinGroupImpl(g);
            }
        }
        if (addDefaultRequiredActions) {
            for (RequiredActionProviderModel r : realm.getRequiredActionProviders()) {
                if (!r.isEnabled() || !r.isDefaultAction()) continue;
                userModel.addRequiredAction(r.getAlias());
            }
        }
        return userModel;
    }

    public UserModel addUser(RealmModel realm, String username) {
        return this.addUser(realm, KeycloakModelUtils.generateId(), username.toLowerCase(), true, true);
    }

    public boolean removeUser(RealmModel realm, UserModel user) {
        UserEntity userEntity = (UserEntity)this.em.find(UserEntity.class, (Object)user.getId());
        if (userEntity == null) {
            return false;
        }
        this.removeUser(userEntity);
        return true;
    }

    private void removeUser(UserEntity user) {
        String id = user.getId();
        this.em.createNamedQuery("deleteUserRoleMappingsByUser").setParameter("user", (Object)user).executeUpdate();
        this.em.createNamedQuery("deleteUserGroupMembershipsByUser").setParameter("user", (Object)user).executeUpdate();
        this.em.createNamedQuery("deleteFederatedIdentityByUser").setParameter("user", (Object)user).executeUpdate();
        this.em.createNamedQuery("deleteUserConsentRolesByUser").setParameter("user", (Object)user).executeUpdate();
        this.em.createNamedQuery("deleteUserConsentProtMappersByUser").setParameter("user", (Object)user).executeUpdate();
        this.em.createNamedQuery("deleteUserConsentsByUser").setParameter("user", (Object)user).executeUpdate();
        this.em.flush();
        this.em.clear();
        user = (UserEntity)this.em.find(UserEntity.class, (Object)id);
        if (user != null) {
            this.em.remove((Object)user);
        }
        this.em.flush();
    }

    public void addFederatedIdentity(RealmModel realm, UserModel user, FederatedIdentityModel identity) {
        FederatedIdentityEntity entity = new FederatedIdentityEntity();
        entity.setRealmId(realm.getId());
        entity.setIdentityProvider(identity.getIdentityProvider());
        entity.setUserId(identity.getUserId());
        entity.setUserName(identity.getUserName().toLowerCase());
        entity.setToken(identity.getToken());
        UserEntity userEntity = (UserEntity)this.em.getReference(UserEntity.class, (Object)user.getId());
        entity.setUser(userEntity);
        this.em.persist((Object)entity);
        this.em.flush();
    }

    public void updateFederatedIdentity(RealmModel realm, UserModel federatedUser, FederatedIdentityModel federatedIdentityModel) {
        FederatedIdentityEntity federatedIdentity = this.findFederatedIdentity(federatedUser, federatedIdentityModel.getIdentityProvider());
        federatedIdentity.setToken(federatedIdentityModel.getToken());
        this.em.persist((Object)federatedIdentity);
        this.em.flush();
    }

    public boolean removeFederatedIdentity(RealmModel realm, UserModel user, String identityProvider) {
        FederatedIdentityEntity entity = this.findFederatedIdentity(user, identityProvider);
        if (entity != null) {
            this.em.remove((Object)entity);
            this.em.flush();
            return true;
        }
        return false;
    }

    public void addConsent(RealmModel realm, String userId, UserConsentModel consent) {
        String clientId = consent.getClient().getId();
        UserConsentEntity consentEntity = this.getGrantedConsentEntity(userId, clientId);
        if (consentEntity != null) {
            throw new ModelDuplicateException("Consent already exists for client [" + clientId + "] and user [" + userId + "]");
        }
        long currentTime = Time.currentTimeMillis();
        consentEntity = new UserConsentEntity();
        consentEntity.setId(KeycloakModelUtils.generateId());
        consentEntity.setUser((UserEntity)this.em.getReference(UserEntity.class, (Object)userId));
        consentEntity.setClientId(clientId);
        consentEntity.setCreatedDate(currentTime);
        consentEntity.setLastUpdatedDate(currentTime);
        this.em.persist((Object)consentEntity);
        this.em.flush();
        this.updateGrantedConsentEntity(consentEntity, consent);
    }

    public UserConsentModel getConsentByClient(RealmModel realm, String userId, String clientId) {
        UserConsentEntity entity = this.getGrantedConsentEntity(userId, clientId);
        return this.toConsentModel(realm, entity);
    }

    public List<UserConsentModel> getConsents(RealmModel realm, String userId) {
        TypedQuery query = this.em.createNamedQuery("userConsentsByUser", UserConsentEntity.class);
        query.setParameter("userId", (Object)userId);
        List results = query.getResultList();
        ArrayList<UserConsentModel> consents = new ArrayList<UserConsentModel>();
        for (UserConsentEntity entity : results) {
            UserConsentModel model = this.toConsentModel(realm, entity);
            consents.add(model);
        }
        return consents;
    }

    public void updateConsent(RealmModel realm, String userId, UserConsentModel consent) {
        String clientId = consent.getClient().getId();
        UserConsentEntity consentEntity = this.getGrantedConsentEntity(userId, clientId);
        if (consentEntity == null) {
            throw new ModelException("Consent not found for client [" + clientId + "] and user [" + userId + "]");
        }
        this.updateGrantedConsentEntity(consentEntity, consent);
    }

    public boolean revokeConsentForClient(RealmModel realm, String userId, String clientId) {
        UserConsentEntity consentEntity = this.getGrantedConsentEntity(userId, clientId);
        if (consentEntity == null) {
            return false;
        }
        this.em.remove((Object)consentEntity);
        this.em.flush();
        return true;
    }

    private UserConsentEntity getGrantedConsentEntity(String userId, String clientId) {
        TypedQuery query = this.em.createNamedQuery("userConsentByUserAndClient", UserConsentEntity.class);
        query.setParameter("userId", (Object)userId);
        query.setParameter("clientId", (Object)clientId);
        List results = query.getResultList();
        if (results.size() > 1) {
            throw new ModelException("More results found for user [" + userId + "] and client [" + clientId + "]");
        }
        if (results.size() == 1) {
            return (UserConsentEntity)results.get(0);
        }
        return null;
    }

    private UserConsentModel toConsentModel(RealmModel realm, UserConsentEntity entity) {
        Collection<UserConsentProtocolMapperEntity> grantedProtocolMapperEntities;
        if (entity == null) {
            return null;
        }
        ClientModel client = realm.getClientById(entity.getClientId());
        if (client == null) {
            throw new ModelException("Client with id " + entity.getClientId() + " is not available");
        }
        UserConsentModel model = new UserConsentModel(client);
        model.setCreatedDate(entity.getCreatedDate());
        model.setLastUpdatedDate(entity.getLastUpdatedDate());
        Collection<UserConsentRoleEntity> grantedRoleEntities = entity.getGrantedRoles();
        if (grantedRoleEntities != null) {
            for (UserConsentRoleEntity grantedRole : grantedRoleEntities) {
                RoleModel grantedRoleModel = realm.getRoleById(grantedRole.getRoleId());
                if (grantedRoleModel == null) continue;
                model.addGrantedRole(grantedRoleModel);
            }
        }
        if ((grantedProtocolMapperEntities = entity.getGrantedProtocolMappers()) != null) {
            ClientTemplateModel clientTemplate = null;
            if (client.useTemplateMappers()) {
                clientTemplate = client.getClientTemplate();
            }
            for (UserConsentProtocolMapperEntity grantedProtMapper : grantedProtocolMapperEntities) {
                ProtocolMapperModel protocolMapper = client.getProtocolMapperById(grantedProtMapper.getProtocolMapperId());
                if (protocolMapper == null && clientTemplate != null) {
                    protocolMapper = clientTemplate.getProtocolMapperById(grantedProtMapper.getProtocolMapperId());
                }
                if (protocolMapper == null) continue;
                model.addGrantedProtocolMapper(protocolMapper);
            }
        }
        return model;
    }

    private void updateGrantedConsentEntity(UserConsentEntity consentEntity, UserConsentModel consentModel) {
        Collection<UserConsentProtocolMapperEntity> grantedProtocolMapperEntities = consentEntity.getGrantedProtocolMappers();
        HashSet<UserConsentProtocolMapperEntity> mappersToRemove = new HashSet<UserConsentProtocolMapperEntity>(grantedProtocolMapperEntities);
        for (ProtocolMapperModel protocolMapper : consentModel.getGrantedProtocolMappers()) {
            UserConsentProtocolMapperEntity grantedProtocolMapperEntity = new UserConsentProtocolMapperEntity();
            grantedProtocolMapperEntity.setUserConsent(consentEntity);
            grantedProtocolMapperEntity.setProtocolMapperId(protocolMapper.getId());
            if (!grantedProtocolMapperEntities.contains(grantedProtocolMapperEntity)) {
                this.em.persist((Object)grantedProtocolMapperEntity);
                this.em.flush();
                grantedProtocolMapperEntities.add(grantedProtocolMapperEntity);
                continue;
            }
            mappersToRemove.remove(grantedProtocolMapperEntity);
        }
        for (UserConsentProtocolMapperEntity toRemove : mappersToRemove) {
            grantedProtocolMapperEntities.remove(toRemove);
            this.em.remove((Object)toRemove);
        }
        Collection<UserConsentRoleEntity> grantedRoleEntities = consentEntity.getGrantedRoles();
        HashSet<UserConsentRoleEntity> rolesToRemove = new HashSet<UserConsentRoleEntity>(grantedRoleEntities);
        for (RoleModel role : consentModel.getGrantedRoles()) {
            UserConsentRoleEntity consentRoleEntity = new UserConsentRoleEntity();
            consentRoleEntity.setUserConsent(consentEntity);
            consentRoleEntity.setRoleId(role.getId());
            if (!grantedRoleEntities.contains(consentRoleEntity)) {
                this.em.persist((Object)consentRoleEntity);
                this.em.flush();
                grantedRoleEntities.add(consentRoleEntity);
                continue;
            }
            rolesToRemove.remove(consentRoleEntity);
        }
        for (UserConsentRoleEntity toRemove : rolesToRemove) {
            grantedRoleEntities.remove(toRemove);
            this.em.remove((Object)toRemove);
        }
        consentEntity.setLastUpdatedDate(Time.currentTimeMillis());
        this.em.flush();
    }

    public void grantToAllUsers(RealmModel realm, RoleModel role) {
        int num = this.em.createNamedQuery("grantRoleToAllUsers").setParameter("realmId", (Object)realm.getId()).setParameter("roleId", (Object)role.getId()).executeUpdate();
    }

    public void preRemove(RealmModel realm) {
        int num = this.em.createNamedQuery("deleteUserConsentRolesByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteUserConsentProtMappersByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteUserConsentsByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteUserRoleMappingsByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteUserRequiredActionsByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteFederatedIdentityByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteCredentialAttributeByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteCredentialsByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteUserAttributesByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteUserGroupMembershipByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteUsersByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
    }

    public void removeImportedUsers(RealmModel realm, String storageProviderId) {
        int num = this.em.createNamedQuery("deleteUserRoleMappingsByRealmAndLink").setParameter("realmId", (Object)realm.getId()).setParameter("link", (Object)storageProviderId).executeUpdate();
        num = this.em.createNamedQuery("deleteUserRequiredActionsByRealmAndLink").setParameter("realmId", (Object)realm.getId()).setParameter("link", (Object)storageProviderId).executeUpdate();
        num = this.em.createNamedQuery("deleteFederatedIdentityByRealmAndLink").setParameter("realmId", (Object)realm.getId()).setParameter("link", (Object)storageProviderId).executeUpdate();
        num = this.em.createNamedQuery("deleteCredentialAttributeByRealmAndLink").setParameter("realmId", (Object)realm.getId()).setParameter("link", (Object)storageProviderId).executeUpdate();
        num = this.em.createNamedQuery("deleteCredentialsByRealmAndLink").setParameter("realmId", (Object)realm.getId()).setParameter("link", (Object)storageProviderId).executeUpdate();
        num = this.em.createNamedQuery("deleteUserAttributesByRealmAndLink").setParameter("realmId", (Object)realm.getId()).setParameter("link", (Object)storageProviderId).executeUpdate();
        num = this.em.createNamedQuery("deleteUserGroupMembershipsByRealmAndLink").setParameter("realmId", (Object)realm.getId()).setParameter("link", (Object)storageProviderId).executeUpdate();
        num = this.em.createNamedQuery("deleteUserConsentProtMappersByRealmAndLink").setParameter("realmId", (Object)realm.getId()).setParameter("link", (Object)storageProviderId).executeUpdate();
        num = this.em.createNamedQuery("deleteUserConsentRolesByRealmAndLink").setParameter("realmId", (Object)realm.getId()).setParameter("link", (Object)storageProviderId).executeUpdate();
        num = this.em.createNamedQuery("deleteUserConsentsByRealmAndLink").setParameter("realmId", (Object)realm.getId()).setParameter("link", (Object)storageProviderId).executeUpdate();
        num = this.em.createNamedQuery("deleteUsersByRealmAndLink").setParameter("realmId", (Object)realm.getId()).setParameter("link", (Object)storageProviderId).executeUpdate();
    }

    public void unlinkUsers(RealmModel realm, String storageProviderId) {
        this.em.createNamedQuery("unlinkUsers").setParameter("realmId", (Object)realm.getId()).setParameter("link", (Object)storageProviderId).executeUpdate();
    }

    public void preRemove(RealmModel realm, RoleModel role) {
        this.em.createNamedQuery("deleteUserConsentRolesByRole").setParameter("roleId", (Object)role.getId()).executeUpdate();
        this.em.createNamedQuery("deleteUserRoleMappingsByRole").setParameter("roleId", (Object)role.getId()).executeUpdate();
    }

    public void preRemove(RealmModel realm, ClientModel client) {
        this.em.createNamedQuery("deleteUserConsentProtMappersByClient").setParameter("clientId", (Object)client.getId()).executeUpdate();
        this.em.createNamedQuery("deleteUserConsentRolesByClient").setParameter("clientId", (Object)client.getId()).executeUpdate();
        this.em.createNamedQuery("deleteUserConsentsByClient").setParameter("clientId", (Object)client.getId()).executeUpdate();
    }

    public void preRemove(ProtocolMapperModel protocolMapper) {
        this.em.createNamedQuery("deleteUserConsentProtMappersByProtocolMapper").setParameter("protocolMapperId", (Object)protocolMapper.getId()).executeUpdate();
    }

    public List<UserModel> getGroupMembers(RealmModel realm, GroupModel group) {
        TypedQuery query = this.em.createNamedQuery("groupMembership", UserEntity.class);
        query.setParameter("groupId", (Object)group.getId());
        List results = query.getResultList();
        ArrayList<UserModel> users = new ArrayList<UserModel>();
        for (UserEntity user : results) {
            users.add(new UserAdapter(this.session, realm, this.em, user));
        }
        return users;
    }

    public void preRemove(RealmModel realm, GroupModel group) {
        this.em.createNamedQuery("deleteUserGroupMembershipsByGroup").setParameter("groupId", (Object)group.getId()).executeUpdate();
    }

    public UserModel getUserById(String id, RealmModel realm) {
        TypedQuery query = this.em.createNamedQuery("getRealmUserById", UserEntity.class);
        query.setParameter("id", (Object)id);
        query.setParameter("realmId", (Object)realm.getId());
        List entities = query.getResultList();
        if (entities.size() == 0) {
            return null;
        }
        return new UserAdapter(this.session, realm, this.em, (UserEntity)entities.get(0));
    }

    public UserModel getUserByUsername(String username, RealmModel realm) {
        TypedQuery query = this.em.createNamedQuery("getRealmUserByUsername", UserEntity.class);
        query.setParameter(USERNAME, (Object)username.toLowerCase());
        query.setParameter("realmId", (Object)realm.getId());
        List results = query.getResultList();
        if (results.size() == 0) {
            return null;
        }
        return new UserAdapter(this.session, realm, this.em, (UserEntity)results.get(0));
    }

    public UserModel getUserByEmail(String email, RealmModel realm) {
        TypedQuery query = this.em.createNamedQuery("getRealmUserByEmail", UserEntity.class);
        query.setParameter(EMAIL, (Object)email.toLowerCase());
        query.setParameter("realmId", (Object)realm.getId());
        List results = query.getResultList();
        if (results.isEmpty()) {
            return null;
        }
        this.ensureEmailConstraint(results, realm);
        return new UserAdapter(this.session, realm, this.em, (UserEntity)results.get(0));
    }

    public void close() {
    }

    public UserModel getUserByFederatedIdentity(FederatedIdentityModel identity, RealmModel realm) {
        TypedQuery query = this.em.createNamedQuery("findUserByFederatedIdentityAndRealm", UserEntity.class);
        query.setParameter("realmId", (Object)realm.getId());
        query.setParameter("identityProvider", (Object)identity.getIdentityProvider());
        query.setParameter("userId", (Object)identity.getUserId());
        List results = query.getResultList();
        if (results.isEmpty()) {
            return null;
        }
        if (results.size() > 1) {
            throw new IllegalStateException("More results found for identityProvider=" + identity.getIdentityProvider() + ", userId=" + identity.getUserId() + ", results=" + results);
        }
        UserEntity user = (UserEntity)results.get(0);
        return new UserAdapter(this.session, realm, this.em, user);
    }

    public UserModel getServiceAccount(ClientModel client) {
        TypedQuery query = this.em.createNamedQuery("getRealmUserByServiceAccount", UserEntity.class);
        query.setParameter("realmId", (Object)client.getRealm().getId());
        query.setParameter("clientInternalId", (Object)client.getId());
        List results = query.getResultList();
        if (results.isEmpty()) {
            return null;
        }
        if (results.size() > 1) {
            throw new IllegalStateException("More service account linked users found for client=" + client.getClientId() + ", results=" + results);
        }
        UserEntity user = (UserEntity)results.get(0);
        return new UserAdapter(this.session, client.getRealm(), this.em, user);
    }

    public List<UserModel> getUsers(RealmModel realm, boolean includeServiceAccounts) {
        return this.getUsers(realm, -1, -1, includeServiceAccounts);
    }

    public int getUsersCount(RealmModel realm) {
        Object count = this.em.createNamedQuery("getRealmUserCount").setParameter("realmId", (Object)realm.getId()).getSingleResult();
        return ((Number)count).intValue();
    }

    public List<UserModel> getUsers(RealmModel realm) {
        return this.getUsers(realm, false);
    }

    public List<UserModel> getUsers(RealmModel realm, int firstResult, int maxResults) {
        return this.getUsers(realm, firstResult, maxResults, false);
    }

    public List<UserModel> getUsers(RealmModel realm, int firstResult, int maxResults, boolean includeServiceAccounts) {
        String queryName = includeServiceAccounts ? "getAllUsersByRealm" : "getAllUsersByRealmExcludeServiceAccount";
        TypedQuery query = this.em.createNamedQuery(queryName, UserEntity.class);
        query.setParameter("realmId", (Object)realm.getId());
        if (firstResult != -1) {
            query.setFirstResult(firstResult);
        }
        if (maxResults != -1) {
            query.setMaxResults(maxResults);
        }
        List results = query.getResultList();
        LinkedList<UserModel> users = new LinkedList<UserModel>();
        for (UserEntity entity : results) {
            users.add(new UserAdapter(this.session, realm, this.em, entity));
        }
        return users;
    }

    public List<UserModel> getGroupMembers(RealmModel realm, GroupModel group, int firstResult, int maxResults) {
        TypedQuery query = this.em.createNamedQuery("groupMembership", UserEntity.class);
        query.setParameter("groupId", (Object)group.getId());
        if (firstResult != -1) {
            query.setFirstResult(firstResult);
        }
        if (maxResults != -1) {
            query.setMaxResults(maxResults);
        }
        List results = query.getResultList();
        LinkedList<UserModel> users = new LinkedList<UserModel>();
        for (UserEntity user : results) {
            users.add(new UserAdapter(this.session, realm, this.em, user));
        }
        return users;
    }

    public List<UserModel> searchForUser(String search, RealmModel realm) {
        return this.searchForUser(search, realm, -1, -1);
    }

    public List<UserModel> searchForUser(String search, RealmModel realm, int firstResult, int maxResults) {
        TypedQuery query = this.em.createNamedQuery("searchForUser", UserEntity.class);
        query.setParameter("realmId", (Object)realm.getId());
        query.setParameter("search", (Object)("%" + search.toLowerCase() + "%"));
        if (firstResult != -1) {
            query.setFirstResult(firstResult);
        }
        if (maxResults != -1) {
            query.setMaxResults(maxResults);
        }
        List results = query.getResultList();
        LinkedList<UserModel> users = new LinkedList<UserModel>();
        for (UserEntity entity : results) {
            users.add(new UserAdapter(this.session, realm, this.em, entity));
        }
        return users;
    }

    public List<UserModel> searchForUser(Map<String, String> attributes, RealmModel realm) {
        return this.searchForUser(attributes, realm, -1, -1);
    }

    /*
     * WARNING - void declaration
     */
    public List<UserModel> searchForUser(Map<String, String> attributes, RealmModel realm, int firstResult, int maxResults) {
        StringBuilder builder = new StringBuilder("select u from UserEntity u where u.realmId = :realmId");
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            void var9_9;
            Object attribute = null;
            Object var9_10 = null;
            if (entry.getKey().equals(USERNAME)) {
                attribute = "lower(u.username)";
                String string = USERNAME;
            } else if (entry.getKey().equalsIgnoreCase(FIRST_NAME)) {
                attribute = "lower(u.firstName)";
                String string = FIRST_NAME;
            } else if (entry.getKey().equalsIgnoreCase(LAST_NAME)) {
                attribute = "lower(u.lastName)";
                String string = LAST_NAME;
            } else if (entry.getKey().equalsIgnoreCase(EMAIL)) {
                attribute = "lower(u.email)";
                String string = EMAIL;
            }
            if (attribute == null) continue;
            builder.append(" and ");
            builder.append((String)attribute).append(" like :").append((String)var9_9);
        }
        builder.append(" order by u.username");
        String q = builder.toString();
        TypedQuery query = this.em.createQuery(q, UserEntity.class);
        query.setParameter("realmId", (Object)realm.getId());
        for (Map.Entry entry : attributes.entrySet()) {
            String parameterName = null;
            if (((String)entry.getKey()).equals(USERNAME)) {
                parameterName = USERNAME;
            } else if (((String)entry.getKey()).equalsIgnoreCase(FIRST_NAME)) {
                parameterName = FIRST_NAME;
            } else if (((String)entry.getKey()).equalsIgnoreCase(LAST_NAME)) {
                parameterName = LAST_NAME;
            } else if (((String)entry.getKey()).equalsIgnoreCase(EMAIL)) {
                parameterName = EMAIL;
            }
            if (parameterName == null) continue;
            query.setParameter(parameterName, (Object)("%" + ((String)entry.getValue()).toLowerCase() + "%"));
        }
        if (firstResult != -1) {
            query.setFirstResult(firstResult);
        }
        if (maxResults != -1) {
            query.setMaxResults(maxResults);
        }
        List results = query.getResultList();
        ArrayList<UserModel> arrayList = new ArrayList<UserModel>();
        for (UserEntity entity : results) {
            arrayList.add(new UserAdapter(this.session, realm, this.em, entity));
        }
        return arrayList;
    }

    public List<UserModel> searchForUserByUserAttribute(String attrName, String attrValue, RealmModel realm) {
        TypedQuery query = this.em.createNamedQuery("getRealmUsersByAttributeNameAndValue", UserEntity.class);
        query.setParameter("name", (Object)attrName);
        query.setParameter("value", (Object)attrValue);
        query.setParameter("realmId", (Object)realm.getId());
        List results = query.getResultList();
        ArrayList<UserModel> users = new ArrayList<UserModel>();
        for (UserEntity user : results) {
            users.add(new UserAdapter(this.session, realm, this.em, user));
        }
        return users;
    }

    private FederatedIdentityEntity findFederatedIdentity(UserModel user, String identityProvider) {
        TypedQuery query = this.em.createNamedQuery("findFederatedIdentityByUserAndProvider", FederatedIdentityEntity.class);
        UserEntity userEntity = (UserEntity)this.em.getReference(UserEntity.class, (Object)user.getId());
        query.setParameter("user", (Object)userEntity);
        query.setParameter("identityProvider", (Object)identityProvider);
        List results = query.getResultList();
        return results.size() > 0 ? (FederatedIdentityEntity)results.get(0) : null;
    }

    public Set<FederatedIdentityModel> getFederatedIdentities(UserModel user, RealmModel realm) {
        TypedQuery query = this.em.createNamedQuery("findFederatedIdentityByUser", FederatedIdentityEntity.class);
        UserEntity userEntity = (UserEntity)this.em.getReference(UserEntity.class, (Object)user.getId());
        query.setParameter("user", (Object)userEntity);
        List results = query.getResultList();
        HashSet<FederatedIdentityModel> set = new HashSet<FederatedIdentityModel>();
        for (FederatedIdentityEntity entity : results) {
            set.add(new FederatedIdentityModel(entity.getIdentityProvider(), entity.getUserId(), entity.getUserName(), entity.getToken()));
        }
        return set;
    }

    public FederatedIdentityModel getFederatedIdentity(UserModel user, String identityProvider, RealmModel realm) {
        FederatedIdentityEntity entity = this.findFederatedIdentity(user, identityProvider);
        return entity != null ? new FederatedIdentityModel(entity.getIdentityProvider(), entity.getUserId(), entity.getUserName(), entity.getToken()) : null;
    }

    public void preRemove(RealmModel realm, ComponentModel component) {
        if (!component.getProviderType().equals(UserStorageProvider.class.getName())) {
            return;
        }
        this.removeImportedUsers(realm, component.getId());
    }

    public void updateCredential(RealmModel realm, UserModel user, CredentialModel cred) {
        CredentialEntity entity = (CredentialEntity)this.em.find(CredentialEntity.class, (Object)cred.getId());
        if (entity == null) {
            return;
        }
        entity.setAlgorithm(cred.getAlgorithm());
        entity.setCounter(cred.getCounter());
        entity.setCreatedDate(cred.getCreatedDate());
        entity.setDevice(cred.getDevice());
        entity.setDigits(cred.getDigits());
        entity.setHashIterations(cred.getHashIterations());
        entity.setPeriod(cred.getPeriod());
        entity.setSalt(cred.getSalt());
        entity.setType(cred.getType());
        entity.setValue(cred.getValue());
        if (!entity.getCredentialAttributes().isEmpty() || cred.getConfig() != null && !cred.getConfig().isEmpty()) {
            MultivaluedHashMap attrs = cred.getConfig();
            MultivaluedHashMap config = cred.getConfig();
            if (config == null) {
                config = new MultivaluedHashMap();
            }
            Iterator<CredentialAttributeEntity> it = entity.getCredentialAttributes().iterator();
            while (it.hasNext()) {
                CredentialAttributeEntity attr = it.next();
                List values = config.getList((Object)attr.getName());
                if (values == null || !values.contains(attr.getValue())) {
                    this.em.remove((Object)attr);
                    it.remove();
                    continue;
                }
                attrs.add((Object)attr.getName(), (Object)attr.getValue());
            }
            for (String key : config.keySet()) {
                List values = config.getList((Object)key);
                List attrValues = attrs.getList((Object)key);
                for (String val : values) {
                    if (attrValues != null && attrValues.contains(val)) continue;
                    CredentialAttributeEntity attr = new CredentialAttributeEntity();
                    attr.setId(KeycloakModelUtils.generateId());
                    attr.setValue(val);
                    attr.setName(key);
                    attr.setCredential(entity);
                    this.em.persist((Object)attr);
                    entity.getCredentialAttributes().add(attr);
                }
            }
        }
    }

    public CredentialModel createCredential(RealmModel realm, UserModel user, CredentialModel cred) {
        CredentialEntity entity = new CredentialEntity();
        String id = cred.getId() == null ? KeycloakModelUtils.generateId() : cred.getId();
        entity.setId(id);
        entity.setAlgorithm(cred.getAlgorithm());
        entity.setCounter(cred.getCounter());
        entity.setCreatedDate(cred.getCreatedDate());
        entity.setDevice(cred.getDevice());
        entity.setDigits(cred.getDigits());
        entity.setHashIterations(cred.getHashIterations());
        entity.setPeriod(cred.getPeriod());
        entity.setSalt(cred.getSalt());
        entity.setType(cred.getType());
        entity.setValue(cred.getValue());
        UserEntity userRef = (UserEntity)this.em.getReference(UserEntity.class, (Object)user.getId());
        entity.setUser(userRef);
        this.em.persist((Object)entity);
        MultivaluedHashMap config = cred.getConfig();
        if (config != null && !config.isEmpty()) {
            for (String key : config.keySet()) {
                List values = config.getList((Object)key);
                for (String val : values) {
                    CredentialAttributeEntity attr = new CredentialAttributeEntity();
                    attr.setId(KeycloakModelUtils.generateId());
                    attr.setValue(val);
                    attr.setName(key);
                    attr.setCredential(entity);
                    this.em.persist((Object)attr);
                    entity.getCredentialAttributes().add(attr);
                }
            }
        }
        return this.toModel(entity);
    }

    public boolean removeStoredCredential(RealmModel realm, UserModel user, String id) {
        CredentialEntity entity = (CredentialEntity)this.em.find(CredentialEntity.class, (Object)id);
        if (entity == null) {
            return false;
        }
        this.em.remove((Object)entity);
        return true;
    }

    public CredentialModel getStoredCredentialById(RealmModel realm, UserModel user, String id) {
        CredentialEntity entity = (CredentialEntity)this.em.find(CredentialEntity.class, (Object)id);
        if (entity == null) {
            return null;
        }
        CredentialModel model = this.toModel(entity);
        return model;
    }

    protected CredentialModel toModel(CredentialEntity entity) {
        CredentialModel model = new CredentialModel();
        model.setId(entity.getId());
        model.setType(entity.getType());
        model.setValue(entity.getValue());
        model.setAlgorithm(entity.getAlgorithm());
        model.setSalt(entity.getSalt());
        model.setPeriod(entity.getPeriod());
        model.setCounter(entity.getCounter());
        model.setCreatedDate(entity.getCreatedDate());
        model.setDevice(entity.getDevice());
        model.setDigits(entity.getDigits());
        model.setHashIterations(entity.getHashIterations());
        MultivaluedHashMap config = new MultivaluedHashMap();
        model.setConfig(config);
        for (CredentialAttributeEntity attr : entity.getCredentialAttributes()) {
            config.add((Object)attr.getName(), (Object)attr.getValue());
        }
        return model;
    }

    public List<CredentialModel> getStoredCredentials(RealmModel realm, UserModel user) {
        UserEntity userEntity = (UserEntity)this.em.getReference(UserEntity.class, (Object)user.getId());
        TypedQuery query = this.em.createNamedQuery("credentialByUser", CredentialEntity.class).setParameter("user", (Object)userEntity);
        List results = query.getResultList();
        LinkedList<CredentialModel> rtn = new LinkedList<CredentialModel>();
        for (CredentialEntity entity : results) {
            rtn.add(this.toModel(entity));
        }
        return rtn;
    }

    public List<CredentialModel> getStoredCredentialsByType(RealmModel realm, UserModel user, String type) {
        UserEntity userEntity = (UserEntity)this.em.getReference(UserEntity.class, (Object)user.getId());
        TypedQuery query = this.em.createNamedQuery("credentialByUserAndType", CredentialEntity.class).setParameter("type", (Object)type).setParameter("user", (Object)userEntity);
        List results = query.getResultList();
        LinkedList<CredentialModel> rtn = new LinkedList<CredentialModel>();
        for (CredentialEntity entity : results) {
            rtn.add(this.toModel(entity));
        }
        return rtn;
    }

    public CredentialModel getStoredCredentialByNameAndType(RealmModel realm, UserModel user, String name, String type) {
        UserEntity userEntity = (UserEntity)this.em.getReference(UserEntity.class, (Object)user.getId());
        TypedQuery query = this.em.createNamedQuery("credentialByNameAndType", CredentialEntity.class).setParameter("type", (Object)type).setParameter("device", (Object)name).setParameter("user", (Object)userEntity);
        List results = query.getResultList();
        if (results.isEmpty()) {
            return null;
        }
        return this.toModel((CredentialEntity)results.get(0));
    }

    protected void ensureEmailConstraint(List<UserEntity> users, RealmModel realm) {
        UserEntity user = users.get(0);
        if (users.size() > 1) {
            throw new ModelDuplicateException("Multiple users with email '" + user.getEmail() + "' exist in Keycloak.");
        }
        if (realm.isDuplicateEmailsAllowed()) {
            return;
        }
        if (user.getEmail() != null && !user.getEmail().equals(user.getEmailConstraint())) {
            user.setEmailConstraint(user.getEmail());
            this.em.persist((Object)user);
        }
    }
}

