/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.jpa.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.keycloak.authorization.jpa.entities.PolicyEntity;
import org.keycloak.authorization.jpa.entities.ResourceAttributeEntity;
import org.keycloak.authorization.jpa.entities.ResourceServerEntity;
import org.keycloak.authorization.jpa.entities.ScopeEntity;

@Entity
@Table(name="RESOURCE_SERVER_RESOURCE", uniqueConstraints={@UniqueConstraint(columnNames={"NAME", "RESOURCE_SERVER_ID", "OWNER"})})
@NamedQueries(value={@NamedQuery(name="findResourceIdByOwner", query="select r.id from ResourceEntity r where r.resourceServer.id = :serverId and r.owner = :owner"), @NamedQuery(name="findAnyResourceIdByOwner", query="select r.id from ResourceEntity r where r.owner = :owner"), @NamedQuery(name="findResourceIdByUri", query="select r.id from ResourceEntity r where  r.resourceServer.id = :serverId  and r.uri = :uri"), @NamedQuery(name="findResourceIdByName", query="select r.id from ResourceEntity r where  r.resourceServer.id = :serverId  and r.owner = :ownerId and r.name = :name"), @NamedQuery(name="findResourceIdByType", query="select r.id from ResourceEntity r where  r.resourceServer.id = :serverId  and r.owner = :ownerId and r.type = :type"), @NamedQuery(name="findResourceIdByServerId", query="select r.id from ResourceEntity r where  r.resourceServer.id = :serverId "), @NamedQuery(name="findResourceIdByScope", query="select r.id from ResourceEntity r inner join r.scopes s where r.resourceServer.id = :serverId and (s.resourceServer.id = :serverId and s.id in (:scopeIds))"), @NamedQuery(name="deleteResourceByResourceServer", query="delete from ResourceEntity r where r.resourceServer.id = :serverId")})
public class ResourceEntity {
    @Id
    @Column(name="ID", length=36)
    @Access(value=AccessType.PROPERTY)
    private String id;
    @Column(name="NAME")
    private String name;
    @Column(name="DISPLAY_NAME")
    private String displayName;
    @Column(name="URI")
    private String uri;
    @Column(name="TYPE")
    private String type;
    @Column(name="ICON_URI")
    private String iconUri;
    @Column(name="OWNER")
    private String owner;
    @Column(name="OWNER_MANAGED_ACCESS")
    private boolean ownerManagedAccess;
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="RESOURCE_SERVER_ID")
    private ResourceServerEntity resourceServer;
    @ManyToMany(fetch=FetchType.LAZY, cascade={})
    @JoinTable(name="RESOURCE_SCOPE", joinColumns={@JoinColumn(name="RESOURCE_ID")}, inverseJoinColumns={@JoinColumn(name="SCOPE_ID")})
    private List<ScopeEntity> scopes = new LinkedList<ScopeEntity>();
    @ManyToMany(fetch=FetchType.LAZY, cascade={})
    @JoinTable(name="RESOURCE_POLICY", joinColumns={@JoinColumn(name="RESOURCE_ID")}, inverseJoinColumns={@JoinColumn(name="POLICY_ID")})
    private List<PolicyEntity> policies = new LinkedList<PolicyEntity>();
    @OneToMany(cascade={CascadeType.REMOVE}, orphanRemoval=true, mappedBy="resource")
    @Fetch(value=FetchMode.SUBSELECT)
    private Collection<ResourceAttributeEntity> attributes = new ArrayList<ResourceAttributeEntity>();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<ScopeEntity> getScopes() {
        return this.scopes;
    }

    public String getIconUri() {
        return this.iconUri;
    }

    public void setIconUri(String iconUri) {
        this.iconUri = iconUri;
    }

    public ResourceServerEntity getResourceServer() {
        return this.resourceServer;
    }

    public void setResourceServer(ResourceServerEntity resourceServer) {
        this.resourceServer = resourceServer;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setOwnerManagedAccess(boolean ownerManagedAccess) {
        this.ownerManagedAccess = ownerManagedAccess;
    }

    public boolean isOwnerManagedAccess() {
        return this.ownerManagedAccess;
    }

    public List<PolicyEntity> getPolicies() {
        return this.policies;
    }

    public void setPolicies(List<PolicyEntity> policies) {
        this.policies = policies;
    }

    public Collection<ResourceAttributeEntity> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Collection<ResourceAttributeEntity> attributes) {
        this.attributes = attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceEntity that = (ResourceEntity)o;
        return this.getId().equals(that.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

