/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa.entities;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import org.keycloak.models.jpa.entities.UserEntity;

@NamedQueries(value={@NamedQuery(name="userMemberOf", query="select m from UserGroupMembershipEntity m where m.user = :user and m.groupId = :groupId"), @NamedQuery(name="userGroupMembership", query="select m from UserGroupMembershipEntity m where m.user = :user"), @NamedQuery(name="groupMembership", query="select g.user from UserGroupMembershipEntity g where g.groupId = :groupId order by g.user.username"), @NamedQuery(name="userGroupIds", query="select m.groupId from UserGroupMembershipEntity m where m.user = :user"), @NamedQuery(name="deleteUserGroupMembershipByRealm", query="delete from  UserGroupMembershipEntity mapping where mapping.user IN (select u from UserEntity u where u.realmId=:realmId)"), @NamedQuery(name="deleteUserGroupMembershipsByRealmAndLink", query="delete from  UserGroupMembershipEntity mapping where mapping.user IN (select u from UserEntity u where u.realmId=:realmId and u.federationLink=:link)"), @NamedQuery(name="deleteUserGroupMembershipsByGroup", query="delete from UserGroupMembershipEntity m where m.groupId = :groupId"), @NamedQuery(name="deleteUserGroupMembershipsByUser", query="delete from UserGroupMembershipEntity m where m.user = :user")})
@Table(name="USER_GROUP_MEMBERSHIP")
@Entity
@IdClass(value=Key.class)
public class UserGroupMembershipEntity {
    @Id
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="USER_ID")
    protected UserEntity user;
    @Id
    @Column(name="GROUP_ID")
    protected String groupId;

    public UserEntity getUser() {
        return this.user;
    }

    public void setUser(UserEntity user) {
        this.user = user;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof UserGroupMembershipEntity)) {
            return false;
        }
        UserGroupMembershipEntity key = (UserGroupMembershipEntity)o;
        if (!this.groupId.equals(key.groupId)) {
            return false;
        }
        return this.user.equals(key.user);
    }

    public int hashCode() {
        int result = this.user.hashCode();
        result = 31 * result + this.groupId.hashCode();
        return result;
    }

    public static class Key
    implements Serializable {
        protected UserEntity user;
        protected String groupId;

        public Key() {
        }

        public Key(UserEntity user, String groupId) {
            this.user = user;
            this.groupId = groupId;
        }

        public UserEntity getUser() {
            return this.user;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (!this.groupId.equals(key.groupId)) {
                return false;
            }
            return this.user.equals(key.user);
        }

        public int hashCode() {
            int result = this.user.hashCode();
            result = 31 * result + this.groupId.hashCode();
            return result;
        }
    }
}

