/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.jpa.entity;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import org.keycloak.storage.jpa.KeyUtils;

@NamedQueries(value={@NamedQuery(name="feduserHasRole", query="select m from FederatedUserRoleMappingEntity m where m.userId = :userId and m.roleId = :roleId"), @NamedQuery(name="feduserRoleMappings", query="select m from FederatedUserRoleMappingEntity m where m.userId = :userId"), @NamedQuery(name="deleteFederatedUserRoleMappingsByRealm", query="delete from  FederatedUserRoleMappingEntity mapping where mapping.realmId=:realmId"), @NamedQuery(name="deleteFederatedUserRoleMappingsByStorageProvider", query="delete from FederatedUserRoleMappingEntity e where e.storageProviderId=:storageProviderId"), @NamedQuery(name="deleteFederatedUserRoleMappingsByRealmAndLink", query="delete from  FederatedUserRoleMappingEntity mapping where mapping.userId IN (select u.id from UserEntity u where u.realmId=:realmId and u.federationLink=:link)"), @NamedQuery(name="deleteFederatedUserRoleMappingsByRole", query="delete from FederatedUserRoleMappingEntity m where m.roleId = :roleId"), @NamedQuery(name="deleteFederatedUserRoleMappingsByUser", query="delete from FederatedUserRoleMappingEntity m where m.userId = :userId and m.realmId = :realmId")})
@Table(name="FED_USER_ROLE_MAPPING")
@Entity
@IdClass(value=Key.class)
public class FederatedUserRoleMappingEntity {
    @Id
    @Column(name="USER_ID")
    protected String userId;
    @Id
    @Column(name="ROLE_ID")
    protected String roleId;
    @Column(name="REALM_ID")
    protected String realmId;
    @Column(name="STORAGE_PROVIDER_ID")
    protected String storageProviderId;

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        KeyUtils.assertValidKey(userId);
        this.userId = userId;
    }

    public String getRealmId() {
        return this.realmId;
    }

    public void setRealmId(String realmId) {
        this.realmId = realmId;
    }

    public String getStorageProviderId() {
        return this.storageProviderId;
    }

    public void setStorageProviderId(String storageProviderId) {
        this.storageProviderId = storageProviderId;
    }

    public String getRoleId() {
        return this.roleId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof FederatedUserRoleMappingEntity)) {
            return false;
        }
        FederatedUserRoleMappingEntity key = (FederatedUserRoleMappingEntity)o;
        if (!this.roleId.equals(key.roleId)) {
            return false;
        }
        return this.userId.equals(key.userId);
    }

    public int hashCode() {
        int result = this.userId.hashCode();
        result = 31 * result + this.roleId.hashCode();
        return result;
    }

    public static class Key
    implements Serializable {
        protected String userId;
        protected String roleId;

        public Key() {
        }

        public Key(String userId, String roleId) {
            this.userId = userId;
            this.roleId = roleId;
        }

        public String getUserId() {
            return this.userId;
        }

        public String getRoleId() {
            return this.roleId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (!this.roleId.equals(key.roleId)) {
                return false;
            }
            return this.userId.equals(key.userId);
        }

        public int hashCode() {
            int result = this.userId.hashCode();
            result = 31 * result + this.roleId.hashCode();
            return result;
        }
    }
}

