/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa.entities;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import org.keycloak.models.jpa.entities.UserEntity;

@NamedQueries(value={@NamedQuery(name="findFederatedIdentityByUser", query="select link from FederatedIdentityEntity link where link.user = :user"), @NamedQuery(name="findFederatedIdentityByUserAndProvider", query="select link from FederatedIdentityEntity link where link.user = :user and link.identityProvider = :identityProvider"), @NamedQuery(name="findUserByFederatedIdentityAndRealm", query="select link.user from FederatedIdentityEntity link where link.realmId = :realmId and link.identityProvider = :identityProvider and link.userId = :userId"), @NamedQuery(name="deleteFederatedIdentityByRealm", query="delete from FederatedIdentityEntity social where social.user IN (select u from UserEntity u where realmId=:realmId)"), @NamedQuery(name="deleteFederatedIdentityByRealmAndLink", query="delete from FederatedIdentityEntity social where social.user IN (select u from UserEntity u where realmId=:realmId and u.federationLink=:link)"), @NamedQuery(name="deleteFederatedIdentityByUser", query="delete from FederatedIdentityEntity social where social.user = :user")})
@Table(name="FEDERATED_IDENTITY")
@Entity
@IdClass(value=Key.class)
public class FederatedIdentityEntity {
    @Id
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="USER_ID")
    private UserEntity user;
    @Column(name="REALM_ID")
    protected String realmId;
    @Id
    @Column(name="IDENTITY_PROVIDER")
    protected String identityProvider;
    @Column(name="FEDERATED_USER_ID")
    protected String userId;
    @Column(name="FEDERATED_USERNAME")
    protected String userName;
    @Column(name="TOKEN")
    protected String token;

    public UserEntity getUser() {
        return this.user;
    }

    public void setUser(UserEntity user) {
        this.user = user;
    }

    public String getIdentityProvider() {
        return this.identityProvider;
    }

    public void setIdentityProvider(String identityProvider) {
        this.identityProvider = identityProvider;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getRealmId() {
        return this.realmId;
    }

    public void setRealmId(String realmId) {
        this.realmId = realmId;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getToken() {
        return this.token;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof FederatedIdentityEntity)) {
            return false;
        }
        FederatedIdentityEntity key = (FederatedIdentityEntity)o;
        if (this.identityProvider != null ? !this.identityProvider.equals(key.identityProvider) : key.identityProvider != null) {
            return false;
        }
        return !(this.user != null ? !this.user.getId().equals(key.user != null ? key.user.getId() : null) : key.user != null);
    }

    public int hashCode() {
        int result = this.user != null ? this.user.getId().hashCode() : 0;
        result = 31 * result + (this.identityProvider != null ? this.identityProvider.hashCode() : 0);
        return result;
    }

    public static class Key
    implements Serializable {
        protected UserEntity user;
        protected String identityProvider;

        public Key() {
        }

        public Key(UserEntity user, String identityProvider) {
            this.user = user;
            this.identityProvider = identityProvider;
        }

        public UserEntity getUser() {
            return this.user;
        }

        public String getIdentityProvider() {
            return this.identityProvider;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (this.identityProvider != null ? !this.identityProvider.equals(key.identityProvider) : key.identityProvider != null) {
                return false;
            }
            return !(this.user != null ? !this.user.getId().equals(key.user != null ? key.user.getId() : null) : key.user != null);
        }

        public int hashCode() {
            int result = this.user != null ? this.user.getId().hashCode() : 0;
            result = 31 * result + (this.identityProvider != null ? this.identityProvider.hashCode() : 0);
            return result;
        }
    }
}

