/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.file.yaml;

import java.io.Closeable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Optional;
import java.util.function.Consumer;
import org.keycloak.models.map.storage.file.common.WritingMechanism;
import org.keycloak.models.map.storage.file.yaml.RunOnlyOnce;
import org.snakeyaml.engine.v2.common.FlowStyle;
import org.snakeyaml.engine.v2.common.ScalarStyle;
import org.snakeyaml.engine.v2.events.DocumentEndEvent;
import org.snakeyaml.engine.v2.events.DocumentStartEvent;
import org.snakeyaml.engine.v2.events.Event;
import org.snakeyaml.engine.v2.events.ImplicitTuple;
import org.snakeyaml.engine.v2.events.MappingEndEvent;
import org.snakeyaml.engine.v2.events.MappingStartEvent;
import org.snakeyaml.engine.v2.events.ScalarEvent;
import org.snakeyaml.engine.v2.events.SequenceEndEvent;
import org.snakeyaml.engine.v2.events.SequenceStartEvent;
import org.snakeyaml.engine.v2.events.StreamEndEvent;
import org.snakeyaml.engine.v2.events.StreamStartEvent;
import org.snakeyaml.engine.v2.nodes.Tag;

public class YamlWritingMechanism
implements WritingMechanism,
Closeable {
    private final ImplicitTuple implicitTuple = new ImplicitTuple(true, true);
    private final Consumer<Event> consumer;
    private boolean runningPreTasks = false;
    private final LinkedList<RunOnlyOnce> preTasks = new RunOnlyOnce.List();

    public YamlWritingMechanism(Consumer<Event> consumer) {
        this.consumer = consumer;
        this.preTasks.add(new RunOnlyOnce(this::startDocument, this::endDocument));
    }

    @Override
    public void close() {
        this.endDocument();
    }

    @Override
    public YamlWritingMechanism writeMapping(Runnable task) {
        return this.writeObject(task, this::startMapping, this::endMapping);
    }

    @Override
    public YamlWritingMechanism writeSequence(Runnable task) {
        return this.writeObject(task, this::startSequence, this::endSequence);
    }

    @Override
    public YamlWritingMechanism writePair(String key, Runnable task) {
        return this.writeObject(task, () -> this.writeObject(key), null);
    }

    @Override
    public YamlWritingMechanism writeObject(Object value) {
        if (!this.runningPreTasks) {
            this.runningPreTasks = true;
            this.preTasks.forEach(RunOnlyOnce::run);
            this.runningPreTasks = false;
        }
        this.consumer.accept((Event)new ScalarEvent(Optional.empty(), this.determineTag(value), this.implicitTuple, value == null ? "null" : value.toString(), this.determineStyle(value)));
        return this;
    }

    private void startDocument() {
        this.consumer.accept((Event)new StreamStartEvent());
        this.consumer.accept((Event)new DocumentStartEvent(false, Optional.empty(), Collections.emptyMap()));
    }

    private void endDocument() {
        this.consumer.accept((Event)new DocumentEndEvent(false));
        this.consumer.accept((Event)new StreamEndEvent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private YamlWritingMechanism writeObject(Runnable taskWithOptionalWrite, Runnable preWriteTask, Runnable postWriteTask) {
        RunOnlyOnce roo = new RunOnlyOnce(preWriteTask, postWriteTask);
        try {
            this.preTasks.addLast(roo);
            taskWithOptionalWrite.run();
        }
        finally {
            this.preTasks.removeLast();
        }
        return this;
    }

    private void startSequence() {
        this.consumer.accept((Event)new SequenceStartEvent(Optional.empty(), Optional.of(Tag.SEQ.getValue()), true, FlowStyle.BLOCK));
    }

    private void endSequence() {
        this.consumer.accept((Event)new SequenceEndEvent());
    }

    private void startMapping() {
        this.consumer.accept((Event)new MappingStartEvent(Optional.empty(), Optional.of(Tag.MAP.getValue()), true, FlowStyle.BLOCK));
    }

    private void endMapping() {
        this.consumer.accept((Event)new MappingEndEvent());
    }

    private Optional<String> determineTag(Object value) {
        if (value instanceof String) {
            return Optional.of(Tag.STR.getValue());
        }
        if (value instanceof Boolean) {
            return Optional.of(Tag.BOOL.getValue());
        }
        if (value instanceof Integer || value instanceof Long || value instanceof BigInteger) {
            return Optional.of(Tag.INT.getValue());
        }
        if (value instanceof Float || value instanceof Double || value instanceof BigDecimal) {
            return Optional.of(Tag.FLOAT.getValue());
        }
        if (value == null) {
            return Optional.of(Tag.NULL.getValue());
        }
        return Optional.empty();
    }

    private ScalarStyle determineStyle(Object value) {
        if (value instanceof String) {
            String sValue = (String)value;
            if ("null".equals(sValue)) {
                return ScalarStyle.DOUBLE_QUOTED;
            }
            if (sValue.length() > 120 || sValue.lastIndexOf(10) > 0) {
                return ScalarStyle.FOLDED;
            }
        }
        return ScalarStyle.PLAIN;
    }
}

